<?php
// $Id: contact.inc,v 1.1.2.1 2009/10/12 23:17:18 merlinofchaos Exp $

/**
 * Callback function to supply a list of content types.
 */
function ctools_contact_ctools_content_types() {
  if (!module_exists('contact')) {
    return;
  }

  return array(
    'single' => TRUE,
    'title' => t('Contact form'),
    'icon' => 'icon_contact.png',
    'description' => t('The site contact form that allows users to send a message to site administrators.'),
    'category' => t('Widgets'),
  );
}

/**
 * Render the custom content type.
 */
function ctools_contact_content_type_render($subtype, $conf, $panel_args, $context) {
  if (!user_access('access site-wide contact form')) {
    return;
  }
  // Build the content type block.
  $block = new stdClass();
  $block->module  = 'contact';
  $block->delta   = 'form';
  $block->title   = t('Contact');

  module_load_include('inc', 'contact', 'contact.pages');
  $block->content = contact_site_page();
  return $block;
}

/**
 * Returns an edit form for custom type settings.
 */
function ctools_contact_content_type_edit_form(&$form, &$form_state) {
  // Empty so that we can have title override.
}

/**
 * Submit handler for contact form.
 */
function ctools_contact_content_type_edit_form_submit(&$form, &$form_state) {
  // Copy everything from our defaults.
/*
  foreach (array_keys($form_state['plugin']['defaults']) as $key) {
    $form_state['conf'][$key] = $form_state['values'][$key];
  }
*/
}

/**
 * Returns the administrative title for a type.
 */
function ctools_contact_content_type_admin_title($subtype, $conf, $context) {
  return t('Contact form');
}
