# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.
#
# Authors: Olivier Tilloy <olivier@fluendo.com>
#          Benjamin Kampmann <benjamin@fluendo.com>

"""
Capabilities are additional services built on top of resource providers.
"""

from elisa.core.component import Component


class Capability(Component):

    """
    A capability is an additional service built on top of a resource provider,
    such as metadata retrieval or advanced search facilities. Because of this
    a capability always has a reference to a
    L{elisa.core.components.resource_provider.ResourceProvider}.

    Each capability's API is tailored for specific needs.
    That API is used by a corresponding L{elisa.core.manager.Manager} that
    decides on the capabilities to forward the request to.
    A capability translates such a request into a call to its provider's API.

    @ivar provider: the provider this capability belongs to
    @type provider: L{elisa.core.components.resource_provider.ResourceProvider}
    """
