# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.

from elisa.core.common import application

from elisa.plugins.pigment.graph.node import Node

from elisa.plugins.poblesec.widgets.loading_animation import LoadingAnimation

from elisa.plugins.pigment.animation.implicit import AnimatedObject


class LoadableMixin(Node):

    """
    Add loading animation feedback functionality to widgets.
    """

    loading_attribute = None

    def __init__(self, *args, **kwargs):
        super(LoadableMixin, self).__init__(*args, **kwargs)

        self._icon = None
        self._animated_icon = None

        self._animation = None

        self._allow_animation = True
        self._loading = False

    def activate(self, previous=None):
        if self.loading_attribute:
            self._icon = getattr(self, self.loading_attribute, None)

        if not self._icon:
            return

        if previous and previous != self:
            previous.toggle_loading_animation(False)

        if previous != self:
            self._allow_animation = True
            if self._animated_icon is not None:
                self._animated_icon.stop_animations()
            self._animated_icon = AnimatedObject(self._icon)
            settings = {'end_callback': lambda ctrl: self.toggle_loading_animation(True),
                        'duration': 400}
            self._animated_icon.setup_next_animations(**settings)
            self._animated_icon.opacity = 0

            if self._animation is not None:
                self._animation.clean()
            self._loading = False

            self._create_animation()

    def _create_animation(self):
        self._animation = LoadingAnimation()
        self.add(self._animation)

        if self.loading_attribute:
            self._icon = getattr(self, self.loading_attribute, None)

        if self._icon is not None:
            self._animation.size = self._icon.size
            self._animation.position = self._icon.position

    def toggle_loading_animation(self, enabled):
        if enabled and self._allow_animation:
            if self._loading:
                return

            if self._animation is None:
                self._create_animation()

            self._loading = True
            self._animation.activate(True)
            self._animation.visible = True
        else:
            if self._animation is None:
                return

            self._allow_animation = False
            self._loading = False
            self._animation.activate(False)
            self._animation.visible = False

            if self._icon is not None:
                self._animated_icon.setup_next_animations(duration=400)
                self._animated_icon.opacity = 255

    def clean(self):
        if self._animation is not None:
            self._animation.clean()
            self._animation = None

        if self._animated_icon is not None:
            self._animated_icon.stop_animations()
            self._animated_icon = None

        return super(LoadableMixin, self).clean()
