# -*- coding: utf-8 -*-
# -----------------------------------------------------------------------
# Copyright (c) 2009  Jendrik Seipp
# 
# RedNotebook is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# RedNotebook is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along
# with RedNotebook; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
# -----------------------------------------------------------------------

import datetime


oneDay = datetime.timedelta(days=1)
		
def getYearAndMonthFromDate(date):
	yearAndMonth = date.strftime('%Y-%m')
	assert len(yearAndMonth) == 7
	return yearAndMonth

def get_date_from_date_string(dateString):
	dateArray = dateString.split('-')
	year, month, day = map(int, dateArray)
	return datetime.date(year, month, day)

# Number of days per month (except for February in leap years)
month_days = [0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31]

def isleap(year):
	"""Return 1 for leap years, 0 for non-leap years."""
	return year % 4 == 0 and (year % 100 != 0 or year % 400 == 0)

def get_number_of_days(year, month):
	days = month_days[month] + (month == 2 and isleap(year))
	return days




   
  
