/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.pad;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.filechooser.FileFilter;
import org.jgraph.pad.GraphModelFileFormat;
import org.jgraph.pad.GraphModelProvider;

public class GraphModelProviderRegistry {
    protected static Vector graphModelProviders = new Vector();
    protected static Vector graphModelFileFormats = new Vector();

    public static void addGraphModelProvider(GraphModelProvider graphModelProvider) {
        graphModelProviders.add(graphModelProvider);
        GraphModelFileFormat[] graphModelFileFormatArray = graphModelProvider.getGraphModelFileFormats();
        int n = 0;
        while (n < graphModelFileFormatArray.length) {
            graphModelFileFormats.add(graphModelFileFormatArray[n]);
            ++n;
        }
    }

    public static void removeGraphModelProvider(GraphModelProvider graphModelProvider) {
        graphModelProviders.remove(graphModelProvider);
        GraphModelFileFormat[] graphModelFileFormatArray = graphModelProvider.getGraphModelFileFormats();
        int n = 0;
        while (n < graphModelFileFormatArray.length) {
            graphModelFileFormats.remove(graphModelFileFormatArray[n]);
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GraphModelProvider[] getGraphModelProviders() {
        Vector vector = graphModelProviders;
        synchronized (vector) {
            GraphModelProvider[] graphModelProviderArray = new GraphModelProvider[graphModelProviders.size()];
            int n = 0;
            while (n < graphModelProviders.size()) {
                graphModelProviderArray[n] = (GraphModelProvider)graphModelProviders.get(n);
                ++n;
            }
            return graphModelProviderArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GraphModelFileFormat[] getGraphModelFileFormats() {
        Vector vector = graphModelFileFormats;
        synchronized (vector) {
            GraphModelFileFormat[] graphModelFileFormatArray = new GraphModelFileFormat[graphModelFileFormats.size()];
            int n = 0;
            while (n < graphModelFileFormats.size()) {
                graphModelFileFormatArray[n] = (GraphModelFileFormat)graphModelFileFormats.get(n);
                ++n;
            }
            return graphModelFileFormatArray;
        }
    }

    public static GraphModelProvider getGraphModelProvider(String string) {
        return GraphModelProviderRegistry.getGraphModelProvider(new File(string));
    }

    public static GraphModelProvider getGraphModelProvider(File file) {
        Enumeration enumeration = graphModelProviders.elements();
        while (enumeration.hasMoreElements()) {
            GraphModelProvider graphModelProvider = (GraphModelProvider)enumeration.nextElement();
            GraphModelFileFormat[] graphModelFileFormatArray = graphModelProvider.getGraphModelFileFormats();
            int n = 0;
            while (n < graphModelFileFormatArray.length) {
                GraphModelFileFormat graphModelFileFormat = graphModelFileFormatArray[n];
                if (graphModelFileFormat.getFileFilter().accept(file)) {
                    return graphModelProvider;
                }
                ++n;
            }
        }
        return null;
    }

    public static GraphModelFileFormat getGraphModelFileFormat(String string) {
        return GraphModelProviderRegistry.getGraphModelFileFormat(new File(string));
    }

    public static GraphModelFileFormat getGraphModelFileFormat(File file) {
        Enumeration enumeration = graphModelFileFormats.elements();
        while (enumeration.hasMoreElements()) {
            GraphModelFileFormat graphModelFileFormat = (GraphModelFileFormat)enumeration.nextElement();
            if (!graphModelFileFormat.getFileFilter().accept(file)) continue;
            return graphModelFileFormat;
        }
        return null;
    }

    public static GraphModelFileFormat getGraphModelFileFormat(FileFilter fileFilter) {
        Enumeration enumeration = graphModelFileFormats.elements();
        while (enumeration.hasMoreElements()) {
            GraphModelFileFormat graphModelFileFormat = (GraphModelFileFormat)enumeration.nextElement();
            if (graphModelFileFormat.getFileFilter() != fileFilter) continue;
            return graphModelFileFormat;
        }
        return null;
    }
}

