/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.pad.actions;

import Acme.JPM.Encoders.GifEncoder;
import com.eteks.filter.Web216ColorsFilter;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jgraph.GPGraphpad;
import org.jgraph.pad.GPConverter;
import org.jgraph.pad.actions.AbstractActionFile;
import org.jgraph.pad.resources.Translator;

public class FileExportGIF
extends AbstractActionFile {
    protected transient String fileType = "gif";

    public FileExportGIF(GPGraphpad gPGraphpad) {
        this(gPGraphpad, "gif");
    }

    public FileExportGIF(GPGraphpad gPGraphpad, String string) {
        super(gPGraphpad);
        this.fileType = string;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            String string = this.saveDialog(Translator.getString("FileSaveAsLabel") + " " + this.fileType.toUpperCase(), this.fileType.toLowerCase(), this.fileType.toUpperCase() + " Image");
            if (this.getCurrentDocument().getModel().getRootCount() > 0) {
                BufferedImage bufferedImage = GPConverter.toImage(this.getCurrentGraph());
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                fileOutputStream.write(FileExportGIF.convertToGif(bufferedImage));
                fileOutputStream.flush();
                fileOutputStream.close();
            }
        }
        catch (IOException iOException) {
            this.graphpad.error(iOException.getMessage());
        }
    }

    public static byte[] convertToGif(Image image) throws IOException {
        Graphics graphics = image.getGraphics();
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            new GifEncoder(image, (OutputStream)byteArrayOutputStream).encode();
        }
        catch (IOException iOException) {
            FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), new Web216ColorsFilter());
            byteArrayOutputStream = new ByteArrayOutputStream();
            new GifEncoder(filteredImageSource, (OutputStream)byteArrayOutputStream).encode();
        }
        return byteArrayOutputStream.toByteArray();
    }
}

