/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.pad.actions;

import java.awt.Rectangle;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.jgraph.GPGraphpad;
import org.jgraph.graph.CellView;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.pad.actions.AbstractActionList;
import org.jgraph.pad.actions.AbstractActionListCell;
import org.jgraph.pad.resources.Translator;
import org.jgraph.utils.Utilities;

public class FormatLinePatternList
extends AbstractActionListCell {
    protected static Object[] patterns = new Object[]{new float[]{4.0f, 2.0f}, new float[]{4.0f, 4.0f}, new float[]{8.0f, 2.0f}, new float[]{8.0f, 4.0f}, new float[]{4.0f, 4.0f, 16.0f, 4.0f}};

    public FormatLinePatternList(GPGraphpad gPGraphpad) {
        block3: {
            super(gPGraphpad);
            String string = Translator.getString("Patterns");
            if (string == null) break block3;
            try {
                String[] stringArray = AbstractActionList.tokenize(string);
                patterns = new Object[stringArray.length];
                int n = 0;
                while (n < stringArray.length) {
                    String string2 = stringArray[n].toString();
                    FormatLinePatternList.patterns[n] = FormatLinePatternList.parsePattern(string2);
                    ++n;
                }
            }
            catch (Exception exception) {}
        }
    }

    protected void fillCustomItems(Vector vector) {
        int n = 0;
        while (n < patterns.length) {
            EdgeView edgeView = new EdgeView(" ", AbstractActionListCell.dummyGraph, AbstractActionListCell.dummyGraph.getGraphLayoutCache());
            Map map = GraphConstants.createMap();
            GraphConstants.setPoints(map, arrowPoints);
            GraphConstants.setBounds(map, new Rectangle(this.point, this.size));
            GraphConstants.setDashPattern(map, (float[])patterns[n]);
            GraphConstants.setLabelPosition(map, AbstractActionList.center);
            edgeView.setAttributes(map);
            vector.add(edgeView);
            ++n;
        }
    }

    protected void fillResetMap(Map map) {
        map.remove("dashPattern");
    }

    protected void fillApplyMap(CellView cellView, Map map) {
        GraphConstants.setDashPattern(map, GraphConstants.getDashPattern(cellView.getAttributes()));
    }

    protected void selectAndFillMap(Map map) {
        try {
            String string = JOptionPane.showInputDialog(Translator.getString("PatternDialog"));
            float[] fArray = Utilities.parsePattern(string);
            if (fArray != null) {
                GraphConstants.setDashPattern(map, fArray);
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception exception) {
            this.graphpad.error(exception.toString());
        }
    }

    protected static float[] parsePattern(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        float[] fArray = new float[stringTokenizer.countTokens()];
        if (fArray.length > 0) {
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                fArray[n++] = Float.parseFloat(stringTokenizer.nextToken());
            }
        }
        return fArray;
    }
}

