/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.pad.actions;

import java.awt.event.ActionEvent;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jgraph.GPGraphpad;
import org.jgraph.pad.actions.AbstractActionRadioButton;

public class ToolsLookAndFeel
extends AbstractActionRadioButton {
    protected UIManager.LookAndFeelInfo[] lookAndFeels = null;

    public ToolsLookAndFeel(GPGraphpad gPGraphpad) {
        super(gPGraphpad);
        this.lastActionCommand = UIManager.getLookAndFeel().getClass().getName();
    }

    public String[] getPossibleActionCommands() {
        if (this.lookAndFeels == null) {
            this.lookAndFeels = UIManager.getInstalledLookAndFeels();
        }
        String[] stringArray = new String[this.lookAndFeels.length];
        int n = 0;
        while (n < this.lookAndFeels.length) {
            UIManager.LookAndFeelInfo lookAndFeelInfo = this.lookAndFeels[n];
            stringArray[n] = lookAndFeelInfo.getClassName();
            ++n;
        }
        return stringArray;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.lastActionCommand = actionEvent.getActionCommand();
        try {
            UIManager.setLookAndFeel(actionEvent.getActionCommand());
            SwingUtilities.updateComponentTreeUI(this.graphpad.getFrame());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.update();
    }

    public void update() {
        Enumeration enumeration = this.abstractButtons.elements();
        while (enumeration.hasMoreElements()) {
            AbstractButton abstractButton = (AbstractButton)enumeration.nextElement();
            abstractButton.setSelected(this.isSelected(abstractButton.getActionCommand()));
        }
    }

    public String getPresentationText(String string) {
        if (string == null) {
            return null;
        }
        int n = 0;
        while (n < this.lookAndFeels.length) {
            if (this.lookAndFeels[n].getClassName().equals(string)) {
                return this.lookAndFeels[n].getName();
            }
            ++n;
        }
        return string;
    }
}

