/*
 * Decompiled with CFR 0.152.
 */
package br.arca.morcego.structure.node;

import br.arca.morcego.Config;
import br.arca.morcego.run.Renderer;
import br.arca.morcego.structure.Graph;
import br.arca.morcego.structure.Node;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class RoundNode
extends Node {
    private int textSize;

    public void proj() {
        super.proj();
        this.textSize = (int)Math.round((double)Config.getInteger("morcego.textSize") * (double)this.getBody().getScale());
        if (this.centered()) {
            this.textSize = (int)((double)this.textSize * 1.5);
        }
    }

    public RoundNode(String id, Graph graph) {
        super(id, graph);
    }

    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D graphic = (Graphics2D)g;
        graphic.setColor(Renderer.fadeColor((Color)this.getProperty("color"), this.getBody().getScale()));
        graphic.fillOval(this.boundRectangle.x, this.boundRectangle.y, this.nodeSize, this.nodeSize);
        graphic.setColor(Renderer.fadeColor(Config.getColor("morcego.nodeBorderColor"), this.getBody().getScale()));
        graphic.drawOval(this.boundRectangle.x, this.boundRectangle.y, this.nodeSize, this.nodeSize);
        AffineTransform at = new AffineTransform(40.0f, 0.0f, 0.0f, 4.0f, 0.0f, 0.0f);
        FontRenderContext frc = new FontRenderContext(at, false, false);
        int interval = Config.getInteger("morcego.fontSizeInterval");
        Font font = new Font(null, 0, this.textSize / interval * interval);
        TextLayout l = new TextLayout(this.id, font, frc);
        Rectangle2D textBounds = l.getBounds();
        l.draw(graphic, (int)((double)this.getBody().projection.x - textBounds.getWidth() / 2.0), this.boundRectangle.y);
    }
}

