/*
 * Decompiled with CFR 0.152.
 */
package br.arca.morcego;

import br.arca.morcego.Config;

public class SpeedVector {
    public int x;
    public int y;
    public int z;
    private float fx;
    private float fy;
    private float fz;

    public SpeedVector(int xi, int yi, int zi) {
        this.x = xi;
        this.y = yi;
        this.z = zi;
        this.fx = this.x;
        this.fy = this.y;
        this.fz = this.z;
    }

    public SpeedVector(float xi, float yi, float zi) {
        this.fx = xi;
        this.fy = yi;
        this.fz = zi;
        this.makeInteger();
    }

    public SpeedVector(double xi, double yi, double zi) {
        this.fx = (float)xi;
        this.fy = (float)yi;
        this.fz = (float)zi;
        this.makeInteger();
    }

    public void add(SpeedVector s) {
        this.fx += s.fx;
        this.fy += s.fy;
        this.fz += s.fz;
        this.makeInteger();
    }

    public void clear() {
        this.z = 0;
        this.y = 0;
        this.x = 0;
        this.fz = 0.0f;
        this.fy = 0.0f;
        this.fx = 0.0f;
    }

    public void resize(float module) {
        this.fx *= module;
        this.fy *= module;
        this.fz *= module;
        this.makeInteger();
    }

    private void makeInteger() {
        this.x = (int)Math.ceil(this.fx);
        this.y = (int)Math.ceil(this.fy);
        this.z = (int)Math.ceil(this.fz);
    }

    public SpeedVector reverse() {
        return new SpeedVector(-this.fx, -this.fy, -this.fz);
    }

    public float module() {
        return (float)Math.sqrt(this.fx * this.fx + this.fy * this.fy + this.fz * this.fz);
    }

    public boolean opposed(SpeedVector s) {
        return this.x * s.x + this.y * s.y + this.z * s.z < 0;
    }

    public boolean isTooLow() {
        int distance = (Integer)Config.getValue("linkedNodesDistance");
        return (double)this.module() < Math.pow(distance, 0.33f);
    }
}

