/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.util;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class IPNetwork {
    protected InetAddress addr;
    protected InetAddress mask;

    public IPNetwork(String addr, String mask) throws UnknownHostException {
        this.addr = InetAddress.getByName(addr);
        this.mask = InetAddress.getByName(mask);
    }

    public IPNetwork(String addrMask) throws IllegalArgumentException, NumberFormatException, UnknownHostException {
        int slashIdx = addrMask.indexOf("/");
        if (slashIdx < 0) {
            throw new IllegalArgumentException("Couldn't find '/' in argument string.");
        }
        String addrString = addrMask.substring(0, slashIdx);
        this.addr = InetAddress.getByName(addrString);
        String maskString = addrMask.substring(slashIdx + 1, addrMask.length());
        int maskInt = Integer.parseInt(maskString);
        int[] myMask = new int[4];
        for (int i = 0; i < 4; ++i) {
            if (maskInt <= 0) {
                myMask[i] = 0;
            } else if (maskInt == 1) {
                myMask[i] = 128;
            } else if (maskInt == 2) {
                myMask[i] = 192;
            } else if (maskInt == 3) {
                myMask[i] = 224;
            } else if (maskInt == 4) {
                myMask[i] = 240;
            } else if (maskInt == 5) {
                myMask[i] = 248;
            } else if (maskInt == 6) {
                myMask[i] = 252;
            } else if (maskInt == 7) {
                myMask[i] = 254;
            } else if (maskInt >= 8) {
                myMask[i] = 255;
            }
            maskInt -= 8;
        }
        this.mask = InetAddress.getByName(myMask[0] + "." + myMask[1] + "." + myMask[2] + "." + myMask[3]);
    }

    public String toString() {
        return this.addr + " mask " + this.mask;
    }

    public boolean contains(InetAddress checkMe) {
        for (int i = 0; i < 4; ++i) {
            if ((this.addr.getAddress()[i] & this.mask.getAddress()[i]) == (checkMe.getAddress()[i] & this.mask.getAddress()[i])) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object other) {
        IPNetwork otherNet = (IPNetwork)other;
        byte[] thisAddr = this.addr.getAddress();
        byte[] thisMask = this.mask.getAddress();
        byte[] thatAddr = otherNet.addr.getAddress();
        byte[] thatMask = otherNet.mask.getAddress();
        for (int i = 0; i < 4; ++i) {
            if ((thisAddr[i] & thisMask[i]) == (thatAddr[i] & thatMask[i])) continue;
            return false;
        }
        return true;
    }
}

