/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.encoding;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.wst.sse.core.internal.encoding.EncodingMemento;
import org.eclipse.wst.sse.core.internal.encoding.IContentDescriptionExtended;
import org.eclipse.wst.sse.core.internal.encoding.util.Assert;
import org.eclipse.wst.sse.core.internal.encoding.util.Logger;
import org.osgi.framework.Bundle;

public abstract class CodedIO {
    private final boolean DEBUG = false;
    public static final int MAX_BUF_SIZE = 8192;
    public static final int MAX_MARK_SIZE = 8192;
    public static final String NO_SPEC_DEFAULT = "NoSpecDefault";
    private static Properties overridenCharsets = null;

    public static String checkMappingOverrides(String detectedCharsetName) {
        String result = detectedCharsetName;
        String newResult = CodedIO.getOverridenCharsets().getProperty(detectedCharsetName);
        if (newResult != null) {
            result = newResult;
        }
        return result;
    }

    public static EncodingMemento createEncodingMemento(byte[] detectedBom, String javaCharsetName, String detectedCharsetName, String unSupportedName, String specDefaultEncoding, String reason) {
        EncodingMemento result = new EncodingMemento();
        result.setJavaCharsetName(javaCharsetName);
        result.setDetectedCharsetName(detectedCharsetName);
        if (specDefaultEncoding == null) {
            result.setAppropriateDefault(NO_SPEC_DEFAULT);
        } else {
            result.setAppropriateDefault(specDefaultEncoding);
        }
        if (unSupportedName != null) {
            result.setInvalidEncoding(unSupportedName);
        }
        try {
            Charset.isSupported(javaCharsetName);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            result.setInvalidEncoding(javaCharsetName);
        }
        if (detectedBom != null) {
            if (detectedBom.length == 2) {
                result.setUnicodeStream(true);
            } else if (detectedBom.length == 3) {
                result.setUTF83ByteBOMUsed(true);
            }
        }
        return result;
    }

    public static EncodingMemento createEncodingMemento(String detectedCharsetName) {
        return CodedIO.createEncodingMemento(detectedCharsetName, null);
    }

    public static EncodingMemento createEncodingMemento(String detectedCharsetName, String reason) {
        return CodedIO.createEncodingMemento(detectedCharsetName, reason, null);
    }

    public static EncodingMemento createEncodingMemento(String detectedCharsetName, String reason, String specDefaultEncoding) {
        EncodingMemento result = new EncodingMemento();
        result = new EncodingMemento();
        String javaCharset = CodedIO.getAppropriateJavaCharset(detectedCharsetName);
        result.setJavaCharsetName(javaCharset);
        result.setDetectedCharsetName(detectedCharsetName);
        if (specDefaultEncoding == null) {
            result.setAppropriateDefault(NO_SPEC_DEFAULT);
        } else {
            result.setAppropriateDefault(specDefaultEncoding);
        }
        try {
            Charset.isSupported(javaCharset);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            result.setInvalidEncoding(javaCharset);
        }
        return result;
    }

    public static String getAppropriateJavaCharset(String detectedCharsetName) {
        Assert.isNotNull(detectedCharsetName, "illegal charset argument. it can not be null");
        String result = detectedCharsetName;
        result = CodedIO.checkMappingOverrides(detectedCharsetName);
        Charset javaCharset = null;
        javaCharset = Charset.forName(result);
        if (javaCharset != null) {
            result = javaCharset.name();
        }
        return result;
    }

    private static Properties getOverridenCharsets() {
        if (overridenCharsets == null) {
            overridenCharsets = new Properties();
            Bundle keyBundle = Platform.getBundle((String)"org.eclipse.wst.sse.core");
            Path keyPath = new Path("config/override.properties");
            URL location = Platform.find((Bundle)keyBundle, (IPath)keyPath);
            InputStream propertiesInputStream = null;
            try {
                propertiesInputStream = location.openStream();
                overridenCharsets.load(propertiesInputStream);
            }
            catch (IOException iOException) {}
        }
        return overridenCharsets;
    }

    protected CodedIO() {
    }

    protected EncodingMemento createMemento(IContentDescription contentDescription) {
        String appropriateDefault = contentDescription.getContentType().getDefaultCharset();
        String detectedCharset = (String)contentDescription.getProperty(IContentDescriptionExtended.DETECTED_CHARSET);
        String unSupportedCharset = (String)contentDescription.getProperty(IContentDescriptionExtended.UNSUPPORTED_CHARSET);
        String javaCharset = contentDescription.getCharset();
        if (javaCharset == null) {
            Logger.log(201, "charset equaled null!");
        } else if (javaCharset.length() == 0) {
            Logger.log(201, "charset equaled emptyString!");
        }
        byte[] BOM = (byte[])contentDescription.getProperty(IContentDescription.BYTE_ORDER_MARK);
        EncodingMemento result = CodedIO.createEncodingMemento(BOM, javaCharset, detectedCharset, unSupportedCharset, appropriateDefault, null);
        if (!result.isValid()) {
            result.setAppropriateDefault(appropriateDefault);
        }
        return result;
    }
}

