/*******************************************************************************
 * Copyright (c) 2001, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.dtd.core.internal.validation.eclipse;

import java.io.InputStream;

import org.eclipse.wst.dtd.core.internal.validation.DTDValidationMessages;
import org.eclipse.wst.xml.core.internal.validation.core.AbstractNestedValidator;
import org.eclipse.wst.xml.core.internal.validation.core.NestedValidatorContext;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationReport;

/**
 * DTD validator that is contributed to the validation framework.
 */
public class Validator extends AbstractNestedValidator 
{

  /* (non-Javadoc)
   * @see org.eclipse.wst.xml.core.internal.validation.core.AbstractNestedValidator#getValidatorName()
   */
  protected String getValidatorName() 
  {
	return DTDValidationMessages.MESSAGE_DTD_VALIDATION_MESSAGE_UI_;
  }

  /* (non-Javadoc)
   * @see org.eclipse.wst.xml.core.internal.validation.core.AbstractNestedValidator#validate(java.lang.String, java.io.InputStream, org.eclipse.wst.xml.core.internal.validation.core.NestedValidatorContext)
   */
  public ValidationReport validate(String uri, InputStream inputstream, NestedValidatorContext context) 
  {
	DTDValidator validator = DTDValidator.getInstance();

	ValidationReport valreport = null;
	valreport = validator.validate(uri);
	
	return valreport;
  }

}
