/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry.osgi;

import java.io.File;
import java.util.Hashtable;
import org.eclipse.core.internal.registry.RegistryProperties;
import org.eclipse.core.internal.registry.RegistryProviderFactory;
import org.eclipse.core.internal.registry.osgi.EquinoxRegistryStrategy;
import org.eclipse.core.internal.registry.osgi.OSGIUtils;
import org.eclipse.core.internal.registry.osgi.RegistryProviderOSGI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private static BundleContext bundleContext;
    private static final String STORAGE_DIR = "org.eclipse.core.runtime";
    private Object masterRegistryKey = new Object();
    private Object userRegistryKey = new Object();
    private IExtensionRegistry defaultRegistry = null;
    private ServiceRegistration registryRegistration;
    private RegistryProviderOSGI defaultProvider;

    public void start(BundleContext context) throws Exception {
        bundleContext = context;
        RegistryProperties.setContext(bundleContext);
        this.processCommandLine();
        this.startRegistry();
    }

    public void stop(BundleContext context) throws Exception {
        this.stopRegistry();
        RegistryProperties.setContext(null);
        bundleContext = null;
    }

    public static BundleContext getContext() {
        return bundleContext;
    }

    private void processCommandLine() {
        ServiceTracker environmentTracker = new ServiceTracker(bundleContext, EnvironmentInfo.class.getName(), null);
        environmentTracker.open();
        EnvironmentInfo environmentInfo = (EnvironmentInfo)environmentTracker.getService();
        environmentTracker.close();
        if (environmentInfo == null) {
            return;
        }
        String[] args = environmentInfo.getNonFrameworkArgs();
        if (args == null || args.length == 0) {
            return;
        }
        int i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase("-noregistrycache")) {
                RegistryProperties.setProperty("eclipse.noRegistryCache", "true");
            } else if (args[i].equalsIgnoreCase("-noLazyRegistryCacheLoading")) {
                RegistryProperties.setProperty("eclipse.noLazyRegistryCacheLoading", "true");
            }
            ++i;
        }
    }

    public void startRegistry() throws CoreException {
        boolean[] readOnlyLocations;
        File[] registryLocations;
        String property = bundleContext.getProperty("eclipse.createRegistry");
        if (property != null && property.equalsIgnoreCase("false")) {
            return;
        }
        if ("true".equals(bundleContext.getProperty("eclipse.registry.nulltoken"))) {
            this.userRegistryKey = null;
        }
        Location configuration = OSGIUtils.getDefault().getConfigurationLocation();
        File primaryDir = new File(String.valueOf(configuration.getURL().getPath()) + '/' + STORAGE_DIR);
        boolean primaryReadOnly = configuration.isReadOnly();
        Location parentLocation = configuration.getParentLocation();
        if (parentLocation != null) {
            File secondaryDir = new File(String.valueOf(parentLocation.getURL().getFile()) + '/' + STORAGE_DIR);
            registryLocations = new File[]{primaryDir, secondaryDir};
            readOnlyLocations = new boolean[]{primaryReadOnly, true};
        } else {
            registryLocations = new File[]{primaryDir};
            readOnlyLocations = new boolean[]{primaryReadOnly};
        }
        EquinoxRegistryStrategy registryStrategy = new EquinoxRegistryStrategy(registryLocations, readOnlyLocations, this.masterRegistryKey);
        this.defaultRegistry = RegistryFactory.createRegistry(registryStrategy, this.masterRegistryKey, this.userRegistryKey);
        this.registryRegistration = Activator.getContext().registerService(IExtensionRegistry.class.getName(), (Object)this.defaultRegistry, new Hashtable());
        this.defaultProvider = new RegistryProviderOSGI();
        RegistryProviderFactory.setDefault(this.defaultProvider);
    }

    private void stopRegistry() {
        if (this.defaultRegistry != null) {
            RegistryProviderFactory.releaseDefault();
            this.defaultProvider.release();
            this.registryRegistration.unregister();
            this.defaultRegistry.stop(this.masterRegistryKey);
        }
    }
}

