/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.resources.mapping.ResourceChangeValidator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ContainerGenerator;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.ide.dialogs.IDEResourceInfoUtils;
import org.eclipse.ui.wizards.datatransfer.FileStoreStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public class CopyFilesAndFoldersOperation {
    private MultiStatus errorStatus;
    private Shell messageShell;
    private boolean canceled = false;
    private boolean alwaysOverwrite = false;
    private String[] modelProviderIds;

    static IPath getAutoNewNameFor(IPath originalName, IWorkspace workspace) {
        int counter = 1;
        String resourceName = originalName.lastSegment();
        IPath leadupSegment = originalName.removeLastSegments(1);
        while (true) {
            String nameSegment = counter > 1 ? NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_copyNameTwoArgs, (Object)new Integer(counter), (Object)resourceName) : NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_copyNameOneArg, (Object)resourceName);
            IPath pathToTry = leadupSegment.append(nameSegment);
            if (!workspace.getRoot().exists(pathToTry)) {
                return pathToTry;
            }
            ++counter;
        }
    }

    public CopyFilesAndFoldersOperation(Shell shell) {
        this.messageShell = shell;
    }

    protected boolean canPerformAutoRename() {
        return true;
    }

    protected String getDeepCheckQuestion(IResource source) {
        return NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_deepCopyQuestion, (Object)source.getFullPath().makeRelative());
    }

    IStatus checkExist(IFileStore[] stores) {
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, this.getProblemsMessage(), null);
        int i = 0;
        while (i < stores.length) {
            if (!stores[i].fetchInfo().exists()) {
                String message = NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_resourceDeleted, (Object)stores[i].getName());
                Status status = new Status(4, "org.eclipse.ui", 0, message, null);
                multiStatus.add((IStatus)status);
            }
            ++i;
        }
        return multiStatus;
    }

    IStatus checkExist(IResource[] resources) {
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, this.getProblemsMessage(), null);
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource != null) {
                IFileInfo info;
                URI location = resource.getLocationURI();
                String message = null;
                if (!(location == null || (info = IDEResourceInfoUtils.getFileInfo(location)) != null && info.exists())) {
                    message = resource.isLinked() ? NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_missingLinkTarget, (Object)resource.getName()) : NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_resourceDeleted, (Object)resource.getName());
                }
                if (message != null) {
                    Status status = new Status(4, "org.eclipse.ui", 0, message, null);
                    multiStatus.add((IStatus)status);
                }
            }
            ++i;
        }
        return multiStatus;
    }

    private int checkOverwrite(final IResource source, final IResource destination) {
        final int[] result = new int[1];
        Runnable query = new Runnable(){

            public void run() {
                String message;
                int[] resultId = new int[]{2, 4, 3, 1};
                String[] labels = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
                if (destination.getType() == 2) {
                    if (CopyFilesAndFoldersOperation.this.homogenousResources(source, destination)) {
                        message = NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_overwriteMergeQuestion, (Object)destination.getFullPath().makeRelative());
                    } else {
                        message = destination.isLinked() ? NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_overwriteNoMergeLinkQuestion, (Object)destination.getFullPath().makeRelative()) : NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_overwriteNoMergeNoLinkQuestion, (Object)destination.getFullPath().makeRelative());
                        resultId = new int[]{2, 3, 1};
                        labels = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
                    }
                } else {
                    Object[] bindings = new String[]{IDEResourceInfoUtils.getLocationText(destination), IDEResourceInfoUtils.getDateStringValue(destination), IDEResourceInfoUtils.getLocationText(source), IDEResourceInfoUtils.getDateStringValue(source)};
                    message = NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_overwriteWithDetailsQuestion, (Object[])bindings);
                }
                MessageDialog dialog = new MessageDialog(CopyFilesAndFoldersOperation.this.messageShell, IDEWorkbenchMessages.CopyFilesAndFoldersOperation_resourceExists, null, message, 3, labels, 0);
                dialog.open();
                result[0] = dialog.getReturnCode() == -1 ? 1 : resultId[dialog.getReturnCode()];
            }
        };
        this.messageShell.getDisplay().syncExec(query);
        return result[0];
    }

    private void collectExistingReadonlyFiles(IPath destinationPath, IResource[] copyResources, ArrayList existing) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < copyResources.length) {
            IResource source = copyResources[i];
            IPath newDestinationPath = destinationPath.append(source.getName());
            IResource newDestination = workspaceRoot.findMember(newDestinationPath);
            if (newDestination != null) {
                IFolder folder = this.getFolder(newDestination);
                if (folder != null) {
                    IFolder sourceFolder = this.getFolder(source);
                    if (sourceFolder != null) {
                        try {
                            this.collectExistingReadonlyFiles(newDestinationPath, sourceFolder.members(), existing);
                        }
                        catch (CoreException exception) {
                            this.recordError(exception);
                        }
                    }
                } else {
                    IFile file = this.getFile(newDestination);
                    if (file != null) {
                        IFile sourceFile;
                        if (file.isReadOnly()) {
                            existing.add(file);
                        }
                        if (this.getValidateConflictSource() && (sourceFile = this.getFile(source)) != null) {
                            existing.add(sourceFile);
                        }
                    }
                }
            }
            ++i;
        }
    }

    protected void copy(IResource[] resources, IPath destination, IProgressMonitor subMonitor) throws CoreException {
        subMonitor.beginTask(IDEWorkbenchMessages.CopyFilesAndFoldersOperation_CopyResourcesTask, resources.length);
        int i = 0;
        while (i < resources.length) {
            IResource source = resources[i];
            IPath destinationPath = destination.append(source.getName());
            IWorkspace workspace = source.getWorkspace();
            IWorkspaceRoot workspaceRoot = workspace.getRoot();
            IResource existing = workspaceRoot.findMember(destinationPath);
            if (source.getType() == 2 && existing != null) {
                if (this.homogenousResources(source, existing)) {
                    IResource[] children = ((IContainer)source).members();
                    this.copy(children, destinationPath, (IProgressMonitor)new SubProgressMonitor(subMonitor, 1));
                } else {
                    this.delete(existing, (IProgressMonitor)new SubProgressMonitor(subMonitor, 0));
                    source.copy(destinationPath, 32, (IProgressMonitor)new SubProgressMonitor(subMonitor, 1));
                }
            } else {
                if (existing != null) {
                    if (this.homogenousResources(source, existing)) {
                        this.copyExisting(source, existing, (IProgressMonitor)new SubProgressMonitor(subMonitor, 1));
                    } else {
                        this.delete(existing, (IProgressMonitor)new SubProgressMonitor(subMonitor, 0));
                        source.copy(destinationPath, 32, (IProgressMonitor)new SubProgressMonitor(subMonitor, 1));
                    }
                } else {
                    source.copy(destinationPath, 32, (IProgressMonitor)new SubProgressMonitor(subMonitor, 1));
                }
                if (subMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
            }
            ++i;
        }
    }

    private void copyExisting(IResource source, IResource existing, IProgressMonitor subMonitor) throws CoreException {
        IFile sourceFile;
        IFile existingFile = this.getFile(existing);
        if (existingFile != null && (sourceFile = this.getFile(source)) != null) {
            existingFile.setContents(sourceFile.getContents(), 2, (IProgressMonitor)new SubProgressMonitor(subMonitor, 0));
        }
    }

    public IResource[] copyResources(IResource[] resources, IContainer destination) {
        return this.copyResources(resources, destination, true, null);
    }

    public IResource[] copyResourcesInCurrentThread(IResource[] resources, IContainer destination, IProgressMonitor monitor) {
        return this.copyResources(resources, destination, false, monitor);
    }

    private IResource[] copyResources(final IResource[] resources, IContainer destination, boolean fork, IProgressMonitor monitor) {
        final IPath destinationPath = destination.getFullPath();
        final IResource[][] copiedResources = new IResource[1][0];
        IStatus resourceStatus = this.checkExist(resources);
        if (resourceStatus.getSeverity() != 0) {
            this.displayError(resourceStatus);
            return copiedResources[0];
        }
        String errorMsg = this.validateDestination(destination, resources);
        if (errorMsg != null) {
            this.displayError(errorMsg);
            return copiedResources[0];
        }
        if (!this.validateOperation(resources, destinationPath)) {
            return copiedResources[0];
        }
        if (fork) {
            WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                public void execute(IProgressMonitor monitor) {
                    CopyFilesAndFoldersOperation.this.copyResources(resources, destinationPath, copiedResources, monitor);
                }
            };
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)op);
            }
            catch (InterruptedException interruptedException) {
                return copiedResources[0];
            }
            catch (InvocationTargetException e) {
                this.display(e);
            }
        } else {
            this.copyResources(resources, destinationPath, copiedResources, monitor);
        }
        if (this.errorStatus != null) {
            this.displayError((IStatus)this.errorStatus);
            this.errorStatus = null;
        }
        return copiedResources[0];
    }

    private boolean validateOperation(IResource[] resources, IPath destinationPath) {
        String message;
        String title;
        IResourceChangeDescriptionFactory factory = ResourceChangeValidator.getValidator().createDeltaFactory();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (this.isMove()) {
                factory.move(resource, destinationPath.append(resource.getName()));
            } else {
                factory.copy(resource, destinationPath.append(resource.getName()));
            }
            ++i;
        }
        if (this.isMove()) {
            title = IDEWorkbenchMessages.CopyFilesAndFoldersOperation_confirmMove;
            message = IDEWorkbenchMessages.CopyFilesAndFoldersOperation_warningMove;
        } else {
            title = IDEWorkbenchMessages.CopyFilesAndFoldersOperation_confirmCopy;
            message = IDEWorkbenchMessages.CopyFilesAndFoldersOperation_warningCopy;
        }
        return IDE.promptToConfirm(this.messageShell, title, message, factory.getDelta(), this.modelProviderIds, true);
    }

    protected boolean isMove() {
        return false;
    }

    private void display(InvocationTargetException e) {
        IDEWorkbenchPlugin.getDefault().getLog().log(StatusUtil.newStatus(4, MessageFormat.format((String)"Exception in {0}.performCopy(): {1}", (Object[])new Object[]{this.getClass().getName(), e.getTargetException()}), null));
        this.displayError(NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_internalError, (Object)e.getTargetException().getMessage()));
    }

    public void copyFiles(URI[] uris, IContainer destination) {
        IFileStore[] stores = this.buildFileStores(uris);
        if (stores == null) {
            return;
        }
        this.copyFileStores(destination, stores, true, null);
    }

    public void copyFilesInCurrentThread(URI[] uris, IContainer destination, IProgressMonitor monitor) {
        IFileStore[] stores = this.buildFileStores(uris);
        if (stores == null) {
            return;
        }
        this.copyFileStores(destination, stores, false, monitor);
    }

    private IFileStore[] buildFileStores(URI[] uris) {
        IFileStore[] stores = new IFileStore[uris.length];
        int i = 0;
        while (i < uris.length) {
            IFileStore store;
            try {
                store = EFS.getStore((URI)uris[i]);
            }
            catch (CoreException e) {
                IDEWorkbenchPlugin.log(e.getMessage(), e);
                this.reportFileInfoNotFound(uris[i].toString());
                return null;
            }
            if (store == null) {
                this.reportFileInfoNotFound(uris[i].toString());
                return null;
            }
            stores[i] = store;
            ++i;
        }
        return stores;
    }

    public void copyFiles(String[] fileNames, IContainer destination) {
        IFileStore[] stores = this.buildFileStores(fileNames);
        if (stores == null) {
            return;
        }
        this.copyFileStores(destination, stores, true, null);
    }

    public void copyFilesInCurrentThread(String[] fileNames, IContainer destination, IProgressMonitor monitor) {
        IFileStore[] stores = this.buildFileStores(fileNames);
        if (stores == null) {
            return;
        }
        this.copyFileStores(destination, stores, false, monitor);
    }

    private IFileStore[] buildFileStores(String[] fileNames) {
        IFileStore[] stores = new IFileStore[fileNames.length];
        int i = 0;
        while (i < fileNames.length) {
            IFileStore store = IDEResourceInfoUtils.getFileStore(fileNames[i]);
            if (store == null) {
                this.reportFileInfoNotFound(fileNames[i]);
                return null;
            }
            stores[i] = store;
            ++i;
        }
        return stores;
    }

    private void reportFileInfoNotFound(final String fileName) {
        this.messageShell.getDisplay().syncExec(new Runnable(){

            public void run() {
                ErrorDialog.openError((Shell)CopyFilesAndFoldersOperation.this.messageShell, (String)CopyFilesAndFoldersOperation.this.getProblemsTitle(), (String)NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_infoNotFound, (Object)fileName), null);
            }
        });
    }

    private void copyFileStores(IContainer destination, final IFileStore[] stores, boolean fork, IProgressMonitor monitor) {
        IStatus fileStatus = this.checkExist(stores);
        if (fileStatus.getSeverity() != 0) {
            this.displayError(fileStatus);
            return;
        }
        String errorMsg = this.validateImportDestinationInternal(destination, stores);
        if (errorMsg != null) {
            this.displayError(errorMsg);
            return;
        }
        final IPath destinationPath = destination.getFullPath();
        if (fork) {
            WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                public void execute(IProgressMonitor monitor) {
                    CopyFilesAndFoldersOperation.this.copyFileStores(stores, destinationPath, monitor);
                }
            };
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)op);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            catch (InvocationTargetException exception) {
                this.display(exception);
            }
        } else {
            this.copyFileStores(stores, destinationPath, monitor);
        }
        if (this.errorStatus != null) {
            this.displayError((IStatus)this.errorStatus);
            this.errorStatus = null;
        }
    }

    private void displayError(final IStatus status) {
        this.messageShell.getDisplay().syncExec(new Runnable(){

            public void run() {
                ErrorDialog.openError((Shell)CopyFilesAndFoldersOperation.this.messageShell, (String)CopyFilesAndFoldersOperation.this.getProblemsTitle(), null, (IStatus)status);
            }
        });
    }

    IResource createLinkedResourceHandle(IContainer destination, IResource source) {
        IWorkspace workspace = destination.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        IPath linkPath = destination.getFullPath().append(source.getName());
        Object linkHandle = source.getType() == 2 ? workspaceRoot.getFolder(linkPath) : workspaceRoot.getFile(linkPath);
        return linkHandle;
    }

    boolean delete(IResource resource, IProgressMonitor monitor) {
        boolean force = false;
        if (resource.getType() == 4) {
            IProject project = (IProject)resource;
            try {
                project.delete(true, force, monitor);
            }
            catch (CoreException e) {
                this.recordError(e);
                return false;
            }
        }
        int flags = 2;
        if (force) {
            flags |= 1;
        }
        try {
            resource.delete(flags, monitor);
        }
        catch (CoreException e) {
            this.recordError(e);
            return false;
        }
        return true;
    }

    private void displayError(final String message) {
        this.messageShell.getDisplay().syncExec(new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)CopyFilesAndFoldersOperation.this.messageShell, (String)CopyFilesAndFoldersOperation.this.getProblemsTitle(), (String)message);
            }
        });
    }

    protected IFile getFile(IResource resource) {
        if (resource instanceof IFile) {
            return (IFile)resource;
        }
        return (IFile)resource.getAdapter(IFile.class);
    }

    protected File[] getFiles(String[] fileNames) {
        File[] files = new File[fileNames.length];
        int i = 0;
        while (i < fileNames.length) {
            files[i] = new File(fileNames[i]);
            ++i;
        }
        return files;
    }

    protected IFolder getFolder(IResource resource) {
        if (resource instanceof IFolder) {
            return (IFolder)resource;
        }
        return (IFolder)resource.getAdapter(IFolder.class);
    }

    private IPath getNewNameFor(final IPath originalName, final IWorkspace workspace) {
        final IResource resource = workspace.getRoot().findMember(originalName);
        final IPath prefix = resource.getFullPath().removeLastSegments(1);
        final String[] returnValue = new String[]{""};
        this.messageShell.getDisplay().syncExec(new Runnable(){

            public void run() {
                IInputValidator validator = new IInputValidator(){

                    public String isValid(String string) {
                        if (resource.getName().equals(string)) {
                            return IDEWorkbenchMessages.CopyFilesAndFoldersOperation_nameMustBeDifferent;
                        }
                        IStatus status = workspace.validateName(string, resource.getType());
                        if (!status.isOK()) {
                            return status.getMessage();
                        }
                        if (workspace.getRoot().exists(prefix.append(string))) {
                            return IDEWorkbenchMessages.CopyFilesAndFoldersOperation_nameExists;
                        }
                        return null;
                    }
                };
                InputDialog dialog = new InputDialog(CopyFilesAndFoldersOperation.this.messageShell, IDEWorkbenchMessages.CopyFilesAndFoldersOperation_inputDialogTitle, NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_inputDialogMessage, (Object)resource.getName()), CopyFilesAndFoldersOperation.getAutoNewNameFor(originalName, workspace).lastSegment().toString(), validator);
                dialog.setBlockOnOpen(true);
                dialog.open();
                returnValue[0] = dialog.getReturnCode() == 1 ? null : dialog.getValue();
            }
        });
        if (returnValue[0] == null) {
            throw new OperationCanceledException();
        }
        return prefix.append(returnValue[0]);
    }

    protected String getOperationTitle() {
        return IDEWorkbenchMessages.CopyFilesAndFoldersOperation_operationTitle;
    }

    protected String getProblemsMessage() {
        return IDEWorkbenchMessages.CopyFilesAndFoldersOperation_problemMessage;
    }

    protected String getProblemsTitle() {
        return IDEWorkbenchMessages.CopyFilesAndFoldersOperation_copyFailedTitle;
    }

    protected boolean getValidateConflictSource() {
        return false;
    }

    protected boolean homogenousResources(IResource source, IResource destination) {
        boolean isSourceLinked = source.isLinked();
        boolean isDestinationLinked = destination.isLinked();
        return isSourceLinked && isDestinationLinked || !isSourceLinked && !isDestinationLinked;
    }

    private boolean isAccessible(IResource resource) {
        switch (resource.getType()) {
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 4: {
                return ((IProject)resource).isOpen();
            }
        }
        return false;
    }

    boolean isDestinationSameAsSource(IResource[] sourceResources, IContainer destination) {
        IPath destinationLocation = destination.getLocation();
        int i = 0;
        while (i < sourceResources.length) {
            IResource sourceResource = sourceResources[i];
            if (sourceResource.getParent().equals((Object)destination)) {
                return true;
            }
            if (destinationLocation != null) {
                IPath sourceLocation = sourceResource.getLocation();
                IPath destinationResource = destinationLocation.append(sourceResource.getName());
                if (sourceLocation != null && sourceLocation.isPrefixOf(destinationResource)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private boolean performCopy(IResource[] resources, IPath destination, IProgressMonitor monitor) {
        try {
            try {
                ContainerGenerator generator = new ContainerGenerator(destination);
                generator.generateContainer((IProgressMonitor)new SubProgressMonitor(monitor, 10));
                SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 75);
                this.copy(resources, destination, (IProgressMonitor)subMonitor);
            }
            catch (CoreException e) {
                this.recordError(e);
                monitor.done();
                return false;
            }
        }
        finally {
            monitor.done();
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    private boolean performCopyWithAutoRename(IResource[] resources, IPath destination, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void performFileImport(IFileStore[] stores, IContainer target, IProgressMonitor monitor) {
        IOverwriteQuery query = new IOverwriteQuery(){

            public String queryOverwrite(String pathString) {
                if (CopyFilesAndFoldersOperation.this.alwaysOverwrite) {
                    return "ALL";
                }
                final String[] returnCode = new String[]{"CANCEL"};
                final String msg = NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_overwriteQuestion, (Object)pathString);
                final String[] options = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
                CopyFilesAndFoldersOperation.this.messageShell.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        MessageDialog dialog = new MessageDialog(CopyFilesAndFoldersOperation.this.messageShell, IDEWorkbenchMessages.CopyFilesAndFoldersOperation_question, null, msg, 3, options, 0);
                        dialog.open();
                        int returnVal = dialog.getReturnCode();
                        String[] returnCodes = new String[]{"YES", "ALL", "NO", "CANCEL"};
                        returnCode[0] = returnVal == -1 ? "CANCEL" : returnCodes[returnVal];
                    }
                });
                if (returnCode[0] == "ALL") {
                    CopyFilesAndFoldersOperation.this.alwaysOverwrite = true;
                } else if (returnCode[0] == "CANCEL") {
                    CopyFilesAndFoldersOperation.this.canceled = true;
                }
                return returnCode[0];
            }
        };
        ImportOperation op = new ImportOperation(target.getFullPath(), stores[0].getParent(), FileStoreStructureProvider.INSTANCE, query, Arrays.asList(stores));
        op.setContext(this.messageShell);
        op.setCreateContainerStructure(false);
        try {
            op.run(monitor);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                this.displayError(((CoreException)e.getTargetException()).getStatus());
            } else {
                this.display(e);
            }
            return;
        }
        IStatus status = op.getStatus();
        if (!status.isOK()) {
            if (this.errorStatus == null) {
                this.errorStatus = new MultiStatus("org.eclipse.ui", 4, this.getProblemsMessage(), null);
            }
            this.errorStatus.merge(status);
        }
    }

    private void recordError(CoreException error) {
        if (this.errorStatus == null) {
            this.errorStatus = new MultiStatus("org.eclipse.ui", 4, this.getProblemsMessage(), (Throwable)error);
        }
        this.errorStatus.merge(error.getStatus());
    }

    public String validateDestination(IContainer destination, IResource[] sourceResources) {
        if (!this.isAccessible((IResource)destination)) {
            return IDEWorkbenchMessages.CopyFilesAndFoldersOperation_destinationAccessError;
        }
        IContainer firstParent = null;
        URI destinationLocation = destination.getLocationURI();
        int i = 0;
        while (i < sourceResources.length) {
            IResource sourceResource = sourceResources[i];
            if (firstParent == null) {
                firstParent = sourceResource.getParent();
            } else if (!firstParent.equals((Object)sourceResource.getParent())) {
                return IDEWorkbenchMessages.CopyFilesAndFoldersOperation_parentNotEqual;
            }
            URI sourceLocation = sourceResource.getLocationURI();
            if (sourceLocation == null) {
                if (sourceResource.isLinked()) {
                    return NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_missingPathVariable, (Object)sourceResource.getName());
                }
                return NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_resourceDeleted, (Object)sourceResource.getName());
            }
            if (sourceLocation.equals(destinationLocation)) {
                return NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_sameSourceAndDest, (Object)sourceResource.getName());
            }
            if (new Path(sourceLocation.toString()).isPrefixOf((IPath)new Path(destinationLocation.toString()))) {
                return IDEWorkbenchMessages.CopyFilesAndFoldersOperation_destinationDescendentError;
            }
            String linkedResourceMessage = this.validateLinkedResource(destination, sourceResource);
            if (linkedResourceMessage != null) {
                return linkedResourceMessage;
            }
            ++i;
        }
        return null;
    }

    private boolean validateEdit(IContainer destination, IResource[] sourceResources) {
        ArrayList copyFiles = new ArrayList();
        this.collectExistingReadonlyFiles(destination.getFullPath(), sourceResources, copyFiles);
        if (copyFiles.size() > 0) {
            IFile[] files = copyFiles.toArray(new IFile[copyFiles.size()]);
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IStatus status = workspace.validateEdit(files, (Object)this.messageShell);
            this.canceled = !status.isOK();
            return status.isOK();
        }
        return true;
    }

    public String validateImportDestination(IContainer destination, String[] sourceNames) {
        IFileStore[] stores = new IFileStore[sourceNames.length];
        int i = 0;
        while (i < sourceNames.length) {
            IFileStore store = IDEResourceInfoUtils.getFileStore(sourceNames[i]);
            if (store == null) {
                return NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_infoNotFound, (Object)sourceNames[i]);
            }
            stores[i] = store;
            ++i;
        }
        return this.validateImportDestinationInternal(destination, stores);
    }

    private String validateImportDestinationInternal(IContainer destination, IFileStore[] sourceStores) {
        IFileStore destinationStore;
        if (!this.isAccessible((IResource)destination)) {
            return IDEWorkbenchMessages.CopyFilesAndFoldersOperation_destinationAccessError;
        }
        try {
            destinationStore = EFS.getStore((URI)destination.getLocationURI());
        }
        catch (CoreException exception) {
            IDEWorkbenchPlugin.log(exception.getLocalizedMessage(), exception);
            return NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_internalError, (Object)exception.getLocalizedMessage());
        }
        int i = 0;
        while (i < sourceStores.length) {
            IFileStore sourceStore = sourceStores[i];
            IFileStore sourceParentStore = sourceStore.getParent();
            if (sourceStore != null) {
                if (destinationStore.equals(sourceStore) || sourceParentStore != null && destinationStore.equals(sourceParentStore)) {
                    return NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_importSameSourceAndDest, (Object)sourceStore.getName());
                }
                IFileStore destinationParent = destinationStore.getParent();
                if (sourceStore.isParentOf(destinationParent)) {
                    return IDEWorkbenchMessages.CopyFilesAndFoldersOperation_destinationDescendentError;
                }
            }
            ++i;
        }
        return null;
    }

    private String validateLinkedResource(IContainer destination, IResource source) {
        IResource linkHandle;
        if (!source.isLinked()) {
            return null;
        }
        IWorkspace workspace = destination.getWorkspace();
        IStatus locationStatus = workspace.validateLinkLocation(linkHandle = this.createLinkedResourceHandle(destination, source), source.getRawLocation());
        if (locationStatus.getSeverity() == 4) {
            return locationStatus.getMessage();
        }
        IPath sourceLocation = source.getLocation();
        if (!source.getProject().equals((Object)destination.getProject()) && source.getType() == 2 && sourceLocation != null) {
            try {
                IResource[] members = destination.members();
                int j = 0;
                while (j < members.length) {
                    if (sourceLocation.equals((Object)members[j].getLocation()) && source.getName().equals(members[j].getName())) {
                        return NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_sameSourceAndDest, (Object)source.getName());
                    }
                    ++j;
                }
            }
            catch (CoreException exception) {
                this.displayError(NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_internalError, (Object)exception.getMessage()));
            }
        }
        return null;
    }

    private IResource[] validateNoNameCollisions(IContainer destination, IResource[] sourceResources) {
        IPath destinationPath;
        ArrayList<IResource> copyItems = new ArrayList<IResource>();
        IWorkspaceRoot workspaceRoot = destination.getWorkspace().getRoot();
        int overwrite = 3;
        int i = 0;
        while (i < sourceResources.length) {
            IResource sourceResource = sourceResources[i];
            destinationPath = destination.getFullPath().append(sourceResource.getName());
            IPath sourcePath = sourceResource.getFullPath();
            IResource newResource = workspaceRoot.findMember(destinationPath);
            if (newResource != null && destinationPath.isPrefixOf(sourcePath)) {
                this.displayError(NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_overwriteProblem, (Object)destinationPath, (Object)sourcePath));
                this.canceled = true;
                return null;
            }
            ++i;
        }
        i = 0;
        while (i < sourceResources.length) {
            IResource source = sourceResources[i];
            destinationPath = destination.getFullPath().append(source.getName());
            IResource newResource = workspaceRoot.findMember(destinationPath);
            if (newResource != null) {
                if (overwrite != 4 || newResource.getType() == 2 && !this.homogenousResources(source, (IResource)destination)) {
                    overwrite = this.checkOverwrite(source, newResource);
                }
                if (overwrite == 2 || overwrite == 4) {
                    copyItems.add(source);
                } else if (overwrite == 1) {
                    this.canceled = true;
                    return null;
                }
            } else {
                copyItems.add(source);
            }
            ++i;
        }
        return copyItems.toArray(new IResource[copyItems.size()]);
    }

    private void copyResources(IResource[] resources, IPath destinationPath, IResource[][] copiedResources, IProgressMonitor monitor) {
        IResource[] copyResources = resources;
        monitor.beginTask("", 100);
        monitor.setTaskName(this.getOperationTitle());
        monitor.worked(10);
        boolean copyWithAutoRename = false;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (root.exists(destinationPath)) {
            IContainer container = (IContainer)root.findMember(destinationPath);
            if (this.isDestinationSameAsSource(copyResources, container) && this.canPerformAutoRename()) {
                copyWithAutoRename = true;
            } else {
                if ((copyResources = this.validateNoNameCollisions(container, copyResources)) == null) {
                    if (this.canceled) {
                        return;
                    }
                    this.displayError(IDEWorkbenchMessages.CopyFilesAndFoldersOperation_nameCollision);
                    return;
                }
                if (!this.validateEdit(container, copyResources)) {
                    return;
                }
            }
        }
        this.errorStatus = null;
        if (copyResources.length > 0) {
            if (copyWithAutoRename) {
                this.performCopyWithAutoRename(copyResources, destinationPath, monitor);
            } else {
                this.performCopy(copyResources, destinationPath, monitor);
            }
        }
        copiedResources[0] = copyResources;
    }

    private void copyFileStores(IFileStore[] stores, IPath destinationPath, IProgressMonitor monitor) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (root.exists(destinationPath)) {
            IContainer container = (IContainer)root.findMember(destinationPath);
            this.performFileImport(stores, container, monitor);
        }
    }

    public String[] getModelProviderIds() {
        return this.modelProviderIds;
    }

    public void setModelProviderIds(String[] modelProviderIds) {
        this.modelProviderIds = modelProviderIds;
    }
}

