/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.debug;

import gnu.java.security.action.GetPropertyAction;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class Simple1LineFormatter
extends Formatter {
    private static final String DAT_PATTERN = "yyyy-MM-dd HH:mm:ss.SSSS Z ";
    private static final String THREAD_PATTERN = " #########0;-#########0";
    private static final String SPACES_32 = "                                ";
    private static final String SPACES_6 = "      ";
    private static final String LS;
    private DateFormat dateFormat;
    private NumberFormat threadFormat;

    public String format(LogRecord logRecord) {
        if (this.dateFormat == null) {
            this.dateFormat = new SimpleDateFormat(DAT_PATTERN);
        }
        if (this.threadFormat == null) {
            this.threadFormat = new DecimalFormat(THREAD_PATTERN);
        }
        StringBuilder stringBuilder = new StringBuilder(180).append(this.dateFormat.format(new Date(logRecord.getMillis()))).append(this.threadFormat.format(logRecord.getThreadID())).append(" ");
        String string = logRecord.getSourceClassName();
        if (string == null) {
            stringBuilder.append(SPACES_32);
        } else {
            int n = (string = string.trim()).lastIndexOf(".");
            if (n != -1) {
                string = string.substring(n + 1);
            }
            string = (string + SPACES_32).substring(0, 32);
        }
        stringBuilder.append(string).append(" ");
        string = logRecord.getSourceMethodName();
        if (string == null) {
            stringBuilder.append(SPACES_32);
        } else {
            string = (string = string.trim()).endsWith("()") ? (string.trim() + SPACES_32).substring(0, 32) : (string.trim() + "()" + SPACES_32).substring(0, 32);
        }
        stringBuilder.append(string).append(" ");
        string = String.valueOf(logRecord.getLevel());
        if (string == null) {
            stringBuilder.append(SPACES_6);
        } else {
            string = (string.trim() + SPACES_6).substring(0, 6);
        }
        stringBuilder.append(string).append(" - ").append(this.formatMessage(logRecord)).append(LS);
        Throwable throwable = logRecord.getThrown();
        if (throwable != null) {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter, true));
            stringBuilder.append(stringWriter.toString());
        }
        return stringBuilder.toString();
    }

    static {
        DAT_PATTERN = DAT_PATTERN;
        THREAD_PATTERN = THREAD_PATTERN;
        SPACES_32 = SPACES_32;
        SPACES_6 = SPACES_6;
        LS = (String)AccessController.doPrivileged(new GetPropertyAction("line.separator"));
    }
}

