/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.java2d;

import gnu.java.awt.java2d.Segment;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;

public class QuadSegment
extends Segment {
    public Point2D cp;

    public QuadSegment(double d, double d2, double d3, double d4, double d5, double d6) {
        this.P1 = new Point2D.Double(d, d2);
        this.P2 = new Point2D.Double(d5, d6);
        this.cp = new Point2D.Double(d3, d4);
    }

    public QuadSegment(Point2D point2D, Point2D point2D2, Point2D point2D3) {
        this.P1 = point2D;
        this.P2 = point2D3;
        this.cp = point2D2;
    }

    public QuadSegment(QuadCurve2D quadCurve2D) {
        this.P1 = quadCurve2D.getP1();
        this.P2 = quadCurve2D.getP2();
        this.cp = quadCurve2D.getCtrlPt();
    }

    public Object clone() {
        QuadSegment quadSegment = null;
        try {
            quadSegment = (QuadSegment)super.clone();
            quadSegment.P1 = (Point2D)this.P1.clone();
            quadSegment.P2 = (Point2D)this.P2.clone();
            quadSegment.cp = (Point2D)this.cp.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            InternalError internalError = new InternalError();
            internalError.initCause(cloneNotSupportedException);
            throw internalError;
        }
        return quadSegment;
    }

    public Segment[] getDisplacedSegments(double d) {
        this.radius = d;
        double d2 = this.P1.getX();
        double d3 = this.P1.getY();
        double d4 = this.cp.getX();
        double d5 = this.cp.getY();
        double d6 = this.P2.getX();
        double d7 = this.P2.getY();
        QuadCurve2D.Double double_ = new QuadCurve2D.Double();
        QuadCurve2D.Double double_2 = new QuadCurve2D.Double();
        QuadCurve2D.Double double_3 = new QuadCurve2D.Double(d2, d3, d4, d5, d6, d7);
        double_3.subdivide(double_, double_2);
        QuadSegment quadSegment = this.offsetSubdivided(double_, true);
        QuadSegment quadSegment2 = this.offsetSubdivided(double_, false);
        quadSegment.add(this.offsetSubdivided(double_2, true));
        quadSegment2.add(this.offsetSubdivided(double_2, false));
        return new Segment[]{quadSegment, quadSegment2};
    }

    private QuadSegment offsetSubdivided(QuadCurve2D quadCurve2D, boolean bl) {
        QuadSegment quadSegment;
        double[] dArray = this.normal(quadCurve2D.getX1(), quadCurve2D.getY1(), quadCurve2D.getCtrlX(), quadCurve2D.getCtrlY());
        double[] dArray2 = this.normal(quadCurve2D.getCtrlX(), quadCurve2D.getCtrlY(), quadCurve2D.getX2(), quadCurve2D.getY2());
        if (bl) {
            Point2D point2D = this.lineIntersection(quadCurve2D.getX1() + dArray[0], quadCurve2D.getY1() + dArray[1], quadCurve2D.getCtrlX() + dArray[0], quadCurve2D.getCtrlY() + dArray[1], quadCurve2D.getCtrlX() + dArray2[0], quadCurve2D.getCtrlY() + dArray2[1], quadCurve2D.getX2() + dArray2[0], quadCurve2D.getY2() + dArray2[1], true);
            quadSegment = new QuadSegment(quadCurve2D.getX1() + dArray[0], quadCurve2D.getY1() + dArray[1], point2D.getX(), point2D.getY(), quadCurve2D.getX2() + dArray2[0], quadCurve2D.getY2() + dArray2[1]);
        } else {
            Point2D point2D = this.lineIntersection(quadCurve2D.getX1() - dArray[0], quadCurve2D.getY1() - dArray[1], quadCurve2D.getCtrlX() - dArray[0], quadCurve2D.getCtrlY() - dArray[1], quadCurve2D.getCtrlX() - dArray2[0], quadCurve2D.getCtrlY() - dArray2[1], quadCurve2D.getX2() - dArray2[0], quadCurve2D.getY2() - dArray2[1], true);
            quadSegment = new QuadSegment(quadCurve2D.getX1() - dArray[0], quadCurve2D.getY1() - dArray[1], point2D.getX(), point2D.getY(), quadCurve2D.getX2() - dArray2[0], quadCurve2D.getY2() - dArray2[1]);
        }
        return quadSegment;
    }

    private Point2D lineIntersection(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, boolean bl) {
        double d9 = d;
        double d10 = d2;
        double d11 = d3 - d9;
        double d12 = d4 - d10;
        double d13 = d5;
        double d14 = d6;
        double d15 = d7 - d13;
        double d16 = d8 - d14;
        double d17 = d15 * d12 - d16 * d11;
        double d18 = d15 * (d14 - d10) + d16 * (d9 - d13);
        if (Math.abs(d17) < 1.0E-6) {
            return null;
        }
        d18 /= d17;
        if (!bl && (d18 > 1.0 || d18 < 0.0)) {
            return null;
        }
        return new Point2D.Double(d9 + d18 * d11, d10 + d18 * d12);
    }

    public void reverse() {
        Point2D point2D = this.P1;
        this.P1 = this.P2;
        this.P2 = point2D;
    }

    public double[] cp1() {
        return new double[]{this.cp.getX(), this.cp.getY()};
    }

    public double[] cp2() {
        return new double[]{this.cp.getX(), this.cp.getY()};
    }
}

