/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.image.ImageDecoder;
import gnu.java.awt.peer.gtk.CairoGraphics2D;
import gnu.java.awt.peer.gtk.CairoSurface;
import gnu.java.awt.peer.gtk.GtkGenericPeer;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import javax.imageio.IIOImage;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageWriterSpi;

public class GdkPixbufDecoder
extends ImageDecoder {
    static Object pixbufLock;
    private final int native_state;
    private boolean needsClose;
    Vector curr;
    static final ColorModel cm;
    static ArrayList imageFormatSpecs;
    private static GdkPixbufReaderSpi readerSpi;
    private static GdkPixbufWriterSpi writerSpi;

    private /* synthetic */ void finit$() {
        this.native_state = GtkGenericPeer.getUniqueInteger();
        this.needsClose = false;
    }

    static native void initStaticState();

    native void initState();

    native void pumpBytes(byte[] var1, int var2) throws IOException;

    native void pumpDone() throws IOException;

    native void finish(boolean var1);

    static native void streamImage(int[] var0, String var1, int var2, int var3, boolean var4, GdkPixbufWriter var5);

    public GdkPixbufDecoder(DataInput dataInput) {
        super(dataInput);
        this.finit$();
    }

    public GdkPixbufDecoder(InputStream inputStream) {
        super(inputStream);
        this.finit$();
    }

    public GdkPixbufDecoder(String string) {
        super(string);
        this.finit$();
    }

    public GdkPixbufDecoder(URL uRL) {
        super(uRL);
        this.finit$();
    }

    public GdkPixbufDecoder(byte[] byArray, int n, int n2) {
        super(byArray, n, n2);
        this.finit$();
    }

    void areaPrepared(int n, int n2) {
        if (this.curr == null) {
            return;
        }
        for (int i = 0; i < this.curr.size(); ++i) {
            ImageConsumer imageConsumer = (ImageConsumer)this.curr.elementAt(i);
            imageConsumer.setDimensions(n, n2);
            imageConsumer.setColorModel(cm);
            imageConsumer.setHints(1);
        }
    }

    void areaUpdated(int n, int n2, int n3, int n4, int[] nArray, int n5) {
        if (this.curr == null) {
            return;
        }
        for (int i = 0; i < this.curr.size(); ++i) {
            ImageConsumer imageConsumer = (ImageConsumer)this.curr.elementAt(i);
            imageConsumer.setPixels(n, n2, n3, n4, cm, nArray, 0, n5);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void produce(Vector vector, InputStream inputStream) throws IOException {
        Object object;
        this.curr = vector;
        byte[] byArray = new byte[4096];
        int n = 0;
        Object object2 = pixbufLock;
        // MONITORENTER : object2
        try {
            this.initState();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            // MONITOREXIT : object2
            throw throwable;
        }
        Object object3 = null;
        // MONITOREXIT : object2
        this.needsClose = true;
        while ((n = inputStream.read(byArray)) != -1) {
            object3 = pixbufLock;
            // MONITORENTER : object3
            try {
                this.pumpBytes(byArray, n);
            }
            catch (Throwable throwable) {
                object = null;
                // MONITOREXIT : object3
                throw throwable;
            }
            object = null;
            // MONITOREXIT : object3
        }
        object = pixbufLock;
        // MONITORENTER : object
        try {
            this.pumpDone();
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            // MONITOREXIT : object
            throw throwable;
        }
        Object var8_11 = null;
        // MONITOREXIT : object
        this.needsClose = false;
        int n2 = 0;
        while (true) {
            if (n2 >= this.curr.size()) {
                this.curr = null;
                return;
            }
            ImageConsumer imageConsumer = (ImageConsumer)this.curr.elementAt(n2);
            imageConsumer.imageComplete(3);
            ++n2;
        }
    }

    public void finalize() {
        Object object = pixbufLock;
        synchronized (object) {
            try {
                this.finish(this.needsClose);
            }
            finally {
                Object var2_2 = null;
            }
            return;
        }
    }

    public static ImageFormatSpec registerFormat(String string, boolean bl) {
        ImageFormatSpec imageFormatSpec = new ImageFormatSpec(string, bl);
        Class clazz = GdkPixbufDecoder.class$("gnu.java.awt.peer.gtk.GdkPixbufDecoder");
        synchronized (clazz) {
            ImageFormatSpec imageFormatSpec2;
            try {
                if (imageFormatSpecs == null) {
                    imageFormatSpecs = new ArrayList();
                }
                imageFormatSpecs.add(imageFormatSpec);
            }
            finally {
                imageFormatSpec2 = null;
            }
            imageFormatSpec2 = imageFormatSpec;
            return imageFormatSpec2;
        }
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static String[] getFormatNames(boolean bl) {
        String[] stringArray;
        Object[] objectArray;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = imageFormatSpecs;
        synchronized (arrayList2) {
            try {
                objectArray = imageFormatSpecs.iterator();
                while (objectArray.hasNext()) {
                    stringArray = (String[])objectArray.next();
                    if (bl && !stringArray.writable) continue;
                    arrayList.add(stringArray.name);
                    Iterator iterator = stringArray.extensions.iterator();
                    while (iterator.hasNext()) {
                        arrayList.add((String)iterator.next());
                    }
                }
                objectArray = null;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                throw throwable;
            }
        }
        objectArray = arrayList.toArray();
        stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = (String)objectArray[i];
        }
        String[] stringArray2 = stringArray;
        return stringArray2;
    }

    static String[] getFormatExtensions(boolean bl) {
        String[] stringArray;
        Object[] objectArray;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = imageFormatSpecs;
        synchronized (arrayList2) {
            try {
                objectArray = imageFormatSpecs.iterator();
                while (objectArray.hasNext()) {
                    stringArray = (String[])objectArray.next();
                    if (bl && !stringArray.writable) continue;
                    Iterator iterator = stringArray.extensions.iterator();
                    while (iterator.hasNext()) {
                        arrayList.add((String)iterator.next());
                    }
                }
                objectArray = null;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                throw throwable;
            }
        }
        objectArray = arrayList.toArray();
        stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = (String)objectArray[i];
        }
        String[] stringArray2 = stringArray;
        return stringArray2;
    }

    static String[] getFormatMimeTypes(boolean bl) {
        String[] stringArray;
        Object[] objectArray;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = imageFormatSpecs;
        synchronized (arrayList2) {
            try {
                objectArray = imageFormatSpecs.iterator();
                while (objectArray.hasNext()) {
                    stringArray = (String[])objectArray.next();
                    if (bl && !stringArray.writable) continue;
                    Iterator iterator = stringArray.mimeTypes.iterator();
                    while (iterator.hasNext()) {
                        arrayList.add((String)iterator.next());
                    }
                }
                objectArray = null;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                throw throwable;
            }
        }
        objectArray = arrayList.toArray();
        stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = (String)objectArray[i];
        }
        String[] stringArray2 = stringArray;
        return stringArray2;
    }

    static String findFormatName(Object object, boolean bl) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof String)) {
            throw new IllegalArgumentException("extension is not a string");
        }
        String string = (String)object;
        Iterator iterator = imageFormatSpecs.iterator();
        while (iterator.hasNext()) {
            String string2;
            ImageFormatSpec imageFormatSpec = (ImageFormatSpec)iterator.next();
            if (bl && !imageFormatSpec.writable) continue;
            if (imageFormatSpec.name.equals(string)) {
                return string;
            }
            Iterator iterator2 = imageFormatSpec.extensions.iterator();
            while (iterator2.hasNext()) {
                string2 = (String)iterator2.next();
                if (!string2.equals(string)) continue;
                return imageFormatSpec.name;
            }
            iterator2 = imageFormatSpec.mimeTypes.iterator();
            while (iterator2.hasNext()) {
                string2 = (String)iterator2.next();
                if (!string2.equals(string)) continue;
                return imageFormatSpec.name;
            }
        }
        throw new IllegalArgumentException("unknown extension '" + string + "'");
    }

    public static synchronized GdkPixbufReaderSpi getReaderSpi() {
        if (readerSpi == null) {
            readerSpi = new GdkPixbufReaderSpi();
        }
        return readerSpi;
    }

    public static synchronized GdkPixbufWriterSpi getWriterSpi() {
        if (writerSpi == null) {
            writerSpi = new GdkPixbufWriterSpi();
        }
        return writerSpi;
    }

    public static void registerSpis(IIORegistry iIORegistry) {
        iIORegistry.registerServiceProvider(GdkPixbufDecoder.getReaderSpi(), GdkPixbufDecoder.class$("javax.imageio.spi.ImageReaderSpi"));
        iIORegistry.registerServiceProvider(GdkPixbufDecoder.getWriterSpi(), GdkPixbufDecoder.class$("javax.imageio.spi.ImageWriterSpi"));
    }

    static {
        System.loadLibrary("gtkpeer");
        GdkPixbufDecoder.initStaticState();
        pixbufLock = new Object();
        cm = new DirectColorModel(32, -16777216, 0xFF0000, 65280, 255);
    }

    private static class GdkPixbufReader
    extends ImageReader
    implements ImageConsumer {
        GdkPixbufDecoder dec;
        BufferedImage bufferedImage;
        ColorModel defaultModel;
        int width;
        int height;
        String ext;

        public GdkPixbufReader(GdkPixbufReaderSpi gdkPixbufReaderSpi, Object object) {
            super(gdkPixbufReaderSpi);
            this.ext = GdkPixbufDecoder.findFormatName(object, false);
        }

        public GdkPixbufReader(GdkPixbufReaderSpi gdkPixbufReaderSpi, Object object, GdkPixbufDecoder gdkPixbufDecoder) {
            this(gdkPixbufReaderSpi, object);
            this.dec = gdkPixbufDecoder;
        }

        public void setDimensions(int n, int n2) {
            this.processImageStarted(1);
            this.width = n;
            this.height = n2;
        }

        public void setProperties(Hashtable hashtable) {
        }

        public void setColorModel(ColorModel colorModel) {
            this.defaultModel = colorModel;
        }

        public void setHints(int n) {
        }

        public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        }

        public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
            int[] nArray2;
            if (colorModel == null) {
                colorModel = this.defaultModel;
            }
            if (this.bufferedImage == null) {
                this.bufferedImage = colorModel != null && colorModel.hasAlpha() ? new BufferedImage(this.width, this.height, 2) : new BufferedImage(this.width, this.height, 1);
            }
            if (colorModel != null) {
                nArray2 = new int[nArray.length];
                for (int i = 0; i < n4; ++i) {
                    for (int j = 0; j < n3; ++j) {
                        int n7 = i * n6 + j;
                        nArray2[n7] = colorModel.getRGB(nArray[n7]);
                    }
                }
            } else {
                nArray2 = nArray;
            }
            this.bufferedImage.setRGB(n, n2, n3, n4, nArray2, n5, n6);
            this.processImageProgress(n2 / (this.height == 0 ? 1 : this.height));
        }

        public void imageComplete(int n) {
            this.processImageComplete();
        }

        public BufferedImage getBufferedImage() {
            if (this.bufferedImage == null && this.dec != null) {
                this.dec.startProduction(this);
            }
            return this.bufferedImage;
        }

        public int getNumImages(boolean bl) throws IOException {
            return 1;
        }

        public IIOMetadata getImageMetadata(int n) {
            return null;
        }

        public IIOMetadata getStreamMetadata() throws IOException {
            return null;
        }

        public Iterator getImageTypes(int n) throws IOException {
            BufferedImage bufferedImage = this.getBufferedImage();
            Vector vector = new Vector();
            vector.add(new ImageTypeSpecifier(bufferedImage));
            return vector.iterator();
        }

        public int getHeight(int n) throws IOException {
            return this.getBufferedImage().getHeight();
        }

        public int getWidth(int n) throws IOException {
            return this.getBufferedImage().getWidth();
        }

        public void setInput(Object object, boolean bl, boolean bl2) {
            super.setInput(object, bl, bl2);
            Object object2 = this.getInput();
            if (object2 instanceof InputStream) {
                this.dec = new GdkPixbufDecoder((InputStream)object2);
            } else if (object2 instanceof DataInput) {
                this.dec = new GdkPixbufDecoder((DataInput)object2);
            } else {
                throw new IllegalArgumentException("input object not supported: " + object2);
            }
        }

        public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
            return this.getBufferedImage();
        }
    }

    private static class GdkPixbufWriter
    extends ImageWriter
    implements Runnable {
        String ext;
        private static final Object DATADONE = new Object();
        private ArrayList data;
        private IOException exception;

        private /* synthetic */ void finit$() {
            this.data = new ArrayList();
        }

        public GdkPixbufWriter(GdkPixbufWriterSpi gdkPixbufWriterSpi, Object object) {
            super(gdkPixbufWriterSpi);
            this.finit$();
            this.ext = GdkPixbufDecoder.findFormatName(object, true);
        }

        public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
            return null;
        }

        public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
            return null;
        }

        public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
            return null;
        }

        public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
            return null;
        }

        public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
            Object object;
            Object object2;
            RenderedImage renderedImage = iIOImage.getRenderedImage();
            Raster raster = renderedImage.getData();
            int n = raster.getWidth();
            int n2 = raster.getHeight();
            ColorModel colorModel = renderedImage.getColorModel();
            int[] nArray = CairoGraphics2D.findSimpleIntegerArray(renderedImage.getColorModel(), raster);
            if (nArray == null) {
                if (colorModel != null && colorModel.hasAlpha()) {
                    object2 = CairoSurface.getBufferedImage(n, n2);
                }
                object2 = new BufferedImage(n, n2, 1);
                object = new int[4];
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n; ++j) {
                        ((BufferedImage)object2).setRGB(j, i, colorModel.getRGB(raster.getPixel(j, i, (int[])object)));
                    }
                }
                nArray = CairoGraphics2D.findSimpleIntegerArray(((BufferedImage)object2).getColorModel(), ((BufferedImage)object2).getRaster());
                colorModel = ((BufferedImage)object2).getColorModel();
            }
            object2 = new Thread(this, "GdkPixbufWriter");
            ((Thread)object2).start();
            this.processImageStarted(1);
            object = pixbufLock;
            synchronized (object) {
                ArrayList arrayList;
                try {
                    GdkPixbufDecoder.streamImage(nArray, this.ext, n, n2, colorModel.hasAlpha(), this);
                }
                finally {
                    arrayList = null;
                }
                arrayList = this.data;
                synchronized (arrayList) {
                    try {
                        this.data.add(DATADONE);
                        this.data.notifyAll();
                    }
                    finally {
                        Object var13_17 = null;
                    }
                    while (((Thread)object2).isAlive()) {
                        try {
                            ((Thread)object2).join();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (this.exception != null) {
                        throw this.exception;
                    }
                    this.processImageComplete();
                    return;
                }
            }
        }

        private void write(byte[] byArray) {
            ArrayList arrayList = this.data;
            synchronized (arrayList) {
                try {
                    this.data.add(byArray);
                    this.data.notifyAll();
                }
                finally {
                    Object var3_3 = null;
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            boolean bl = false;
            while (!bl) {
                ArrayList arrayList = this.data;
                synchronized (arrayList) {
                    Object object;
                    try {
                        block11: {
                            while (this.data.isEmpty()) {
                                try {
                                    this.data.wait();
                                }
                                catch (InterruptedException interruptedException) {
                                }
                            }
                            object = this.data.remove(0);
                            if (object == DATADONE) {
                                return;
                            }
                            DataOutput dataOutput = (DataOutput)this.getOutput();
                            try {
                                dataOutput.write((byte[])object);
                            }
                            catch (IOException iOException) {
                                if (this.exception != null) break block11;
                                this.exception = iOException;
                            }
                        }
                        object = null;
                    }
                    catch (Throwable throwable) {
                        object = null;
                        throw throwable;
                    }
                }
            }
            return;
        }
    }

    public static class GdkPixbufReaderSpi
    extends ImageReaderSpi {
        public GdkPixbufReaderSpi() {
            super("GdkPixbuf", "2.x", GdkPixbufDecoder.getFormatNames(false), GdkPixbufDecoder.getFormatExtensions(false), GdkPixbufDecoder.getFormatMimeTypes(false), "gnu.java.awt.peer.gtk.GdkPixbufDecoder$GdkPixbufReader", new Class[]{GdkPixbufDecoder.class$("javax.imageio.stream.ImageInputStream")}, new String[]{"gnu.java.awt.peer.gtk.GdkPixbufDecoder$GdkPixbufWriterSpi"}, false, null, null, null, null, false, null, null, null, null);
        }

        public boolean canDecodeInput(Object object) {
            return true;
        }

        public ImageReader createReaderInstance(Object object) {
            return new GdkPixbufReader(this, object);
        }

        public String getDescription(Locale locale) {
            return "GdkPixbuf Reader SPI";
        }
    }

    public static class GdkPixbufWriterSpi
    extends ImageWriterSpi {
        public GdkPixbufWriterSpi() {
            super("GdkPixbuf", "2.x", GdkPixbufDecoder.getFormatNames(true), GdkPixbufDecoder.getFormatExtensions(true), GdkPixbufDecoder.getFormatMimeTypes(true), "gnu.java.awt.peer.gtk.GdkPixbufDecoder$GdkPixbufWriter", new Class[]{GdkPixbufDecoder.class$("javax.imageio.stream.ImageOutputStream")}, new String[]{"gnu.java.awt.peer.gtk.GdkPixbufDecoder$GdkPixbufReaderSpi"}, false, null, null, null, null, false, null, null, null, null);
        }

        public boolean canEncodeImage(ImageTypeSpecifier imageTypeSpecifier) {
            return true;
        }

        public ImageWriter createWriterInstance(Object object) {
            return new GdkPixbufWriter(this, object);
        }

        public String getDescription(Locale locale) {
            return "GdkPixbuf Writer SPI";
        }
    }

    public static class ImageFormatSpec {
        public String name;
        public boolean writable;
        public ArrayList mimeTypes;
        public ArrayList extensions;

        private /* synthetic */ void finit$() {
            this.writable = false;
            this.mimeTypes = new ArrayList();
            this.extensions = new ArrayList();
        }

        public ImageFormatSpec(String string, boolean bl) {
            this.finit$();
            this.name = string;
            this.writable = bl;
        }

        public synchronized void addMimeType(String string) {
            this.mimeTypes.add(string);
        }

        public synchronized void addExtension(String string) {
            this.extensions.add(string);
        }
    }
}

