/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.GtkComponentPeer;
import gnu.java.awt.peer.gtk.GtkToolkit;
import java.awt.AWTEvent;
import java.awt.Choice;
import java.awt.event.ItemEvent;
import java.awt.peer.ChoicePeer;

public class GtkChoicePeer
extends GtkComponentPeer
implements ChoicePeer {
    private int selected;

    public GtkChoicePeer(Choice choice) {
        super(choice);
        int n = choice.getItemCount();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                this.add(choice.getItem(i), i);
            }
            this.selected = choice.getSelectedIndex();
            if (this.selected >= 0) {
                this.select(this.selected);
            }
        } else {
            this.selected = -1;
        }
    }

    native void create();

    native int nativeGetSelected();

    native void connectSignals();

    native void selectNative(int var1);

    native void selectNativeUnlocked(int var1);

    public native void add(String var1, int var2);

    native void nativeRemove(int var1);

    native void nativeRemoveAll();

    public void select(int n) {
        if (Thread.currentThread() == GtkToolkit.mainThread) {
            this.selectNativeUnlocked(n);
        } else {
            this.selectNative(n);
        }
    }

    public void remove(int n) {
        if (n == 0 && this.selected == 0) {
            this.selected = -1;
        }
        this.nativeRemove(n);
    }

    public void removeAll() {
        this.selected = -1;
        this.nativeRemoveAll();
    }

    public void addItem(String string, int n) {
        this.add(string, n);
    }

    protected void postChoiceItemEvent(int n) {
        if (this.selected != n) {
            this.selected = n;
            this.postItemEvent(((Choice)this.awtComponent).getItem(this.selected), 1);
        }
    }

    public void handleEvent(AWTEvent aWTEvent) {
        super.handleEvent(aWTEvent);
        if (aWTEvent instanceof ItemEvent && ((ItemEvent)aWTEvent).getItemSelectable() == this.awtComponent && ((ItemEvent)aWTEvent).getStateChange() == 1) {
            ((Choice)this.awtComponent).select(this.selected);
        }
    }
}

