/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509.ext;

import gnu.java.security.OID;
import gnu.java.security.der.BitString;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.x509.ext.Extension;
import java.io.IOException;

public class KeyUsage
extends Extension.Value {
    public static final OID ID = new OID("2.5.29.15");
    public static final int DIGITAL_SIGNATURE = 0;
    public static final int NON_REPUDIATION = 1;
    public static final int KEY_ENCIPHERMENT = 2;
    public static final int DATA_ENCIPHERMENT = 3;
    public static final int KEY_AGREEMENT = 4;
    public static final int KEY_CERT_SIGN = 5;
    public static final int CRL_SIGN = 6;
    public static final int ENCIPHER_ONLY = 7;
    public static final int DECIPHER_ONLY = 8;
    private final BitString keyUsage;

    public KeyUsage(byte[] byArray) throws IOException {
        super(byArray);
        DERValue dERValue = DERReader.read(byArray);
        if (dERValue.getTag() != 3) {
            throw new IOException("malformed KeyUsage");
        }
        this.keyUsage = (BitString)dERValue.getValue();
    }

    public BitString getKeyUsage() {
        return this.keyUsage;
    }

    public String toString() {
        return KeyUsage.class$("gnu.java.security.x509.ext.KeyUsage").getName() + " [ " + this.keyUsage + " ]";
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

