/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.util.regex;

import gnu.java.util.regex.BacktrackStack;
import gnu.java.util.regex.CharIndexed;
import gnu.java.util.regex.REMatch;
import gnu.java.util.regex.REToken;
import gnu.java.util.regex.RETokenChar;
import java.util.Stack;
import java.util.Vector;

final class RETokenOneOf
extends REToken {
    private Vector options;
    private boolean negative;
    private boolean matchesOneChar;
    private Vector addition;

    RETokenOneOf(int n, String string, boolean bl, boolean bl2) {
        super(n);
        this.options = new Vector();
        this.negative = bl;
        for (int i = 0; i < string.length(); ++i) {
            this.options.addElement(new RETokenChar(n, string.charAt(i), bl2));
        }
        this.matchesOneChar = true;
    }

    RETokenOneOf(int n, Vector vector, boolean bl) {
        super(n);
        this.options = vector;
        this.negative = bl;
        this.matchesOneChar = bl;
    }

    RETokenOneOf(int n, Vector vector, Vector vector2, boolean bl) {
        super(n);
        this.options = vector;
        this.addition = vector2;
        this.negative = bl;
        this.matchesOneChar = bl || vector2 != null;
    }

    int getMinimumLength() {
        if (this.matchesOneChar) {
            return 1;
        }
        int n = Integer.MAX_VALUE;
        for (int i = 0; i < this.options.size(); ++i) {
            int n2 = ((REToken)this.options.elementAt(i)).getMinimumLength();
            if (n2 >= n) continue;
            n = n2;
        }
        return n;
    }

    int getMaximumLength() {
        if (this.matchesOneChar) {
            return 1;
        }
        int n = 0;
        for (int i = 0; i < this.options.size(); ++i) {
            int n2 = ((REToken)this.options.elementAt(i)).getMaximumLength();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    boolean match(CharIndexed charIndexed, REMatch rEMatch) {
        if (this.matchesOneChar) {
            return this.matchOneChar(charIndexed, rEMatch);
        }
        return this.matchOneRE(charIndexed, rEMatch);
    }

    boolean matchOneChar(CharIndexed charIndexed, REMatch rEMatch) {
        boolean bl;
        boolean bl2;
        REMatch rEMatch2;
        if (this.addition == null) {
            rEMatch2 = rEMatch;
            bl2 = false;
        } else {
            rEMatch2 = (REMatch)rEMatch.clone();
            bl2 = true;
        }
        boolean bl3 = bl = this.negative ? this.matchN(charIndexed, rEMatch2, bl2) : this.matchP(charIndexed, rEMatch2, bl2);
        if (this.addition == null) {
            return bl;
        }
        Stack stack = new Stack();
        stack.push(new Boolean(bl));
        for (int i = 0; i < this.addition.size(); ++i) {
            Object object = this.addition.elementAt(i);
            if (object instanceof REToken) {
                bl = ((REToken)object).match(charIndexed, (REMatch)rEMatch.clone());
                stack.push(new Boolean(bl));
                continue;
            }
            if (object instanceof Boolean) {
                stack.push(object);
                continue;
            }
            if (object.equals("|")) {
                bl = (Boolean)stack.pop();
                bl = (Boolean)stack.pop() != false || bl;
                stack.push(new Boolean(bl));
                continue;
            }
            if (object.equals("&")) {
                bl = (Boolean)stack.pop();
                bl = (Boolean)stack.pop() != false && bl;
                stack.push(new Boolean(bl));
                continue;
            }
            throw new RuntimeException("Invalid object found");
        }
        bl = (Boolean)stack.pop();
        if (bl) {
            ++rEMatch.index;
            return this.next(charIndexed, rEMatch);
        }
        return false;
    }

    private boolean matchN(CharIndexed charIndexed, REMatch rEMatch, boolean bl) {
        if (charIndexed.charAt(rEMatch.index) == '\uffff') {
            return false;
        }
        Object var4_4 = null;
        Object var5_5 = null;
        for (int i = 0; i < this.options.size(); ++i) {
            REMatch rEMatch2;
            REToken rEToken = (REToken)this.options.elementAt(i);
            if (!rEToken.match(charIndexed, rEMatch2 = (REMatch)rEMatch.clone())) continue;
            return false;
        }
        if (bl) {
            return true;
        }
        ++rEMatch.index;
        return this.next(charIndexed, rEMatch);
    }

    private boolean matchP(CharIndexed charIndexed, REMatch rEMatch, boolean bl) {
        for (int i = 0; i < this.options.size(); ++i) {
            REMatch rEMatch2;
            REToken rEToken = (REToken)this.options.elementAt(i);
            if (!rEToken.match(charIndexed, rEMatch2 = (REMatch)rEMatch.clone())) continue;
            if (bl) {
                return true;
            }
            if (!this.next(charIndexed, rEMatch2)) continue;
            rEMatch.assignFrom(rEMatch2);
            return true;
        }
        return false;
    }

    private boolean matchOneRE(CharIndexed charIndexed, REMatch rEMatch) {
        REMatch rEMatch2 = this.findMatch(charIndexed, rEMatch);
        if (rEMatch2 != null) {
            rEMatch.assignFrom(rEMatch2);
            return true;
        }
        return false;
    }

    REMatch findMatch(CharIndexed charIndexed, REMatch rEMatch) {
        if (this.matchesOneChar) {
            return super.findMatch(charIndexed, rEMatch);
        }
        return this.findMatch(charIndexed, rEMatch, 0);
    }

    REMatch backtrack(CharIndexed charIndexed, REMatch rEMatch, Object object) {
        return this.findMatch(charIndexed, rEMatch, (Integer)object);
    }

    private REMatch findMatch(CharIndexed charIndexed, REMatch rEMatch, int n) {
        for (int i = n; i < this.options.size(); ++i) {
            boolean bl;
            REToken rEToken = (REToken)this.options.elementAt(i);
            rEToken = (REToken)rEToken.clone();
            rEToken.chain(this.getNext());
            REMatch rEMatch2 = (REMatch)rEMatch.clone();
            if (rEMatch2.backtrackStack == null) {
                rEMatch2.backtrackStack = new BacktrackStack();
            }
            boolean bl2 = false;
            if (i + 1 < this.options.size()) {
                rEMatch2.backtrackStack.push(new BacktrackStack.Backtrack(this, charIndexed, rEMatch, new Integer(i + 1)));
                bl2 = true;
            }
            if (bl = rEToken.match(charIndexed, rEMatch2)) {
                return rEMatch2;
            }
            if (!bl2) continue;
            rEMatch2.backtrackStack.pop();
        }
        return null;
    }

    boolean returnsFixedLengthMatches() {
        return this.matchesOneChar;
    }

    int findFixedLengthMatches(CharIndexed charIndexed, REMatch rEMatch, int n) {
        int n2;
        if (!this.matchesOneChar) {
            return super.findFixedLengthMatches(charIndexed, rEMatch, n);
        }
        REMatch rEMatch2 = (REMatch)rEMatch.clone();
        REToken rEToken = (REToken)this.clone();
        rEToken.chain(null);
        for (n2 = 0; n2 < n && (rEMatch2 = rEToken.findMatch(charIndexed, rEMatch2)) != null; ++n2) {
        }
        return n2;
    }

    void dump(StringBuffer stringBuffer) {
        stringBuffer.append(this.negative ? "[^" : "(?:");
        for (int i = 0; i < this.options.size(); ++i) {
            if (!this.negative && i > 0) {
                stringBuffer.append('|');
            }
            ((REToken)this.options.elementAt(i)).dumpAll(stringBuffer);
        }
        stringBuffer.append(this.negative ? (char)']' : ')');
    }
}

