/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.bmp;

import gnu.javax.imageio.bmp.BMPImageWriter;
import gnu.javax.imageio.bmp.BMPInfoHeader;
import java.util.Locale;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;

public class BMPImageWriterSpi
extends ImageWriterSpi {
    static final String vendorName = "GNU";
    static final String version = "0.1";
    static final String writerClassName = "gnu.javax.imageio.bmp.BMPImageWriter";
    static final String[] names;
    static final String[] suffixes;
    static final String[] MIMETypes;
    static final String[] readerSpiNames;
    static final boolean supportsStandardStreamMetadataFormat = false;
    static final String nativeStreamMetadataFormatName;
    static final String nativeStreamMetadataFormatClassName;
    static final String[] extraStreamMetadataFormatNames;
    static final String[] extraStreamMetadataFormatClassNames;
    static final boolean supportsStandardImageMetadataFormat = false;
    static final String nativeImageMetadataFormatName;
    static final String nativeImageMetadataFormatClassName;
    static final String[] extraImageMetadataFormatNames;
    static final String[] extraImageMetadataFormatClassNames;
    private BMPImageWriter writerInstance;

    public BMPImageWriterSpi() {
        super(vendorName, version, names, suffixes, MIMETypes, writerClassName, ImageWriterSpi.STANDARD_OUTPUT_TYPE, readerSpiNames, false, nativeStreamMetadataFormatName, nativeStreamMetadataFormatClassName, extraStreamMetadataFormatNames, extraStreamMetadataFormatClassNames, false, nativeImageMetadataFormatName, nativeImageMetadataFormatClassName, extraImageMetadataFormatNames, extraImageMetadataFormatClassNames);
    }

    public boolean canEncodeImage(ImageTypeSpecifier imageTypeSpecifier) {
        if (imageTypeSpecifier == null) {
            return false;
        }
        BMPInfoHeader bMPInfoHeader = this.writerInstance.infoHeader;
        if (bMPInfoHeader != null) {
            int n = bMPInfoHeader.getCompression();
            int n2 = imageTypeSpecifier.getColorModel().getPixelSize();
            if (n == 2 && (n2 != 4 || n2 != 8) || n == 0 && (n2 != 1 || n2 != 4 || n2 != 8 || n2 != 16 || n2 != 24 || n2 != 32)) {
                return false;
            }
        }
        return true;
    }

    public ImageWriter createWriterInstance(Object object) {
        this.writerInstance = object != null && object instanceof ImageWriterSpi ? new BMPImageWriter((ImageWriterSpi)object) : new BMPImageWriter(this);
        return this.writerInstance;
    }

    public BMPImageWriter getWriterInstance() {
        if (this.writerInstance != null) {
            return this.writerInstance;
        }
        return (BMPImageWriter)this.createWriterInstance(null);
    }

    public String getDescription(Locale locale) {
        return "Microsoft BMP v3";
    }

    static {
        vendorName = vendorName;
        version = version;
        writerClassName = writerClassName;
        names = new String[]{"Microsoft Windows BMP"};
        suffixes = new String[]{".bmp", ".bm"};
        MIMETypes = new String[]{"image/bmp", "image/x-windows-bmp"};
        readerSpiNames = new String[]{"gnu.javax.imageio.bmp.BMPImageReaderSpi"};
        nativeStreamMetadataFormatName = null;
        nativeStreamMetadataFormatClassName = null;
        extraStreamMetadataFormatNames = null;
        extraStreamMetadataFormatClassNames = null;
        nativeImageMetadataFormatName = null;
        nativeImageMetadataFormatClassName = null;
        extraImageMetadataFormatNames = null;
        extraImageMetadataFormatClassNames = null;
    }
}

