/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom.ls;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class ReaderInputStream
extends InputStream {
    private Reader reader;
    private String encoding;
    private byte[] extra;
    private int pos;
    private byte[] extra_marked;
    private int pos_marked;

    public ReaderInputStream(Reader reader) {
        this.reader = reader;
        this.encoding = "UTF-8";
    }

    void setEncoding(String string) {
        this.encoding = string;
    }

    public int read() throws IOException {
        if (this.extra != null) {
            byte by = this.extra[this.pos];
            ++this.pos;
            if (this.pos >= this.extra.length) {
                this.extra = null;
            }
            return by;
        }
        return this.reader.read();
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return 0;
        }
        if (this.extra != null) {
            int n3 = this.extra.length - this.pos;
            int n4 = n3 < n2 ? n3 : n2;
            System.arraycopy(this.extra, 0, byArray, n, n4);
            this.pos += n4;
            if (this.pos >= this.extra.length) {
                this.extra = null;
            }
            return n4;
        }
        char[] cArray = new char[n2];
        int n5 = this.reader.read(cArray, 0, n2);
        if (n5 == -1) {
            return -1;
        }
        String string = new String(cArray, 0, n5);
        byte[] byArray2 = string.getBytes(this.encoding);
        int n6 = byArray2.length;
        int n7 = byArray2.length - n2;
        if (n7 > 0) {
            this.extra = new byte[n7];
            this.pos = 0;
            System.arraycopy(byArray2, n2, this.extra, 0, n7);
            n6 -= n7;
        }
        System.arraycopy(byArray2, 0, byArray, n, n6);
        return n6;
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public boolean markSupported() {
        return this.reader.markSupported();
    }

    public void mark(int n) {
        if (this.extra != null) {
            this.extra_marked = new byte[this.extra.length];
            System.arraycopy(this.extra, 0, this.extra_marked, 0, this.extra.length);
            this.pos_marked = this.pos;
        } else {
            this.extra_marked = null;
        }
        try {
            this.reader.mark(n);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void reset() throws IOException {
        this.extra = this.extra_marked;
        this.pos = this.pos_marked;
        this.extra_marked = null;
        this.reader.reset();
    }

    public long skip(long l) throws IOException {
        long l2 = 0L;
        if (this.extra != null) {
            int n = this.extra.length - this.pos;
            l2 = (long)n < l ? (long)n : l;
            this.pos += (int)l2;
            if (this.pos >= this.extra.length) {
                this.extra = null;
            }
        }
        if ((l -= l2) > 0L) {
            return this.reader.skip(l) + l2;
        }
        return l2;
    }

    public int available() throws IOException {
        if (this.extra != null) {
            return this.pos - this.extra.length;
        }
        if (this.reader.ready()) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.reader + ", " + this.encoding + "]";
    }
}

