/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class LongType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{11, 12, 4, 6, 5, 7, 8, 10, 9};
    static final String MAX_VALUE = "9223372036854775807";
    static final String MIN_VALUE = "9223372036854775808";
    static final int LENGTH;

    LongType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "long"), TypeLibrary.INTEGER);
    }

    public int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    public void checkValid(String string, ValidationContext validationContext) throws DatatypeException {
        super.checkValid(string, validationContext);
        int n = string.length();
        if (n == 0) {
            throw new DatatypeException(0, "invalid long value");
        }
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        String string2 = MAX_VALUE;
        char c = string.charAt(0);
        if (c == '+') {
            ++n2;
        } else if (c == '-') {
            string2 = MIN_VALUE;
            ++n2;
        }
        if (n - n2 > LENGTH) {
            throw new DatatypeException(n2, "invalid long value");
        }
        if (n - n2 == LENGTH) {
            bl = true;
        }
        while (n2 < n) {
            c = string.charAt(n2);
            if (c >= '0' && c <= '9') {
                if (bl) {
                    char c2 = string2.charAt(n3);
                    if (Character.digit(c, 10) > Character.digit(c2, 10)) {
                        throw new DatatypeException(n2, "invalid long value");
                    }
                }
                ++n3;
            } else {
                throw new DatatypeException(n2, "invalid long value");
            }
            ++n2;
        }
    }

    public Object createValue(String string, ValidationContext validationContext) {
        try {
            return new Long(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    static {
        MAX_VALUE = MAX_VALUE;
        MIN_VALUE = MIN_VALUE;
        LENGTH = MAX_VALUE.length();
    }
}

