/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import gnu.classpath.NotImplementedException;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DragSourceMotionListener;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.io.Serializable;
import java.util.TooManyListenersException;

public class DragSourceContext
implements DragSourceListener,
DragSourceMotionListener,
Serializable {
    static final long serialVersionUID = -115407898692194719L;
    protected static final int DEFAULT = 0;
    protected static final int ENTER = 1;
    protected static final int OVER = 2;
    protected static final int CHANGED = 3;
    private DragSourceContextPeer peer;
    private Cursor cursor;
    private Transferable transferable;
    private DragGestureEvent trigger;
    private DragSourceListener dragSourceListener;
    private boolean useCustomCursor;
    private int sourceActions;
    private Image image;
    private Point offset;

    public DragSourceContext(DragSourceContextPeer dragSourceContextPeer, DragGestureEvent dragGestureEvent, Cursor cursor, Image image, Point point, Transferable transferable, DragSourceListener dragSourceListener) {
        if (dragSourceContextPeer == null || dragGestureEvent == null || transferable == null || image != null && point == null) {
            throw new NullPointerException();
        }
        if (dragGestureEvent.getComponent() == null || dragGestureEvent.getDragSource() == null || dragGestureEvent.getDragAction() == 0 || dragGestureEvent.getSourceAsDragGestureRecognizer().getSourceActions() == 0) {
            throw new IllegalArgumentException();
        }
        this.peer = dragSourceContextPeer;
        this.trigger = dragGestureEvent;
        this.cursor = cursor;
        this.image = image;
        this.offset = point;
        this.transferable = transferable;
        this.dragSourceListener = dragSourceListener;
        this.sourceActions = dragGestureEvent.getSourceAsDragGestureRecognizer().getSourceActions();
        this.setCursor(cursor);
        this.updateCurrentCursor(dragGestureEvent.getDragAction(), this.sourceActions, 0);
    }

    public DragSource getDragSource() {
        return this.trigger.getDragSource();
    }

    public Component getComponent() {
        return this.trigger.getComponent();
    }

    public DragGestureEvent getTrigger() {
        return this.trigger;
    }

    public int getSourceActions() {
        if (this.sourceActions == 0) {
            this.sourceActions = this.trigger.getSourceAsDragGestureRecognizer().getSourceActions();
        }
        return this.sourceActions;
    }

    public void setCursor(Cursor cursor) {
        this.useCustomCursor = cursor != null;
        this.cursor = cursor;
        this.peer.setCursor(cursor);
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public void addDragSourceListener(DragSourceListener dragSourceListener) throws TooManyListenersException {
        if (this.dragSourceListener != null) {
            throw new TooManyListenersException();
        }
        this.dragSourceListener = dragSourceListener;
    }

    public void removeDragSourceListener(DragSourceListener dragSourceListener) {
        if (this.dragSourceListener == dragSourceListener) {
            this.dragSourceListener = null;
        }
    }

    public void transferablesFlavorsChanged() {
        this.peer.transferablesFlavorsChanged();
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        if (this.dragSourceListener != null) {
            this.dragSourceListener.dragEnter(dragSourceDragEvent);
        }
        DragSource dragSource = this.getDragSource();
        DragSourceListener[] dragSourceListenerArray = dragSource.getDragSourceListeners();
        for (int i = 0; i < dragSourceListenerArray.length; ++i) {
            dragSourceListenerArray[i].dragEnter(dragSourceDragEvent);
        }
        this.updateCurrentCursor(dragSourceDragEvent.getDropAction(), dragSourceDragEvent.getTargetActions(), 1);
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        if (this.dragSourceListener != null) {
            this.dragSourceListener.dragOver(dragSourceDragEvent);
        }
        DragSource dragSource = this.getDragSource();
        DragSourceListener[] dragSourceListenerArray = dragSource.getDragSourceListeners();
        for (int i = 0; i < dragSourceListenerArray.length; ++i) {
            dragSourceListenerArray[i].dragOver(dragSourceDragEvent);
        }
        this.updateCurrentCursor(dragSourceDragEvent.getDropAction(), dragSourceDragEvent.getTargetActions(), 2);
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
        if (this.dragSourceListener != null) {
            this.dragSourceListener.dragExit(dragSourceEvent);
        }
        DragSource dragSource = this.getDragSource();
        DragSourceListener[] dragSourceListenerArray = dragSource.getDragSourceListeners();
        for (int i = 0; i < dragSourceListenerArray.length; ++i) {
            dragSourceListenerArray[i].dragExit(dragSourceEvent);
        }
        this.updateCurrentCursor(0, 0, 0);
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        if (this.dragSourceListener != null) {
            this.dragSourceListener.dropActionChanged(dragSourceDragEvent);
        }
        DragSource dragSource = this.getDragSource();
        DragSourceListener[] dragSourceListenerArray = dragSource.getDragSourceListeners();
        for (int i = 0; i < dragSourceListenerArray.length; ++i) {
            dragSourceListenerArray[i].dropActionChanged(dragSourceDragEvent);
        }
        this.updateCurrentCursor(dragSourceDragEvent.getDropAction(), dragSourceDragEvent.getTargetActions(), 3);
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        if (this.dragSourceListener != null) {
            this.dragSourceListener.dragDropEnd(dragSourceDropEvent);
        }
        DragSource dragSource = this.getDragSource();
        DragSourceListener[] dragSourceListenerArray = dragSource.getDragSourceListeners();
        for (int i = 0; i < dragSourceListenerArray.length; ++i) {
            dragSourceListenerArray[i].dragDropEnd(dragSourceDropEvent);
        }
    }

    public void dragMouseMoved(DragSourceDragEvent dragSourceDragEvent) {
        DragSource dragSource = this.getDragSource();
        DragSourceMotionListener[] dragSourceMotionListenerArray = dragSource.getDragSourceMotionListeners();
        for (int i = 0; i < dragSourceMotionListenerArray.length; ++i) {
            dragSourceMotionListenerArray[i].dragMouseMoved(dragSourceDragEvent);
        }
    }

    public Transferable getTransferable() {
        return this.transferable;
    }

    protected void updateCurrentCursor(int n, int n2, int n3) throws NotImplementedException {
        if (!this.useCustomCursor) {
            Cursor cursor = null;
            switch (n3) {
                case 1: {
                    break;
                }
                case 3: {
                    break;
                }
                case 2: {
                    break;
                }
            }
            this.cursor = cursor;
            this.peer.setCursor(cursor);
        }
    }
}

