/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImagingOpException;
import java.awt.image.Kernel;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;

public class ConvolveOp
implements BufferedImageOp,
RasterOp {
    public static final int EDGE_ZERO_FILL = 0;
    public static final int EDGE_NO_OP = 1;
    private Kernel kernel;
    private int edge;
    private RenderingHints hints;

    public ConvolveOp(Kernel kernel, int n, RenderingHints renderingHints) {
        this.kernel = kernel;
        this.edge = n;
        this.hints = renderingHints;
    }

    public ConvolveOp(Kernel kernel) {
        this.kernel = kernel;
        this.edge = 0;
        this.hints = null;
    }

    public final BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (bufferedImage == bufferedImage2) {
            throw new IllegalArgumentException();
        }
        if (bufferedImage2 == null) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, bufferedImage.getColorModel());
        }
        BufferedImage bufferedImage3 = bufferedImage;
        if (!bufferedImage.isPremultiplied) {
            bufferedImage3 = this.createCompatibleDestImage(bufferedImage, bufferedImage.getColorModel());
            bufferedImage.copyData(bufferedImage3.getRaster());
            bufferedImage3.coerceData(true);
        }
        BufferedImage bufferedImage4 = bufferedImage2;
        if (!bufferedImage.getColorModel().equals(bufferedImage2.getColorModel())) {
            bufferedImage4 = this.createCompatibleDestImage(bufferedImage, bufferedImage.getColorModel());
        }
        this.filter(bufferedImage3.getRaster(), bufferedImage4.getRaster());
        if (bufferedImage4 != bufferedImage2) {
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.setRenderingHints(this.hints);
            graphics2D.drawImage((Image)bufferedImage4, 0, 0, null);
            graphics2D.dispose();
        }
        return bufferedImage2;
    }

    public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
        return new BufferedImage(colorModel, bufferedImage.getRaster().createCompatibleWritableRaster(), bufferedImage.isPremultiplied, null);
    }

    public final RenderingHints getRenderingHints() {
        return this.hints;
    }

    public int getEdgeCondition() {
        return this.edge;
    }

    public final Kernel getKernel() {
        return (Kernel)this.kernel.clone();
    }

    public final WritableRaster filter(Raster raster, WritableRaster writableRaster) {
        if (raster == writableRaster) {
            throw new IllegalArgumentException("src == dest is not allowed.");
        }
        if (this.kernel.getWidth() > raster.getWidth() || this.kernel.getHeight() > raster.getHeight()) {
            throw new ImagingOpException("The kernel is too large.");
        }
        if (writableRaster == null) {
            writableRaster = this.createCompatibleDestRaster(raster);
        } else if (raster.getNumBands() != writableRaster.getNumBands()) {
            throw new ImagingOpException("src and dest have different band counts.");
        }
        int n = this.kernel.getWidth();
        int n2 = this.kernel.getHeight();
        int n3 = this.kernel.getXOrigin();
        int n4 = Math.max(n - n3 - 1, 0);
        int n5 = this.kernel.getYOrigin();
        int n6 = Math.max(n2 - n5 - 1, 0);
        int n7 = raster.width - n3 - n4;
        int n8 = raster.height - n5 - n6;
        float[] fArray = this.kernel.getKernelData(null);
        float[] fArray2 = new float[n * n2];
        for (int i = 0; i < n7; ++i) {
            for (int j = 0; j < n8; ++j) {
                for (int k = 0; k < raster.getNumBands(); ++k) {
                    float f = 0.0f;
                    raster.getSamples(i, j, n, n2, k, fArray2);
                    for (int i2 = 0; i2 < fArray2.length; ++i2) {
                        f += fArray2[fArray2.length - i2 - 1] * fArray[i2];
                    }
                    writableRaster.setSample(i + this.kernel.getXOrigin(), j + this.kernel.getYOrigin(), k, f);
                }
            }
        }
        this.fillEdge(raster, writableRaster, 0, 0, raster.width, n5, this.edge);
        this.fillEdge(raster, writableRaster, 0, raster.height - n6, raster.width, n6, this.edge);
        this.fillEdge(raster, writableRaster, 0, n5, n3, n8, this.edge);
        this.fillEdge(raster, writableRaster, raster.width - n4, n5, n4, n8, this.edge);
        return writableRaster;
    }

    private void fillEdge(Raster raster, WritableRaster writableRaster, int n, int n2, int n3, int n4, int n5) {
        if (n3 <= 0) {
            return;
        }
        if (n4 <= 0) {
            return;
        }
        if (n5 == 0) {
            float[] fArray = new float[raster.getNumBands() * n3 * n4];
            writableRaster.setPixels(n, n2, n3, n4, fArray);
        } else {
            float[] fArray = new float[raster.getNumBands() * n3 * n4];
            raster.getPixels(n, n2, n3, n4, fArray);
            writableRaster.setPixels(n, n2, n3, n4, fArray);
        }
    }

    public WritableRaster createCompatibleDestRaster(Raster raster) {
        return raster.createCompatibleWritableRaster();
    }

    public final Rectangle2D getBounds2D(BufferedImage bufferedImage) {
        return bufferedImage.getRaster().getBounds();
    }

    public final Rectangle2D getBounds2D(Raster raster) {
        return raster.getBounds();
    }

    public final Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            return (Point2D)point2D.clone();
        }
        point2D2.setLocation(point2D);
        return point2D2;
    }
}

