/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.ByteOrder;
import java.nio.DoubleBufferImpl;

public abstract class DoubleBuffer
extends Buffer
implements Comparable {
    int array_offset = 0;
    double[] backing_buffer;

    DoubleBuffer(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    public static DoubleBuffer allocate(int n) {
        return new DoubleBufferImpl(n);
    }

    public static final DoubleBuffer wrap(double[] dArray, int n, int n2) {
        return new DoubleBufferImpl(dArray, 0, dArray.length, n + n2, n, -1, false);
    }

    public static final DoubleBuffer wrap(double[] dArray) {
        return DoubleBuffer.wrap(dArray, 0, dArray.length);
    }

    public DoubleBuffer get(double[] dArray, int n, int n2) {
        Buffer.checkArraySize(dArray.length, n, n2);
        this.checkForUnderflow(n2);
        for (int i = n; i < n + n2; ++i) {
            dArray[i] = this.get();
        }
        return this;
    }

    public DoubleBuffer get(double[] dArray) {
        return this.get(dArray, 0, dArray.length);
    }

    public DoubleBuffer put(DoubleBuffer doubleBuffer) {
        if (doubleBuffer == this) {
            throw new IllegalArgumentException();
        }
        this.checkForOverflow(doubleBuffer.remaining());
        if (doubleBuffer.remaining() > 0) {
            double[] dArray = new double[doubleBuffer.remaining()];
            doubleBuffer.get(dArray);
            this.put(dArray);
        }
        return this;
    }

    public DoubleBuffer put(double[] dArray, int n, int n2) {
        Buffer.checkArraySize(dArray.length, n, n2);
        this.checkForOverflow(n2);
        for (int i = n; i < n + n2; ++i) {
            this.put(dArray[i]);
        }
        return this;
    }

    public final DoubleBuffer put(double[] dArray) {
        return this.put(dArray, 0, dArray.length);
    }

    public final boolean hasArray() {
        return this.backing_buffer != null && !this.isReadOnly();
    }

    public final double[] array() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        this.checkIfReadOnly();
        return this.backing_buffer;
    }

    public final int arrayOffset() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        this.checkIfReadOnly();
        return this.array_offset;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.get(this.position())) + (long)31;
        long l2 = 1L;
        for (int i = this.position() + 1; i < this.limit(); ++i) {
            l += (Double.doubleToLongBits(this.get(i)) + (long)30) * (l2 *= (long)31);
        }
        return (int)l;
    }

    public boolean equals(Object object) {
        if (object instanceof DoubleBuffer) {
            return this.compareTo(object) == 0;
        }
        return false;
    }

    public int compareTo(Object object) {
        DoubleBuffer doubleBuffer = (DoubleBuffer)object;
        int n = Math.min(this.remaining(), doubleBuffer.remaining());
        int n2 = this.position();
        int n3 = doubleBuffer.position();
        for (int i = 0; i < n; ++i) {
            double d;
            double d2;
            if ((d2 = this.get(n2++)) == (d = doubleBuffer.get(n3++))) continue;
            if (d2 < d) {
                return -1;
            }
            return 1;
        }
        return this.remaining() - doubleBuffer.remaining();
    }

    public abstract ByteOrder order();

    public abstract double get();

    public abstract DoubleBuffer put(double var1);

    public abstract double get(int var1);

    public abstract DoubleBuffer put(int var1, double var2);

    public abstract DoubleBuffer compact();

    public abstract boolean isDirect();

    public abstract DoubleBuffer slice();

    public abstract DoubleBuffer duplicate();

    public abstract DoubleBuffer asReadOnlyBuffer();
}

