/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.io.ByteArrayInputStream;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;

public abstract class Certificate
implements Serializable {
    private static final long serialVersionUID = -3585440601605666277L;
    private String type;

    protected Certificate(String string) {
        this.type = string;
    }

    public final String getType() {
        return this.type;
    }

    public boolean equals(Object object) {
        if (object instanceof Certificate) {
            try {
                Certificate certificate = (Certificate)object;
                if (this.getEncoded().length != certificate.getEncoded().length) {
                    return false;
                }
                byte[] byArray = this.getEncoded();
                byte[] byArray2 = certificate.getEncoded();
                for (int i = 0; i < byArray.length; ++i) {
                    if (byArray[i] == byArray2[i]) continue;
                    return false;
                }
            }
            catch (CertificateEncodingException certificateEncodingException) {
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public abstract byte[] getEncoded() throws CertificateEncodingException;

    public abstract void verify(PublicKey var1) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    public abstract void verify(PublicKey var1, String var2) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    public abstract String toString();

    public abstract PublicKey getPublicKey();

    protected Object writeReplace() throws ObjectStreamException {
        try {
            return new CertificateRep(this.getType(), this.getEncoded());
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new InvalidObjectException(certificateEncodingException.toString());
        }
    }

    protected static class CertificateRep
    implements Serializable {
        private static final long serialVersionUID = -8563758940495660020L;
        private String type;
        private byte[] data;

        protected CertificateRep(String string, byte[] byArray) {
            this.type = string;
            this.data = byArray;
        }

        protected Object readResolve() throws ObjectStreamException {
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance(this.type);
                return certificateFactory.generateCertificate(new ByteArrayInputStream(this.data));
            }
            catch (Exception exception) {
                throw new InvalidObjectException(exception.toString());
            }
        }
    }
}

