/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public final class Currency
implements Serializable {
    static final long serialVersionUID = -158308464356906721L;
    private transient Locale locale;
    private transient ResourceBundle res;
    private String currencyCode;
    private static transient Map cache = new HashMap();

    private Currency() {
    }

    private Currency(Locale locale) {
        this.locale = locale;
        this.res = ResourceBundle.getBundle("gnu.java.locale.LocaleInformation", this.locale, ClassLoader.getSystemClassLoader());
        try {
            this.currencyCode = this.res.getString("intlCurrencySymbol");
        }
        catch (Exception exception) {
            this.currencyCode = null;
        }
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public int getDefaultFractionDigits() {
        NumberFormat numberFormat = NumberFormat.getCurrencyInstance(this.locale);
        return numberFormat.getMaximumFractionDigits();
    }

    public static Currency getInstance(Locale locale) {
        Currency currency = (Currency)cache.get(locale);
        if (currency == null) {
            currency = new Currency(locale);
            cache.put(locale, currency);
        }
        return currency;
    }

    public static Currency getInstance(String string) {
        Locale[] localeArray = Locale.getAvailableLocales();
        for (int i = 0; i < localeArray.length; ++i) {
            Currency currency = Currency.getInstance(localeArray[i]);
            if (currency.getCurrencyCode() == null || !currency.getCurrencyCode().equals(string)) continue;
            return currency;
        }
        throw new IllegalArgumentException("The currency code, " + string + ", is not supported.");
    }

    public String getSymbol() {
        try {
            return this.res.getString("currencySymbol");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getSymbol(Locale locale) {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("gnu.java.locale.LocaleInformation", locale, Currency.class$("java.util.Currency").getClassLoader());
            if (resourceBundle.equals(this.res)) {
                return resourceBundle.getString("currencySymbol");
            }
            return resourceBundle.getString("intlCurrencySymbol");
        }
        catch (Exception exception) {
            try {
                return this.res.getString("intlCurrencySymbol");
            }
            catch (Exception exception2) {
                return null;
            }
        }
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public String toString() {
        return this.getCurrencyCode();
    }

    private Object readResolve() throws ObjectStreamException {
        return Currency.getInstance(this.currencyCode);
    }
}

