/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.directory;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;

public class BasicAttribute
implements Attribute {
    private static final long serialVersionUID = 6743528196119291326L;
    protected String attrID;
    protected boolean ordered;
    protected transient Vector values;

    private BasicAttribute() {
    }

    public BasicAttribute(String string) {
        this(string, false);
    }

    public BasicAttribute(String string, boolean bl) {
        this.attrID = string;
        this.ordered = bl;
        this.values = new Vector();
    }

    public BasicAttribute(String string, Object object) {
        this(string, object, false);
    }

    public BasicAttribute(String string, Object object, boolean bl) {
        this.attrID = string;
        this.ordered = bl;
        this.values = new Vector();
        this.values.add(object);
    }

    public void add(int n, Object object) {
        if (!this.ordered && this.contains(object)) {
            throw new IllegalStateException("value already in attribute");
        }
        this.values.add(n, object);
    }

    public boolean add(Object object) {
        if (!this.ordered && this.contains(object)) {
            throw new IllegalStateException("value already in attribute");
        }
        return this.values.add(object);
    }

    public void clear() {
        this.values.clear();
    }

    public Object clone() {
        BasicAttribute basicAttribute = new BasicAttribute();
        basicAttribute.attrID = this.attrID;
        basicAttribute.ordered = this.ordered;
        basicAttribute.values = (Vector)this.values.clone();
        return basicAttribute;
    }

    public boolean contains(Object object) {
        for (int i = 0; i < this.values.size(); ++i) {
            if (!this.equals(object, this.values.get(i))) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BasicAttribute)) {
            return false;
        }
        BasicAttribute basicAttribute = (BasicAttribute)object;
        if (this.ordered != basicAttribute.ordered || !this.attrID.equals(basicAttribute.attrID) || this.values.size() != basicAttribute.values.size()) {
            return false;
        }
        for (int i = 0; i < this.values.size(); ++i) {
            boolean bl = false;
            if (this.ordered) {
                bl = this.equals(this.values.get(i), basicAttribute.values.get(i));
            } else {
                for (int j = 0; j < basicAttribute.values.size(); ++j) {
                    if (!this.equals(this.values.get(i), basicAttribute.values.get(j))) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public Object get() throws NamingException {
        if (this.values.size() == 0) {
            throw new NoSuchElementException("no values");
        }
        return this.get(0);
    }

    public Object get(int n) throws NamingException {
        return this.values.get(n);
    }

    public NamingEnumeration getAll() throws NamingException {
        return new BasicAttributeEnumeration(this);
    }

    public DirContext getAttributeDefinition() throws OperationNotSupportedException, NamingException {
        throw new OperationNotSupportedException();
    }

    public DirContext getAttributeSyntaxDefinition() throws OperationNotSupportedException, NamingException {
        throw new OperationNotSupportedException();
    }

    public String getID() {
        return this.attrID;
    }

    public int hashCode() {
        int n = this.attrID.hashCode();
        for (int i = 0; i < this.values.size(); ++i) {
            Object object = this.values.get(i);
            if (object == null) continue;
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                for (int j = 0; j < objectArray.length; ++j) {
                    n += objectArray[j].hashCode();
                }
                continue;
            }
            n += object.hashCode();
        }
        return n;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public Object remove(int n) {
        return this.values.remove(n);
    }

    public boolean remove(Object object) {
        for (int i = 0; i < this.values.size(); ++i) {
            if (!this.equals(object, this.values.get(i))) continue;
            this.values.remove(i);
            return true;
        }
        return false;
    }

    public Object set(int n, Object object) {
        if (!this.ordered && this.contains(object)) {
            throw new IllegalStateException("value already in attribute");
        }
        return this.values.set(n, object);
    }

    public int size() {
        return this.values.size();
    }

    public String toString() {
        String string = this.attrID;
        for (int i = 0; i < this.values.size(); ++i) {
            string = string + new StringBuffer(";").append(this.values.get(i).toString());
        }
        return string;
    }

    private boolean equals(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        if (object instanceof Object[]) {
            if (!(object2 instanceof Object[])) {
                return false;
            }
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])object2;
            if (objectArray.length != objectArray2.length) {
                return false;
            }
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i].equals(objectArray2[i])) continue;
                return false;
            }
            return true;
        }
        return object.equals(object2);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.values = new Vector(n);
        for (int i = 0; i < n; ++i) {
            this.values.add(objectInputStream.readObject());
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.values.size());
        for (int i = 0; i < this.values.size(); ++i) {
            objectOutputStream.writeObject(this.values.get(i));
        }
    }

    private class BasicAttributeEnumeration
    implements NamingEnumeration {
        private /* synthetic */ BasicAttribute this$0;
        int where;

        private /* synthetic */ void finit$() {
            this.where = 0;
        }

        public BasicAttributeEnumeration(BasicAttribute basicAttribute) {
            this.this$0 = basicAttribute;
            this.finit$();
        }

        public void close() throws NamingException {
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public boolean hasMoreElements() {
            return this.where < this.this$0.values.size();
        }

        public Object nextElement() throws NoSuchElementException {
            if (this.where == this.this$0.values.size()) {
                throw new NoSuchElementException("no more elements");
            }
            return this.this$0.values.get(this.where++);
        }
    }
}

