/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.BevelBorder;

public class SoftBevelBorder
extends BevelBorder {
    static final long serialVersionUID = 5248789787305979975L;

    public SoftBevelBorder(int n) {
        super(n);
    }

    public SoftBevelBorder(int n, Color color, Color color2) {
        this(n, color.brighter(), color, color2, color2.brighter());
    }

    public SoftBevelBorder(int n, Color color, Color color2, Color color3, Color color4) {
        super(n, color, color2, color3, color4);
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        switch (this.bevelType) {
            case 0: {
                SoftBevelBorder.paintSoftBevel(graphics, n, n2, n3, n4, this.getHighlightOuterColor(component), this.getHighlightInnerColor(component), this.getShadowInnerColor(component), this.getShadowOuterColor(component));
                break;
            }
            case 1: {
                SoftBevelBorder.paintSoftBevel(graphics, n, n2, n3, n4, this.getShadowOuterColor(component), this.getShadowInnerColor(component), this.getHighlightInnerColor(component), this.getHighlightOuterColor(component));
            }
        }
    }

    public Insets getBorderInsets(Component component) {
        return new Insets(3, 3, 3, 3);
    }

    public Insets getBorderInsets(Component component, Insets insets) {
        insets.bottom = 3;
        insets.top = 3;
        insets.right = 3;
        insets.left = 3;
        return insets;
    }

    public boolean isBorderOpaque() {
        return false;
    }

    private static void paintSoftBevel(Graphics graphics, int n, int n2, int n3, int n4, Color color, Color color2, Color color3, Color color4) {
        Color color5 = graphics.getColor();
        graphics.translate(n, n2);
        --n3;
        --n4;
        try {
            graphics.setColor(color);
            graphics.drawLine(0, 0, n3 - 1, 0);
            graphics.drawLine(0, 1, 2, 1);
            graphics.drawLine(0, 2, 0, n4 - 1);
            graphics.setColor(color2);
            graphics.drawLine(n3, 0, n3, 0);
            graphics.drawLine(2, 1, n3 - 1, 1);
            graphics.drawLine(1, 2, 2, 2);
            graphics.drawLine(1, 3, 1, n4 - 1);
            graphics.drawLine(0, n4 - 1, 0, n4);
            graphics.setColor(color3);
            graphics.drawLine(n3 - 1, n4 - 1, n3 - 1, n4 - 1);
            graphics.setColor(color4);
            graphics.drawLine(2, n4, n3, n4);
            graphics.drawLine(n3, 2, n3, n4 - 1);
        }
        finally {
            Object var10_10 = null;
            graphics.translate(-n, -n2);
            graphics.setColor(color5);
        }
    }
}

