/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.jarsigner;

import gnu.classpath.Configuration;
import gnu.classpath.SystemProperties;
import gnu.classpath.tools.common.CallbackUtil;
import gnu.classpath.tools.common.ProviderUtil;
import gnu.classpath.tools.getopt.ClasspathToolParser;
import gnu.classpath.tools.getopt.FileArgumentCallback;
import gnu.classpath.tools.getopt.Option;
import gnu.classpath.tools.getopt.OptionException;
import gnu.classpath.tools.getopt.OptionGroup;
import gnu.classpath.tools.jarsigner.JarSigner;
import gnu.classpath.tools.jarsigner.JarVerifier;
import gnu.classpath.tools.jarsigner.Messages;
import gnu.java.security.OID;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.jar.Attributes;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class Main {
    protected static final Logger log = Logger.getLogger(Main.class$("gnu.classpath.tools.jarsigner.Main").getName());
    static final String KEYTOOL_TOOL = "jarsigner";
    private static final Locale EN_US_LOCALE;
    static final String DIGEST = "SHA1-Digest";
    static final String DIGEST_MANIFEST = "SHA1-Digest-Manifest";
    static final Attributes.Name DIGEST_ATTR;
    static final Attributes.Name DIGEST_MANIFEST_ATTR;
    static final OID DSA_SIGNATURE_OID;
    static final OID RSA_SIGNATURE_OID;
    protected boolean verify;
    protected String ksURL;
    protected String ksType;
    protected String password;
    protected String ksPassword;
    protected String sigFileName;
    protected String signedJarFileName;
    protected boolean verbose;
    protected boolean certs;
    protected boolean internalSF;
    protected boolean sectionsOnly;
    protected String providerClassName;
    protected String jarFileName;
    protected String alias;
    protected Provider provider;
    private boolean providerInstalled;
    private char[] ksPasswordChars;
    private KeyStore store;
    private char[] passwordChars;
    private PrivateKey signerPrivateKey;
    private Certificate[] signerCertificateChain;
    private CallbackHandler handler;
    private ToolParser cmdLineParser;
    protected ArrayList fileAndAlias;

    private /* synthetic */ void finit$() {
        this.fileAndAlias = new ArrayList();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private Main() {
        this.finit$();
    }

    public static final void main(String[] stringArray) {
        if (Configuration.DEBUG) {
            log.entering(Main.class$("gnu.classpath.tools.jarsigner.Main").getName(), "main", stringArray);
        }
        Main main = new Main();
        int n = 1;
        try {
            try {
                main.processArgs(stringArray);
                main.start();
                n = 0;
            }
            catch (SecurityException securityException) {
                if (Configuration.DEBUG) {
                    log.throwing(Main.class$("gnu.classpath.tools.jarsigner.Main").getName(), "main", securityException);
                }
                System.err.println(Messages.getString("Main.7") + securityException.getMessage());
            }
            catch (Exception exception) {
                if (Configuration.DEBUG) {
                    log.throwing(Main.class$("gnu.classpath.tools.jarsigner.Main").getName(), "main", exception);
                }
                System.err.println(Messages.getString("Main.9") + exception);
            }
            Object var3_5 = null;
            main.teardown();
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            main.teardown();
            throw throwable;
        }
        if (Configuration.DEBUG) {
            log.exiting(Main.class$("gnu.classpath.tools.jarsigner.Main").getName(), "main", n);
        }
        System.exit(n);
    }

    private void processArgs(String[] stringArray) throws Exception {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "processArgs", stringArray);
        }
        this.cmdLineParser = new ToolParser(this);
        this.cmdLineParser.initializeParser();
        this.cmdLineParser.parse(stringArray, new ToolParserCallback(this));
        this.setupCommonParams();
        if (this.verify) {
            if (Configuration.DEBUG) {
                log.fine("Will verify with the following parameters:");
                log.fine("     jar-file = '" + this.jarFileName + "'");
                log.fine("Options:");
                log.fine("     provider = '" + this.providerClassName + "'");
                log.fine("      verbose ? " + this.verbose);
                log.fine("        certs ? " + this.certs);
                log.fine("   internalsf ? " + this.internalSF);
                log.fine(" sectionsonly ? " + this.sectionsOnly);
            }
        } else {
            this.setupSigningParams();
            if (Configuration.DEBUG) {
                log.fine("Will sign with the following parameters:");
                log.fine("     jar-file = '" + this.jarFileName + "'");
                log.fine("        alias = '" + this.alias + "'");
                log.fine("Options:");
                log.fine("     keystore = '" + this.ksURL + "'");
                log.fine("    storetype = '" + this.ksType + "'");
                log.fine("    storepass = '" + this.ksPassword + "'");
                log.fine("      keypass = '" + this.password + "'");
                log.fine("      sigfile = '" + this.sigFileName + "'");
                log.fine("    signedjar = '" + this.signedJarFileName + "'");
                log.fine("     provider = '" + this.providerClassName + "'");
                log.fine("      verbose ? " + this.verbose);
                log.fine("   internalsf ? " + this.internalSF);
                log.fine(" sectionsonly ? " + this.sectionsOnly);
            }
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "processArgs");
        }
    }

    private void start() throws Exception {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "start");
        }
        if (this.verify) {
            JarVerifier jarVerifier = new JarVerifier(this);
            jarVerifier.start();
        } else {
            JarSigner jarSigner = new JarSigner(this);
            jarSigner.start();
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "start");
        }
    }

    private void teardown() {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "teardown");
        }
        if (this.providerInstalled) {
            ProviderUtil.removeProvider(this.provider.getName());
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "teardown");
        }
    }

    private void setupCommonParams() throws InstantiationException, IllegalAccessException, ClassNotFoundException, IOException {
        File file;
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "setupCommonParams");
        }
        if (!(file = new File(this.jarFileName)).exists()) {
            throw new FileNotFoundException(this.jarFileName);
        }
        if (file.isDirectory()) {
            throw new IOException(Messages.getFormattedString("Main.70", this.jarFileName));
        }
        if (!file.canRead()) {
            throw new IOException(Messages.getFormattedString("Main.72", this.jarFileName));
        }
        if (this.providerClassName != null && this.providerClassName.length() > 0) {
            this.provider = (Provider)Class.forName(this.providerClassName).newInstance();
            String string = this.provider.getName();
            Provider provider = Security.getProvider(string);
            if (provider != null) {
                if (Configuration.DEBUG) {
                    log.finer("Provider " + string + " is already installed");
                }
            } else {
                this.installNewProvider();
            }
        }
        if (!this.verbose && this.certs) {
            if (Configuration.DEBUG) {
                log.fine("Option <certs> is set but <verbose> is not. Ignored");
            }
            this.certs = false;
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "setupCommonParams");
        }
    }

    private void installNewProvider() {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "installNewProvider");
        }
        boolean bl = this.providerInstalled = ProviderUtil.addProvider(this.provider) != -1;
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "installNewProvider");
        }
    }

    private void setupSigningParams() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnsupportedCallbackException, UnrecoverableKeyException {
        Key key;
        Object object;
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "setupSigningParams");
        }
        if (this.ksURL == null || this.ksURL.trim().length() == 0) {
            object = SystemProperties.getProperty((String)"user.home");
            if (object == null || ((String)object).trim().length() == 0) {
                throw new SecurityException(Messages.getString("Main.85"));
            }
            this.ksURL = "file:" + ((String)object).trim() + "/.keystore";
        } else {
            this.ksURL = this.ksURL.trim();
            if (this.ksURL.indexOf(":") == -1) {
                this.ksURL = "file:" + this.ksURL;
            }
        }
        this.ksType = this.ksType == null || this.ksType.trim().length() == 0 ? KeyStore.getDefaultType() : this.ksType.trim();
        this.store = KeyStore.getInstance(this.ksType);
        if (this.ksPassword == null) {
            object = new PasswordCallback(Messages.getString("Main.92"), false);
            this.getCallbackHandler().handle(new Callback[]{object});
            this.ksPasswordChars = ((PasswordCallback)object).getPassword();
        } else {
            this.ksPasswordChars = this.ksPassword.toCharArray();
        }
        object = new URL(this.ksURL);
        InputStream inputStream = ((URL)object).openStream();
        this.store.load(inputStream, this.ksPasswordChars);
        if (!this.store.containsAlias(this.alias)) {
            throw new SecurityException(Messages.getFormattedString("Main.6", this.alias));
        }
        if (!this.store.isKeyEntry(this.alias)) {
            throw new SecurityException(Messages.getFormattedString("Main.95", this.alias));
        }
        if (this.password == null) {
            this.passwordChars = this.ksPasswordChars;
            try {
                key = this.store.getKey(this.alias, this.passwordChars);
            }
            catch (UnrecoverableKeyException unrecoverableKeyException) {
                String string = Messages.getFormattedString("Main.97", this.alias);
                PasswordCallback passwordCallback = new PasswordCallback(string, false);
                this.getCallbackHandler().handle(new Callback[]{passwordCallback});
                this.passwordChars = passwordCallback.getPassword();
                key = this.store.getKey(this.alias, this.passwordChars);
            }
        } else {
            this.passwordChars = this.password.toCharArray();
            key = this.store.getKey(this.alias, this.passwordChars);
        }
        if (!(key instanceof PrivateKey)) {
            throw new SecurityException(Messages.getFormattedString("Main.99", this.alias));
        }
        this.signerPrivateKey = (PrivateKey)key;
        this.signerCertificateChain = this.store.getCertificateChain(this.alias);
        if (Configuration.DEBUG) {
            log.fine(String.valueOf(this.signerCertificateChain));
        }
        if (this.sigFileName == null) {
            this.sigFileName = this.alias;
        }
        this.sigFileName = this.sigFileName.toUpperCase(EN_US_LOCALE);
        if (this.sigFileName.length() > 8) {
            this.sigFileName = this.sigFileName.substring(0, 8);
        }
        char[] cArray = this.sigFileName.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (Character.isLetter(c) || Character.isDigit(c) || c == '_' || c == '-') continue;
            cArray[i] = 95;
        }
        this.sigFileName = new String(cArray);
        if (this.signedJarFileName == null) {
            this.signedJarFileName = this.jarFileName;
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "setupSigningParams");
        }
    }

    boolean isVerbose() {
        return this.verbose;
    }

    boolean isCerts() {
        return this.certs;
    }

    String getSigFileName() {
        return this.sigFileName;
    }

    String getJarFileName() {
        return this.jarFileName;
    }

    boolean isSectionsOnly() {
        return this.sectionsOnly;
    }

    boolean isInternalSF() {
        return this.internalSF;
    }

    PrivateKey getSignerPrivateKey() {
        return this.signerPrivateKey;
    }

    Certificate[] getSignerCertificateChain() {
        return this.signerCertificateChain;
    }

    String getSignedJarFileName() {
        return this.signedJarFileName;
    }

    protected CallbackHandler getCallbackHandler() {
        if (this.handler == null) {
            this.handler = CallbackUtil.getConsoleHandler();
        }
        return this.handler;
    }

    static {
        KEYTOOL_TOOL = KEYTOOL_TOOL;
        EN_US_LOCALE = new Locale("en", "US");
        DIGEST = DIGEST;
        DIGEST_MANIFEST = DIGEST_MANIFEST;
        DIGEST_ATTR = new Attributes.Name(DIGEST);
        DIGEST_MANIFEST_ATTR = new Attributes.Name(DIGEST_MANIFEST);
        DSA_SIGNATURE_OID = new OID("1.2.840.10040.4.1");
        RSA_SIGNATURE_OID = new OID("1.2.840.113549.1.1.1");
    }

    private class ToolParser
    extends ClasspathToolParser {
        private /* synthetic */ Main this$0;

        static Main access$0(ToolParser toolParser) {
            return toolParser.this$0;
        }

        public ToolParser(Main main) {
            this.this$0 = main;
            super(Main.KEYTOOL_TOOL, true);
        }

        protected void validate() throws OptionException {
            if (this.this$0.fileAndAlias.size() < 1) {
                throw new OptionException(Messages.getString("Main.133"));
            }
            this.this$0.jarFileName = (String)this.this$0.fileAndAlias.get(0);
            if (!this.this$0.verify) {
                if (this.this$0.fileAndAlias.size() < 2) {
                    if (Configuration.DEBUG) {
                        log.fine("Missing ALIAS argument. Will use [mykey] instead");
                    }
                    this.this$0.alias = "mykey";
                } else {
                    this.this$0.alias = (String)this.this$0.fileAndAlias.get(1);
                }
            }
        }

        public void initializeParser() {
            this.setHeader(Messages.getString("Main.2"));
            this.setFooter(Messages.getString("Main.1"));
            OptionGroup optionGroup = new OptionGroup(Messages.getString("Main.0"));
            optionGroup.add(new Option(this, "keystore", Messages.getString("Main.101"), Messages.getString("Main.102")){
                private /* synthetic */ ToolParser this$1;
                {
                    this.this$1 = toolParser;
                    super(string, string2, string3);
                }

                public void parsed(String string) throws OptionException {
                    ToolParser.access$0((ToolParser)this.this$1).ksURL = string;
                }
            });
            optionGroup.add(new Option(this, "storetype", Messages.getString("Main.104"), Messages.getString("Main.105")){
                private /* synthetic */ ToolParser this$1;
                {
                    this.this$1 = toolParser;
                    super(string, string2, string3);
                }

                public void parsed(String string) throws OptionException {
                    ToolParser.access$0((ToolParser)this.this$1).ksType = string;
                }
            });
            optionGroup.add(new Option(this, "storepass", Messages.getString("Main.107"), Messages.getString("Main.108")){
                private /* synthetic */ ToolParser this$1;
                {
                    this.this$1 = toolParser;
                    super(string, string2, string3);
                }

                public void parsed(String string) throws OptionException {
                    ToolParser.access$0((ToolParser)this.this$1).ksPassword = string;
                }
            });
            optionGroup.add(new Option(this, "keypass", Messages.getString("Main.110"), Messages.getString("Main.111")){
                private /* synthetic */ ToolParser this$1;
                {
                    this.this$1 = toolParser;
                    super(string, string2, string3);
                }

                public void parsed(String string) throws OptionException {
                    ToolParser.access$0((ToolParser)this.this$1).password = string;
                }
            });
            optionGroup.add(new Option(this, "sigfile", Messages.getString("Main.113"), Messages.getString("Main.114")){
                private /* synthetic */ ToolParser this$1;
                {
                    this.this$1 = toolParser;
                    super(string, string2, string3);
                }

                public void parsed(String string) throws OptionException {
                    ToolParser.access$0((ToolParser)this.this$1).sigFileName = string;
                }
            });
            optionGroup.add(new Option(this, "signedjar", Messages.getString("Main.116"), Messages.getString("Main.117")){
                private /* synthetic */ ToolParser this$1;
                {
                    this.this$1 = toolParser;
                    super(string, string2, string3);
                }

                public void parsed(String string) throws OptionException {
                    ToolParser.access$0((ToolParser)this.this$1).signedJarFileName = string;
                }
            });
            this.add(optionGroup);
            OptionGroup optionGroup2 = new OptionGroup(Messages.getString("Main.118"));
            optionGroup2.add(new Option(this, "verify", Messages.getString("Main.120")){
                private /* synthetic */ ToolParser this$1;
                {
                    this.this$1 = toolParser;
                    super(string, string2);
                }

                public void parsed(String string) throws OptionException {
                    ToolParser.access$0((ToolParser)this.this$1).verify = true;
                }
            });
            optionGroup2.add(new Option(this, "certs", Messages.getString("Main.122")){
                private /* synthetic */ ToolParser this$1;
                {
                    this.this$1 = toolParser;
                    super(string, string2);
                }

                public void parsed(String string) throws OptionException {
                    ToolParser.access$0((ToolParser)this.this$1).certs = true;
                }
            });
            this.add(optionGroup2);
            OptionGroup optionGroup3 = new OptionGroup(Messages.getString("Main.123"));
            optionGroup3.add(new Option(this, "verbose", Messages.getString("Main.125")){
                private /* synthetic */ ToolParser this$1;
                {
                    this.this$1 = toolParser;
                    super(string, string2);
                }

                public void parsed(String string) throws OptionException {
                    ToolParser.access$0((ToolParser)this.this$1).verbose = true;
                }
            });
            optionGroup3.add(new Option(this, "internalsf", Messages.getString("Main.127")){
                private /* synthetic */ ToolParser this$1;
                {
                    this.this$1 = toolParser;
                    super(string, string2);
                }

                public void parsed(String string) throws OptionException {
                    ToolParser.access$0((ToolParser)this.this$1).internalSF = true;
                }
            });
            optionGroup3.add(new Option(this, "sectionsonly", Messages.getString("Main.129")){
                private /* synthetic */ ToolParser this$1;
                {
                    this.this$1 = toolParser;
                    super(string, string2);
                }

                public void parsed(String string) throws OptionException {
                    ToolParser.access$0((ToolParser)this.this$1).sectionsOnly = true;
                }
            });
            optionGroup3.add(new Option(this, "provider", Messages.getString("Main.131"), Messages.getString("Main.132")){
                private /* synthetic */ ToolParser this$1;
                {
                    this.this$1 = toolParser;
                    super(string, string2, string3);
                }

                public void parsed(String string) throws OptionException {
                    ToolParser.access$0((ToolParser)this.this$1).providerClassName = string;
                }
            });
            this.add(optionGroup3);
        }
    }

    private class ToolParserCallback
    extends FileArgumentCallback {
        private /* synthetic */ Main this$0;

        public void notifyFile(String string) {
            this.this$0.fileAndAlias.add(string);
        }

        ToolParserCallback(Main main) {
            this.this$0 = main;
        }
    }
}

