/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.keytool;

import gnu.classpath.Configuration;
import gnu.classpath.SystemProperties;
import gnu.classpath.tools.common.CallbackUtil;
import gnu.classpath.tools.common.ProviderUtil;
import gnu.classpath.tools.common.SecurityProviderInfo;
import gnu.classpath.tools.getopt.Parser;
import gnu.classpath.tools.keytool.Messages;
import gnu.java.security.OID;
import gnu.java.security.der.BitString;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.der.DERWriter;
import gnu.java.security.hash.IMessageDigest;
import gnu.java.security.hash.MD5;
import gnu.java.security.hash.Sha160;
import gnu.java.security.util.Util;
import gnu.java.security.x509.X500DistinguishedName;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLConnection;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAKey;
import java.security.interfaces.RSAKey;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

abstract class Command {
    private static final Logger log = Logger.getLogger(Command.class$("gnu.classpath.tools.keytool.Command").getName());
    private static final String DEFAULT_ALIAS = "mykey";
    private static final String DEFAULT_KEY_ALGORITHM = "DSA";
    private static final String DSA_SIGNATURE_ALGORITHM = "SHA1withDSA";
    private static final String RSA_SIGNATURE_ALGORITHM = "MD5withRSA";
    private static final int DEFAULT_VALIDITY = 90;
    protected static final OID SHA1_WITH_DSA;
    private static final OID MD2_WITH_RSA;
    private static final OID MD5_WITH_RSA;
    private static final OID SHA1_WITH_RSA;
    private static final long MILLIS_IN_A_DAY = 86400000L;
    protected String alias;
    protected char[] keyPasswordChars;
    protected Provider provider;
    protected String storeType;
    protected char[] storePasswordChars;
    protected URL storeURL;
    protected InputStream storeStream;
    protected KeyStore store;
    protected OutputStream outStream;
    protected boolean systemOut;
    protected KeyPairGenerator keyPairGenerator;
    protected Signature signatureAlgorithm;
    protected int validityInDays;
    protected InputStream inStream;
    protected boolean verbose;
    private IMessageDigest md5;
    private IMessageDigest sha;
    private int providerNdx;
    private CallbackHandler handler;
    private ShutdownHook shutdownThread;

    private /* synthetic */ void finit$() {
        this.md5 = new MD5();
        this.sha = new Sha160();
        this.providerNdx = -2;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected Command() {
        this.finit$();
        this.shutdownThread = new ShutdownHook(this);
        Runtime.getRuntime().addShutdownHook(this.shutdownThread);
    }

    public void doCommand() throws Exception {
        try {
            this.setup();
            this.start();
        }
        finally {
            Object var1_1 = null;
            this.teardown();
            if (this.shutdownThread != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
            }
        }
    }

    public void setVerbose(String string) {
        this.verbose = Boolean.valueOf(string);
    }

    String[] processArgs(String[] stringArray) {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "processArgs", stringArray);
        }
        Parser parser = this.getParser();
        String[] stringArray2 = parser.parse(stringArray);
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "processArgs", stringArray2);
        }
        return stringArray2;
    }

    abstract void setup() throws Exception;

    void start() throws Exception {
        throw new RuntimeException("Not implemented yet");
    }

    void teardown() {
        block15: {
            if (Configuration.DEBUG) {
                log.entering(this.getClass().getName(), "teardown");
            }
            if (this.storeStream != null) {
                try {
                    this.storeStream.close();
                }
                catch (IOException iOException) {
                    if (!Configuration.DEBUG) break block15;
                    log.fine("Exception while closing key store URL stream. Ignored: " + iOException);
                }
            }
        }
        if (this.outStream != null) {
            try {
                this.outStream.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!this.systemOut) {
                try {
                    this.outStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (this.inStream != null) {
            try {
                this.inStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.providerNdx > 0) {
            ProviderUtil.removeProvider(this.provider.getName());
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "teardown");
        }
    }

    abstract Parser getParser();

    protected void setKeyStoreParams(String string, String string2, String string3, String string4) throws IOException, UnsupportedCallbackException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        this.setKeyStoreParams(false, string, string2, string3, string4);
    }

    protected void setKeyStoreParams(boolean bl, String string, String string2, String string3, String string4) throws IOException, UnsupportedCallbackException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        this.setProviderClassNameParam(string);
        this.setKeystoreTypeParam(string2);
        this.setKeystoreURLParam(bl, string4, string3);
    }

    private void setProviderClassNameParam(String string) {
        if (Configuration.DEBUG) {
            log.fine("setProviderClassNameParam(" + string + ")");
        }
        if (string != null && string.trim().length() > 0) {
            string = string.trim();
            SecurityProviderInfo securityProviderInfo = ProviderUtil.addProvider(string);
            this.provider = securityProviderInfo.getProvider();
            if (this.provider == null && Configuration.DEBUG) {
                log.fine("Was unable to add provider from class " + string);
            }
            this.providerNdx = securityProviderInfo.getPosition();
        }
    }

    private void setKeystoreTypeParam(String string) {
        if (Configuration.DEBUG) {
            log.fine("setKeystoreTypeParam(" + string + ")");
        }
        this.storeType = string == null || string.trim().length() == 0 ? KeyStore.getDefaultType() : string.trim();
    }

    protected void setKeyPasswordParam(String string) throws IOException, UnsupportedCallbackException {
        this.setKeyPasswordNoPrompt(string);
        if (this.keyPasswordChars == null) {
            this.setKeyPasswordParam();
        }
    }

    protected void setAliasParam(String string) {
        this.alias = string == null ? DEFAULT_ALIAS : string.trim();
    }

    protected void setKeyPasswordNoPrompt(String string) {
        if (string != null) {
            this.keyPasswordChars = string.toCharArray();
        }
    }

    private void setKeyPasswordParam() throws IOException, UnsupportedCallbackException {
        String string = Messages.getFormattedString("Command.21", this.alias);
        PasswordCallback passwordCallback = new PasswordCallback(string, false);
        this.getCallbackHandler().handle(new Callback[]{passwordCallback});
        this.keyPasswordChars = passwordCallback.getPassword();
        passwordCallback.clearPassword();
        if (this.keyPasswordChars == null) {
            throw new SecurityException(Messages.getString("Command.23"));
        }
    }

    private void setKeystorePasswordParam(String string) throws IOException, UnsupportedCallbackException {
        if (string != null) {
            this.storePasswordChars = string.toCharArray();
        } else {
            String string2 = Messages.getString("Command.24");
            PasswordCallback passwordCallback = new PasswordCallback(string2, false);
            this.getCallbackHandler().handle(new Callback[]{passwordCallback});
            this.storePasswordChars = passwordCallback.getPassword();
            passwordCallback.clearPassword();
        }
    }

    private void setKeystoreURLParam(boolean bl, String string, String string2) throws IOException, KeyStoreException, UnsupportedCallbackException, NoSuchAlgorithmException, CertificateException {
        block17: {
            if (Configuration.DEBUG) {
                log.fine("setKeystoreURLParam(" + string + ")");
            }
            if (string == null || string.trim().length() == 0) {
                String string3 = SystemProperties.getProperty((String)"user.home");
                if (string3 == null || string3.trim().length() == 0) {
                    throw new InvalidParameterException(Messages.getString("Command.36"));
                }
                string = string3.trim() + "/.keystore";
                if (bl) {
                    new File(string).createNewFile();
                }
                string = "file:" + string;
            } else {
                if ((string = string.trim()).indexOf(":") == -1 && bl) {
                    new File(string).createNewFile();
                }
                string = "file:" + string;
            }
            boolean bl2 = false;
            this.storeURL = new URL(string);
            this.storeStream = this.storeURL.openStream();
            if (this.storeStream.available() == 0) {
                if (Configuration.DEBUG) {
                    log.fine("Store is empty. Will use <null> when loading, to create it");
                }
                bl2 = true;
            }
            try {
                this.store = KeyStore.getInstance(this.storeType);
            }
            catch (KeyStoreException keyStoreException) {
                if (this.provider != null) {
                    throw keyStoreException;
                }
                if (Configuration.DEBUG) {
                    log.fine("Exception while getting key store with default provider(s). Will prompt user for another provider and continue");
                }
                String string4 = Messages.getString("Command.40");
                NameCallback nameCallback = new NameCallback(string4);
                this.getCallbackHandler().handle(new Callback[]{nameCallback});
                String string5 = nameCallback.getName();
                this.setProviderClassNameParam(string5);
                if (this.provider == null) {
                    keyStoreException.fillInStackTrace();
                    throw keyStoreException;
                }
                this.store = KeyStore.getInstance(this.storeType, this.provider);
            }
            this.setKeystorePasswordParam(string2);
            if (bl2) {
                this.store.load(null, this.storePasswordChars);
            } else {
                this.store.load(this.storeStream, this.storePasswordChars);
            }
            try {
                this.storeStream.close();
                this.storeStream = null;
            }
            catch (IOException iOException) {
                if (!Configuration.DEBUG) break block17;
                log.fine("Exception while closing the key store input stream: " + iOException + ". Ignore");
            }
        }
    }

    protected void setOutputStreamParam(String string) throws SecurityException, IOException {
        if (string == null || string.trim().length() == 0) {
            this.outStream = System.out;
            this.systemOut = true;
        } else {
            File file = new File(string = string.trim());
            if (!file.exists()) {
                boolean bl = file.createNewFile();
                if (!bl) {
                    throw new InvalidParameterException(Messages.getFormattedString("Command.19", string));
                }
            } else {
                if (!file.isFile()) {
                    throw new InvalidParameterException(Messages.getFormattedString("Command.42", string));
                }
                if (!file.canWrite()) {
                    throw new InvalidParameterException(Messages.getFormattedString("Command.44", string));
                }
            }
            this.outStream = new FileOutputStream(file);
        }
    }

    protected void setInputStreamParam(String string) throws FileNotFoundException {
        if (string == null || string.trim().length() == 0) {
            this.inStream = System.in;
        } else {
            File file = new File(string = string.trim());
            if (!(file.exists() && file.isFile() && file.canRead())) {
                throw new InvalidParameterException(Messages.getFormattedString("Command.46", string));
            }
            this.inStream = new FileInputStream(file);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setAlgorithmParams(String string, String string2) throws NoSuchAlgorithmException {
        string = string == null || string.trim().length() == 0 ? DEFAULT_KEY_ALGORITHM : string.trim().toLowerCase();
        this.keyPairGenerator = KeyPairGenerator.getInstance(string);
        if (string2 == null || string2.trim().length() == 0) {
            if (string.equalsIgnoreCase("dss") || string.equalsIgnoreCase("dsa")) {
                string2 = DSA_SIGNATURE_ALGORITHM;
            } else {
                if (!string.equalsIgnoreCase("rsa")) throw new IllegalArgumentException(Messages.getFormattedString("Command.20", new String[]{string2, string}));
                string2 = RSA_SIGNATURE_ALGORITHM;
            }
        } else {
            string2 = string2.trim().toLowerCase();
        }
        this.signatureAlgorithm = Signature.getInstance(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setSignatureAlgorithmParam(String string, Key key) throws NoSuchAlgorithmException {
        if (string == null || string.trim().length() == 0) {
            if (key instanceof DSAKey) {
                string = DSA_SIGNATURE_ALGORITHM;
            } else {
                if (!(key instanceof RSAKey)) throw new InvalidParameterException(Messages.getString("Command.48"));
                string = RSA_SIGNATURE_ALGORITHM;
            }
        } else {
            string = string.trim();
        }
        this.signatureAlgorithm = Signature.getInstance(string);
    }

    protected void setValidityParam(String string) {
        if (string == null || string.trim().length() == 0) {
            this.validityInDays = 90;
        } else {
            string = string.trim();
            this.validityInDays = Integer.parseInt(string);
            if (this.validityInDays < 1) {
                throw new InvalidParameterException(Messages.getString("Command.51"));
            }
        }
    }

    protected byte[] getSelfSignedCertificate(X500DistinguishedName x500DistinguishedName, PublicKey publicKey, PrivateKey privateKey) throws IOException, SignatureException, InvalidKeyException {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "getSelfSignedCertificate", new Object[]{x500DistinguishedName, publicKey, privateKey});
        }
        byte[] byArray = new DERValue(2, (Object)BigInteger.ZERO).getEncoded();
        DERValue dERValue = new DERValue(160, byArray.length, (Object)byArray, null);
        Preferences preferences = Preferences.systemNodeForPackage(this.getClass());
        int n = preferences.getInt("lastSerialNumber", 0) + 1;
        preferences.putInt("lastSerialNumber", n);
        DERValue dERValue2 = new DERValue(2, (Object)BigInteger.valueOf(n));
        OID oID = this.getSignatureAlgorithmOID();
        DERValue dERValue3 = new DERValue(6, (Object)oID);
        ArrayList<DERValue> arrayList = new ArrayList<DERValue>(1);
        arrayList.add(dERValue3);
        if (!oID.equals((Object)SHA1_WITH_DSA)) {
            arrayList.add(new DERValue(5, null));
        }
        DERValue dERValue4 = new DERValue(48, arrayList);
        DERValue dERValue5 = new DERReader(x500DistinguishedName.getDer()).read();
        long l = System.currentTimeMillis();
        long l2 = l + (long)this.validityInDays * 86400000L;
        ArrayList<DERValue> arrayList2 = new ArrayList<DERValue>(2);
        arrayList2.add(new DERValue(23, (Object)new Date(l)));
        arrayList2.add(new DERValue(23, (Object)new Date(l2)));
        DERValue dERValue6 = new DERValue(48, arrayList2);
        DERValue dERValue7 = dERValue5;
        DERValue dERValue8 = new DERReader(publicKey.getEncoded()).read();
        ArrayList<DERValue> arrayList3 = new ArrayList<DERValue>(7);
        arrayList3.add(dERValue);
        arrayList3.add(dERValue2);
        arrayList3.add(dERValue4);
        arrayList3.add(dERValue5);
        arrayList3.add(dERValue6);
        arrayList3.add(dERValue7);
        arrayList3.add(dERValue8);
        DERValue dERValue9 = new DERValue(48, arrayList3);
        DERValue dERValue10 = dERValue4;
        this.signatureAlgorithm.initSign(privateKey);
        this.signatureAlgorithm.update(dERValue9.getEncoded());
        byte[] byArray2 = this.signatureAlgorithm.sign();
        DERValue dERValue11 = new DERValue(3, (Object)new BitString(byArray2));
        ArrayList<DERValue> arrayList4 = new ArrayList<DERValue>(3);
        arrayList4.add(dERValue9);
        arrayList4.add(dERValue10);
        arrayList4.add(dERValue11);
        DERValue dERValue12 = new DERValue(48, arrayList4);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DERWriter.write((OutputStream)byteArrayOutputStream, (DERValue)dERValue12);
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "getSelfSignedCertificate");
        }
        return byArray3;
    }

    protected OID getSignatureAlgorithmOID() {
        String string = this.signatureAlgorithm.getAlgorithm();
        if (string == null || string.trim().length() == 0) {
            throw new InvalidParameterException(Messages.getString("Command.52"));
        }
        if ((string = string.trim()).equalsIgnoreCase("dss") || string.equalsIgnoreCase(DSA_SIGNATURE_ALGORITHM)) {
            return SHA1_WITH_DSA;
        }
        if (string.equalsIgnoreCase("rsa-pkcs1-v1.5-md2") || string.equalsIgnoreCase("MD2withRSA")) {
            return MD2_WITH_RSA;
        }
        if (string.equalsIgnoreCase("rsa-pkcs1-v1.5-md5") || string.equalsIgnoreCase(RSA_SIGNATURE_ALGORITHM) || string.equalsIgnoreCase("rsa")) {
            return MD5_WITH_RSA;
        }
        if (string.equalsIgnoreCase("rsa-pkcs1-v1.5-sha-160") || string.equalsIgnoreCase("SHA1withRSA")) {
            return SHA1_WITH_RSA;
        }
        throw new InvalidParameterException(Messages.getFormattedString("Command.60", string));
    }

    protected void saveKeyStore(char[] cArray) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "saveKeyStore");
        }
        URLConnection uRLConnection = this.storeURL.openConnection();
        uRLConnection.setDoOutput(true);
        uRLConnection.setUseCaches(false);
        OutputStream outputStream = uRLConnection.getOutputStream();
        if (this.verbose) {
            System.out.println(Messages.getFormattedString("Command.63", this.storeURL.getPath()));
        }
        this.store.store(outputStream, cArray);
        outputStream.flush();
        outputStream.close();
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "saveKeyStore");
        }
    }

    protected void saveKeyStore() throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        this.saveKeyStore(this.storePasswordChars);
    }

    protected void printVerbose(Certificate certificate, PrintWriter printWriter) throws CertificateEncodingException {
        X509Certificate x509Certificate = (X509Certificate)certificate;
        printWriter.println(Messages.getFormattedString("Command.66", x509Certificate.getSubjectDN()));
        printWriter.println(Messages.getFormattedString("Command.67", x509Certificate.getIssuerDN()));
        printWriter.println(Messages.getFormattedString("Command.68", x509Certificate.getSerialNumber()));
        printWriter.println(Messages.getFormattedString("Command.69", x509Certificate.getNotBefore()));
        printWriter.println(Messages.getFormattedString("Command.70", x509Certificate.getNotAfter()));
        printWriter.println(Messages.getString("Command.71"));
        byte[] byArray = certificate.getEncoded();
        printWriter.println(Messages.getFormattedString("Command.72", this.digest(this.md5, byArray)));
        printWriter.println(Messages.getFormattedString("Command.73", this.digest(this.sha, byArray)));
    }

    protected void printVerbose(Certificate certificate) throws CertificateEncodingException {
        this.printVerbose(certificate, new PrintWriter(System.out, true));
    }

    protected String digestWithMD5(byte[] byArray) {
        return this.digest(this.md5, byArray);
    }

    private String digest(IMessageDigest iMessageDigest, byte[] byArray) {
        iMessageDigest.update(byArray);
        byte[] byArray2 = iMessageDigest.digest();
        StringBuilder stringBuilder = new StringBuilder().append(Util.toString((byte[])byArray2, (int)0, (int)1));
        for (int i = 1; i < byArray2.length; ++i) {
            stringBuilder.append(":").append(Util.toString((byte[])byArray2, (int)i, (int)1));
        }
        String string = stringBuilder.toString();
        return string;
    }

    protected void ensureStoreContainsAlias() throws KeyStoreException {
        if (!this.store.containsAlias(this.alias)) {
            throw new IllegalArgumentException(Messages.getFormattedString("Command.75", this.alias));
        }
    }

    protected void ensureAliasIsKeyEntry() throws KeyStoreException {
        if (!this.store.isKeyEntry(this.alias)) {
            throw new SecurityException(Messages.getFormattedString("Command.77", this.alias));
        }
    }

    protected Key getAliasPrivateKey() throws KeyStoreException, NoSuchAlgorithmException, IOException, UnsupportedCallbackException, UnrecoverableKeyException {
        Key key;
        this.ensureAliasIsKeyEntry();
        if (this.keyPasswordChars == null) {
            try {
                key = this.store.getKey(this.alias, this.storePasswordChars);
                this.keyPasswordChars = this.storePasswordChars;
            }
            catch (UnrecoverableKeyException unrecoverableKeyException) {
                this.setKeyPasswordParam();
                key = this.store.getKey(this.alias, this.keyPasswordChars);
            }
        } else {
            key = this.store.getKey(this.alias, this.keyPasswordChars);
        }
        return key;
    }

    protected CallbackHandler getCallbackHandler() {
        if (this.handler == null) {
            this.handler = CallbackUtil.getConsoleHandler();
        }
        return this.handler;
    }

    static {
        DEFAULT_ALIAS = DEFAULT_ALIAS;
        DEFAULT_KEY_ALGORITHM = DEFAULT_KEY_ALGORITHM;
        DSA_SIGNATURE_ALGORITHM = DSA_SIGNATURE_ALGORITHM;
        RSA_SIGNATURE_ALGORITHM = RSA_SIGNATURE_ALGORITHM;
        SHA1_WITH_DSA = new OID("1.2.840.10040.4.3");
        MD2_WITH_RSA = new OID("1.2.840.113549.1.1.2");
        MD5_WITH_RSA = new OID("1.2.840.113549.1.1.4");
        SHA1_WITH_RSA = new OID("1.2.840.113549.1.1.5");
    }

    private class ShutdownHook
    extends Thread {
        private /* synthetic */ Command this$0;

        public void run() {
            this.this$0.teardown();
        }

        ShutdownHook(Command command) {
            this.this$0 = command;
        }
    }
}

