/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.keytool;

import gnu.classpath.Configuration;
import gnu.classpath.SystemProperties;
import gnu.classpath.tools.getopt.ClasspathToolParser;
import gnu.classpath.tools.getopt.Option;
import gnu.classpath.tools.getopt.OptionException;
import gnu.classpath.tools.getopt.OptionGroup;
import gnu.classpath.tools.getopt.Parser;
import gnu.classpath.tools.keytool.Command;
import gnu.classpath.tools.keytool.Messages;
import gnu.java.security.x509.X509CertPath;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

class ImportCmd
extends Command {
    private static final Logger log = Logger.getLogger(ImportCmd.class$("gnu.classpath.tools.keytool.ImportCmd").getName());
    private static final String GKR = "gkr";
    private static final String JKS = "jks";
    private static final String LIB = "lib";
    private static final String SECURITY = "security";
    private static final String CACERTS = "cacerts";
    private static final String CACERTS_GKR = "cacerts.gkr";
    protected String _alias;
    protected String _certFileName;
    protected String _password;
    protected boolean noPrompt;
    protected boolean trustCACerts;
    protected String _ksType;
    protected String _ksURL;
    protected String _ksPassword;
    protected String _providerClassName;
    private CertificateFactory x509Factory;
    private boolean imported;
    private String gkrCaCertsPathName;
    private String jksCaCertsPathName;
    private X509Certificate selfSignedCertificate;

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void setAlias(String string) {
        this._alias = string;
    }

    public void setFile(String string) {
        this._certFileName = string;
    }

    public void setKeypass(String string) {
        this._password = string;
    }

    public void setNoprompt(String string) {
        this.noPrompt = Boolean.valueOf(string);
    }

    public void setTrustcacerts(String string) {
        this.trustCACerts = Boolean.valueOf(string);
    }

    public void setStoretype(String string) {
        this._ksType = string;
    }

    public void setKeystore(String string) {
        this._ksURL = string;
    }

    public void setStorepass(String string) {
        this._ksPassword = string;
    }

    public void setProvider(String string) {
        this._providerClassName = string;
    }

    void setup() throws Exception {
        this.setInputStreamParam(this._certFileName);
        this.setKeyStoreParams(true, this._providerClassName, this._ksType, this._ksPassword, this._ksURL);
        this.setAliasParam(this._alias);
        this.setKeyPasswordNoPrompt(this._password);
        if (Configuration.DEBUG) {
            log.fine("-import handler will use the following options:");
            log.fine("  -alias=" + this.alias);
            log.fine("  -file=" + this._certFileName);
            log.fine("  -noprompt=" + this.noPrompt);
            log.fine("  -trustcacerts=" + this.trustCACerts);
            log.fine("  -storetype=" + this.storeType);
            log.fine("  -keystore=" + this.storeURL);
            log.fine("  -provider=" + this.provider);
            log.fine("  -v=" + this.verbose);
        }
    }

    void start() throws CertificateException, KeyStoreException, IOException, UnsupportedCallbackException, NoSuchAlgorithmException, CertPathValidatorException, UnrecoverableKeyException {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "start");
        }
        if (this.trustCACerts) {
            String string = SystemProperties.getProperty((String)"file.separator");
            String string2 = SystemProperties.getProperty((String)"gnu.classpath.home");
            this.gkrCaCertsPathName = new StringBuilder(string2).append(string).append(LIB).append(string).append(SECURITY).append(string).append(CACERTS_GKR).toString();
            String string3 = SystemProperties.getProperty((String)"java.home");
            this.jksCaCertsPathName = new StringBuilder(string3).append(string).append(LIB).append(string).append(SECURITY).append(string).append(CACERTS).toString();
        }
        this.x509Factory = CertificateFactory.getInstance("X.509");
        if (!this.store.containsAlias(this.alias)) {
            this.importNewTrustedCertificate();
        } else {
            this.ensureAliasIsKeyEntry();
            this.importCertificateReply();
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "start");
        }
    }

    Parser getParser() {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "getParser");
        }
        ClasspathToolParser classpathToolParser = new ClasspathToolParser("import", true);
        classpathToolParser.setHeader(Messages.getString("ImportCmd.27"));
        classpathToolParser.setFooter(Messages.getString("ImportCmd.26"));
        OptionGroup optionGroup = new OptionGroup(Messages.getString("ImportCmd.25"));
        optionGroup.add(new Option(this, "alias", Messages.getString("ImportCmd.24"), Messages.getString("ImportCmd.23")){
            private /* synthetic */ ImportCmd this$0;
            {
                this.this$0 = importCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._alias = string;
            }
        });
        optionGroup.add(new Option(this, "file", Messages.getString("ImportCmd.22"), Messages.getString("ImportCmd.21")){
            private /* synthetic */ ImportCmd this$0;
            {
                this.this$0 = importCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._certFileName = string;
            }
        });
        optionGroup.add(new Option(this, "keypass", Messages.getString("ImportCmd.20"), Messages.getString("ImportCmd.19")){
            private /* synthetic */ ImportCmd this$0;
            {
                this.this$0 = importCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._password = string;
            }
        });
        optionGroup.add(new Option(this, "noprompt", Messages.getString("ImportCmd.18")){
            private /* synthetic */ ImportCmd this$0;
            {
                this.this$0 = importCmd;
                super(string, string2);
            }

            public void parsed(String string) throws OptionException {
                this.this$0.noPrompt = true;
            }
        });
        optionGroup.add(new Option(this, "trustcacerts", Messages.getString("ImportCmd.17")){
            private /* synthetic */ ImportCmd this$0;
            {
                this.this$0 = importCmd;
                super(string, string2);
            }

            public void parsed(String string) throws OptionException {
                this.this$0.trustCACerts = true;
            }
        });
        optionGroup.add(new Option(this, "storetype", Messages.getString("ImportCmd.16"), Messages.getString("ImportCmd.15")){
            private /* synthetic */ ImportCmd this$0;
            {
                this.this$0 = importCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._ksType = string;
            }
        });
        optionGroup.add(new Option(this, "keystore", Messages.getString("ImportCmd.14"), Messages.getString("ImportCmd.13")){
            private /* synthetic */ ImportCmd this$0;
            {
                this.this$0 = importCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._ksURL = string;
            }
        });
        optionGroup.add(new Option(this, "storepass", Messages.getString("ImportCmd.12"), Messages.getString("ImportCmd.11")){
            private /* synthetic */ ImportCmd this$0;
            {
                this.this$0 = importCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._ksPassword = string;
            }
        });
        optionGroup.add(new Option(this, "provider", Messages.getString("ImportCmd.10"), Messages.getString("ImportCmd.9")){
            private /* synthetic */ ImportCmd this$0;
            {
                this.this$0 = importCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._providerClassName = string;
            }
        });
        optionGroup.add(new Option(this, "v", Messages.getString("ImportCmd.8")){
            private /* synthetic */ ImportCmd this$0;
            {
                this.this$0 = importCmd;
                super(string, string2);
            }

            public void parsed(String string) throws OptionException {
                this.this$0.verbose = true;
            }
        });
        classpathToolParser.add(optionGroup);
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "getParser", classpathToolParser);
        }
        return classpathToolParser;
    }

    private void importNewTrustedCertificate() throws CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException, UnsupportedCallbackException, CertPathValidatorException, UnrecoverableKeyException {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "importNewTrustedCertificate");
        }
        Certificate certificate = this.x509Factory.generateCertificate(this.inStream);
        if (Configuration.DEBUG) {
            log.fine("certificate = " + certificate);
        }
        LinkedList<Certificate> linkedList = new LinkedList<Certificate>();
        linkedList.addLast(certificate);
        if (this.findTrustAndUpdate(linkedList, this.noPrompt ^ true)) {
            this.store.setCertificateEntry(this.alias, certificate);
            System.out.println(Messages.getString("ImportCmd.29"));
            this.saveKeyStore();
        } else {
            System.out.println(Messages.getString("ImportCmd.28"));
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "importNewTrustedCertificate");
        }
    }

    private void importCertificateReply() throws CertificateException, IOException, UnsupportedCallbackException, KeyStoreException, NoSuchAlgorithmException, CertPathValidatorException, UnrecoverableKeyException {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "importCertificateReply");
        }
        Collection<? extends Certificate> collection = this.x509Factory.generateCertificates(this.inStream);
        this.ensureReplyIsOurs(collection);
        if (collection.size() == 1) {
            this.importCertificate(collection.iterator().next());
        } else {
            this.importChain(collection);
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "importCertificateReply");
        }
    }

    private void importCertificate(Certificate certificate) throws NoSuchAlgorithmException, CertPathValidatorException, KeyStoreException, UnrecoverableKeyException, IOException, UnsupportedCallbackException, CertificateException {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "importCertificate", certificate);
        }
        LinkedList<Certificate> linkedList = new LinkedList<Certificate>();
        linkedList.addLast(certificate);
        if (!this.findTrustAndUpdate(linkedList, false)) {
            throw new CertPathValidatorException(Messages.getString("ImportCmd.34"));
        }
        Certificate[] certificateArray = linkedList.toArray(new Certificate[0]);
        Key key = this.getAliasPrivateKey();
        this.store.setKeyEntry(this.alias, key, this.keyPasswordChars, certificateArray);
        this.saveKeyStore();
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "importCertificate");
        }
    }

    private void importChain(Collection collection) throws NoSuchAlgorithmException, CertPathValidatorException, KeyStoreException, UnrecoverableKeyException, IOException, UnsupportedCallbackException, CertificateException {
        LinkedList linkedList;
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "importChain", collection);
        }
        if (this.findTrustAndUpdate(linkedList = this.orderChain(collection), this.noPrompt ^ true)) {
            Certificate[] certificateArray = linkedList.toArray(new Certificate[0]);
            Key key = this.getAliasPrivateKey();
            this.store.setKeyEntry(this.alias, key, this.keyPasswordChars, certificateArray);
            this.saveKeyStore();
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "importChain");
        }
    }

    private void ensureReplyIsOurs(Collection collection) throws IOException, UnsupportedCallbackException, KeyStoreException {
        boolean bl;
        Certificate[] certificateArray;
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "ensureReplyIsOurs");
        }
        Certificate certificate = (Certificate)collection.iterator().next();
        if (Configuration.DEBUG) {
            log.fine("certificate = " + certificate);
        }
        if ((certificateArray = this.store.getCertificateChain(this.alias)) == null) {
            throw new IllegalArgumentException(Messages.getFormattedString("ImportCmd.37", this.alias));
        }
        this.selfSignedCertificate = (X509Certificate)certificateArray[0];
        PublicKey publicKey = this.selfSignedCertificate.getPublicKey();
        PublicKey publicKey2 = certificate.getPublicKey();
        if (publicKey instanceof DSAPublicKey) {
            DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
            if (!(publicKey2 instanceof DSAPublicKey)) {
                throw new IllegalArgumentException(Messages.getString("ImportCmd.38"));
            }
            bl = this.areEqual(dSAPublicKey, (DSAPublicKey)publicKey2);
        } else if (publicKey instanceof RSAPublicKey) {
            RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
            if (!(publicKey2 instanceof RSAPublicKey)) {
                throw new IllegalArgumentException(Messages.getString("ImportCmd.38"));
            }
            bl = this.areEqual(rSAPublicKey, (RSAPublicKey)publicKey2);
        } else {
            throw new IllegalArgumentException(Messages.getFormattedString("ImportCmd.40", new String[]{this.alias, publicKey.getClass().getName()}));
        }
        if (!bl) {
            throw new IllegalArgumentException(Messages.getString("ImportCmd.41"));
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "ensureReplyIsOurs");
        }
    }

    private boolean areEqual(DSAPublicKey dSAPublicKey, DSAPublicKey dSAPublicKey2) {
        if (dSAPublicKey.getY().compareTo(dSAPublicKey2.getY()) != 0) {
            return false;
        }
        DSAParams dSAParams = dSAPublicKey.getParams();
        DSAParams dSAParams2 = dSAPublicKey2.getParams();
        if (dSAParams.getG().compareTo(dSAParams2.getG()) != 0) {
            return false;
        }
        if (dSAParams.getP().compareTo(dSAParams2.getP()) != 0) {
            return false;
        }
        return dSAParams.getQ().compareTo(dSAParams2.getQ()) == 0;
    }

    private boolean areEqual(RSAPublicKey rSAPublicKey, RSAPublicKey rSAPublicKey2) {
        if (rSAPublicKey.getPublicExponent().compareTo(rSAPublicKey2.getPublicExponent()) != 0) {
            return false;
        }
        return rSAPublicKey.getModulus().compareTo(rSAPublicKey2.getModulus()) == 0;
    }

    private LinkedList orderChain(Collection collection) {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "orderChain");
        }
        LinkedList linkedList = new LinkedList(collection);
        int n = linkedList.size();
        LinkedList<X509Certificate> linkedList2 = new LinkedList<X509Certificate>();
        Principal principal = this.selfSignedCertificate.getIssuerDN();
        block0: while (linkedList.size() > 0) {
            ListIterator listIterator = linkedList.listIterator();
            while (listIterator.hasNext()) {
                X509Certificate x509Certificate = (X509Certificate)listIterator.next();
                if (!principal.equals(x509Certificate.getSubjectDN())) continue;
                listIterator.remove();
                linkedList2.addLast(x509Certificate);
                principal = x509Certificate.getIssuerDN();
                continue block0;
            }
            throw new IllegalArgumentException(Messages.getFormattedString(Messages.getString("ImportCmd.7"), new Object[]{linkedList2.size(), n}));
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "orderChain", linkedList2);
        }
        return linkedList2;
    }

    private boolean findTrustAndUpdate(LinkedList linkedList, boolean bl) throws IOException, NoSuchAlgorithmException, CertPathValidatorException, KeyStoreException, UnrecoverableKeyException, UnsupportedCallbackException, CertificateEncodingException {
        PKIXParameters pKIXParameters;
        CertPathValidator certPathValidator;
        X509CertPath x509CertPath;
        PKIXCertPathValidatorResult pKIXCertPathValidatorResult;
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "findTrustAndUpdate");
        }
        if ((pKIXCertPathValidatorResult = this.findTrustInStore(x509CertPath = new X509CertPath((List)linkedList), certPathValidator = CertPathValidator.getInstance("PKIX"))) == null && this.trustCACerts && (pKIXCertPathValidatorResult = this.validate(certPathValidator, x509CertPath, pKIXParameters = this.getCertPathParameters(GKR, this.gkrCaCertsPathName))) == null) {
            pKIXParameters = this.getCertPathParameters(JKS, this.jksCaCertsPathName);
            pKIXCertPathValidatorResult = this.validate(certPathValidator, x509CertPath, pKIXParameters);
        }
        boolean bl2 = false;
        if (pKIXCertPathValidatorResult == null) {
            if (bl) {
                this.printVerbose((Certificate)linkedList.getLast());
                ConfirmationCallback confirmationCallback = new ConfirmationCallback(Messages.getString("ImportCmd.32"), 0, 0, 1);
                this.getCallbackHandler().handle(new Callback[]{confirmationCallback});
                int n = confirmationCallback.getSelectedIndex();
                bl2 = n == 0;
            }
        } else {
            TrustAnchor trustAnchor = pKIXCertPathValidatorResult.getTrustAnchor();
            log.fine("Found a chain-of-trust anchored by " + trustAnchor);
            X509Certificate x509Certificate = trustAnchor.getTrustedCert();
            linkedList.addLast(x509Certificate);
            bl2 = true;
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "findTrustAndUpdate", bl2);
        }
        return bl2;
    }

    private PKIXCertPathValidatorResult findTrustInStore(X509CertPath x509CertPath, CertPathValidator certPathValidator) {
        PKIXCertPathValidatorResult pKIXCertPathValidatorResult;
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "findTrustInStore");
        }
        try {
            PKIXParameters pKIXParameters = new PKIXParameters(this.store);
            pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)certPathValidator.validate((CertPath)x509CertPath, pKIXParameters);
        }
        catch (Exception exception) {
            log.log(Level.FINE, "Exception in findTrustInStore(). Ignore + Return NULL", exception);
            pKIXCertPathValidatorResult = null;
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "findTrustInStore", pKIXCertPathValidatorResult);
        }
        return pKIXCertPathValidatorResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PKIXParameters getCertPathParameters(String string, String string2) {
        PKIXParameters pKIXParameters;
        block9: {
            if (Configuration.DEBUG) {
                log.entering(this.getClass().getName(), "getCertPathParameters", new Object[]{string, string2});
            }
            FileInputStream fileInputStream = null;
            pKIXParameters = null;
            try {
                KeyStore keyStore;
                block8: {
                    try {
                        keyStore = KeyStore.getInstance(string);
                        fileInputStream = new FileInputStream(string2);
                        keyStore.load(fileInputStream, "changeit".toCharArray());
                        pKIXParameters = new PKIXParameters(keyStore);
                    }
                    catch (Exception exception) {
                        if (!Configuration.DEBUG) break block8;
                        log.log(Level.FINE, "Exception in getCertPathParameters(). Ignore", exception);
                    }
                }
                keyStore = null;
                if (fileInputStream == null) break block9;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (fileInputStream == null) throw throwable;
                try {
                    fileInputStream.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception exception) {}
            fileInputStream.close();
        }
        if (!Configuration.DEBUG) return pKIXParameters;
        log.exiting(this.getClass().getName(), "getCertPathParameters", pKIXParameters);
        return pKIXParameters;
    }

    private PKIXCertPathValidatorResult validate(CertPathValidator certPathValidator, X509CertPath x509CertPath, PKIXParameters pKIXParameters) {
        PKIXCertPathValidatorResult pKIXCertPathValidatorResult;
        block5: {
            if (Configuration.DEBUG) {
                log.entering(this.getClass().getName(), "validate");
            }
            pKIXCertPathValidatorResult = null;
            if (pKIXParameters != null) {
                try {
                    pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)certPathValidator.validate((CertPath)x509CertPath, pKIXParameters);
                }
                catch (Exception exception) {
                    if (!Configuration.DEBUG) break block5;
                    log.log(Level.FINE, "Exception in validate(). Ignore", exception);
                }
            }
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "validate", pKIXCertPathValidatorResult);
        }
        return pKIXCertPathValidatorResult;
    }

    ImportCmd() {
    }

    static {
        GKR = GKR;
        JKS = JKS;
        LIB = LIB;
        SECURITY = SECURITY;
        CACERTS = CACERTS;
        CACERTS_GKR = CACERTS_GKR;
    }
}

