/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

class GThreadNativeMethodRunner
extends Thread {
    private static WeakReference[] threads = new WeakReference[17];
    private static final Set joinable = Collections.synchronizedSet(new HashSet());
    private final long funcPtr;
    private final long funcArg;

    public void run() {
        this.nativeRun(this.funcPtr, this.funcArg);
    }

    private final native void nativeRun(long var1, long var3);

    private static final synchronized int registerThread(Thread thread) {
        WeakReference[] weakReferenceArray;
        int n = 0;
        while (n < threads.length) {
            weakReferenceArray = threads[n];
            if (weakReferenceArray == null) break;
            ++n;
        }
        if (n == threads.length) {
            weakReferenceArray = new WeakReference[threads.length * 2];
            System.arraycopy(threads, 0, weakReferenceArray, 0, threads.length);
            threads = weakReferenceArray;
        }
        GThreadNativeMethodRunner.threads[n] = new WeakReference(thread);
        return n;
    }

    static synchronized int threadToThreadID(Thread thread) {
        int n = 0;
        while (n < threads.length) {
            if (threads[n] != null) {
                Thread thread2 = (Thread)threads[n].get();
                if (thread2 == null) {
                    GThreadNativeMethodRunner.threads[n] = null;
                } else if (thread2.equals(thread)) {
                    return n;
                }
            }
            ++n;
        }
        return GThreadNativeMethodRunner.registerThread(thread);
    }

    static Thread threadIDToThread(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("Received a negative threadID, " + n);
        }
        if (n >= threads.length) {
            throw new IllegalArgumentException("Received a threadID (" + n + ") higher than was ever issued");
        }
        WeakReference weakReference = threads[n];
        if (weakReference == null) {
            throw new IllegalArgumentException("Asked to look up a stale or unissuedthreadID (" + n + ')');
        }
        Thread thread = (Thread)weakReference.get();
        if (thread == null) {
            throw new IllegalArgumentException("Asked to look up a stale threadID (" + n + ')');
        }
        return thread;
    }

    private final void registerSelfJoinable() {
        joinable.add(this);
    }

    static void deRegisterJoinable(Thread thread) {
        joinable.remove(thread);
    }

    GThreadNativeMethodRunner(long l, long l2, boolean bl) {
        this.funcPtr = l;
        this.funcArg = l2;
        if (bl) {
            this.registerSelfJoinable();
        }
    }
}

