/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ToolBarUI;
import javax.swing.plaf.UIResource;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BasicToolBarUI
extends ToolBarUI
implements SwingConstants {
    static JFrame owner = new JFrame();
    private static Border nonRolloverBorder;
    private static Border rolloverBorder;
    protected String constraintBeforeFloating;
    int lastGoodOrientation;
    protected Color dockingBorderColor;
    protected Color dockingColor;
    protected MouseInputListener dockingListener;
    protected DragWindow dragWindow;
    protected Color floatingBorderColor;
    protected Color floatingColor;
    protected int focusedCompIndex;
    protected PropertyChangeListener propertyListener;
    protected JToolBar toolBar;
    protected ContainerListener toolBarContListener;
    protected FocusListener toolBarFocusListener;
    protected KeyStroke leftKey;
    protected KeyStroke rightKey;
    protected KeyStroke upKey;
    protected KeyStroke downKey;
    private transient Window floatFrame;
    transient Container origParent;
    transient Hashtable borders;
    private transient WindowListener windowListener;
    transient Dimension cachedBounds;
    transient int cachedOrientation;
    static /* synthetic */ Class class$java$awt$Window;

    public boolean canDock(Component component, Point point) {
        boolean bl = false;
        if (this.areaOfClick(component, point) != -1) {
            bl = true;
        }
        return bl;
    }

    private final int areaOfClick(Component component, Point point) {
        Rectangle rectangle = component.getBounds();
        Dimension dimension = this.toolBar.getSize();
        int n = Math.min(dimension.width, dimension.height);
        if (!rectangle.contains(point)) {
            return -1;
        }
        if (point.y < n) {
            return 1;
        }
        if (point.y > rectangle.height - n) {
            return 5;
        }
        if (point.x < n) {
            return 7;
        }
        if (point.x > rectangle.width - n) {
            return 3;
        }
        return -1;
    }

    protected MouseInputListener createDockingListener() {
        return new DockingListener(this.toolBar);
    }

    protected DragWindow createDragWindow(JToolBar jToolBar) {
        return new DragWindow();
    }

    protected JFrame createFloatingFrame(JToolBar jToolBar) {
        return null;
    }

    protected RootPaneContainer createFloatingWindow(JToolBar jToolBar) {
        return new ToolBarDialog();
    }

    protected WindowListener createFrameListener() {
        return new FrameListener();
    }

    protected Border createNonRolloverBorder() {
        return new EtchedBorder();
    }

    protected PropertyChangeListener createPropertyListener() {
        return new PropertyListener();
    }

    protected Border createRolloverBorder() {
        return new EtchedBorder(){

            public final void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                if (component instanceof JButton && ((JButton)component).getModel().isRollover()) {
                    super.paintBorder(component, graphics, n, n2, n3, n4);
                }
            }
        };
    }

    protected ContainerListener createToolBarContListener() {
        return new ToolBarContListener();
    }

    protected FocusListener createToolBarFocusListener() {
        return new ToolBarFocusListener();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicToolBarUI();
    }

    protected void dragTo(Point point, Point point2) {
        int n = this.areaOfClick(this.origParent, SwingUtilities.convertPoint(this.toolBar, point, this.origParent));
        if (n != -1) {
            this.dragWindow.setBorderColor(this.dockingBorderColor);
            this.dragWindow.setBackground(this.dockingColor);
        } else {
            this.dragWindow.setBorderColor(this.floatingBorderColor);
            this.dragWindow.setBackground(this.floatingColor);
        }
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        if (n == 1 || n == 5 || n == -1) {
            bl = true;
        }
        boolean bl2 = bl;
        this.cachedOrientation = this.toolBar.getOrientation();
        this.cachedBounds = this.toolBar.getSize();
        if (this.cachedOrientation == 0 && bl2 || this.cachedOrientation == 1 && !bl2) {
            n2 = this.cachedBounds.width;
            n3 = this.cachedBounds.height;
        } else {
            n2 = this.cachedBounds.height;
            n3 = this.cachedBounds.width;
        }
        Point point3 = this.dragWindow.getOffset();
        Insets insets = this.toolBar.getInsets();
        this.dragWindow.setBounds(point2.x + point.x - point3.x - (insets.left + insets.right) / 2, point2.y + point.y - point3.y - (insets.top + insets.bottom) / 2, n2, n3);
        if (!this.dragWindow.isVisible()) {
            this.dragWindow.show();
        }
    }

    protected void floatAt(Point point, Point point2) {
        String string;
        Container container;
        Point point3 = new Point(point);
        int n = this.areaOfClick(this.origParent, SwingUtilities.convertPoint(this.toolBar, point3, this.origParent));
        Container container2 = this.toolBar.getParent();
        container2.remove(this.toolBar);
        container2.doLayout();
        container2.repaint();
        if (n == -1) {
            container = ((RootPaneContainer)((Object)this.floatFrame)).getContentPane();
        } else {
            this.floatFrame.hide();
            container = this.origParent;
        }
        switch (n) {
            case 3: {
                string = "East";
                break;
            }
            case 1: {
                string = "North";
                break;
            }
            case 5: {
                string = "South";
                break;
            }
            case 7: {
                string = "West";
                break;
            }
            default: {
                string = "Center";
            }
        }
        int n2 = 0;
        if (n != -1 && (n == 3 || n == 7)) {
            n2 = 1;
        }
        if (n != -1) {
            this.constraintBeforeFloating = string;
            this.lastGoodOrientation = n2;
        }
        container.add((Component)this.toolBar, string);
        boolean bl = false;
        if (n == -1) {
            bl = true;
        }
        this.setFloating(bl, null);
        this.toolBar.setOrientation(n2);
        Insets insets = this.floatFrame.getInsets();
        Dimension dimension = this.toolBar.getPreferredSize();
        point3 = this.dragWindow.getOffset();
        this.setFloatingLocation(point.x + point2.x - point3.x - (insets.left + insets.right) / 2, point.y + point2.y - point3.y - (insets.top + insets.bottom) / 2);
        if (n == -1) {
            this.floatFrame.pack();
            this.floatFrame.setSize(dimension.width + insets.left + insets.right, dimension.height + insets.top + insets.bottom);
            this.floatFrame.show();
        }
        container.invalidate();
        container.validate();
        container.repaint();
    }

    public Color getDockingColor() {
        return this.dockingColor;
    }

    public Color getFloatingColor() {
        return this.floatingColor;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    protected void installComponents() {
        this.floatFrame = (Window)((Object)this.createFloatingWindow(this.toolBar));
        this.dragWindow = this.createDragWindow(this.toolBar);
        nonRolloverBorder = this.createNonRolloverBorder();
        rolloverBorder = this.createRolloverBorder();
        this.borders = new Hashtable();
        this.setRolloverBorders(this.toolBar.isRollover());
        this.fillHashtable();
    }

    protected void installDefaults() {
        LookAndFeel.installBorder(this.toolBar, "ToolBar.border");
        LookAndFeel.installColorsAndFont(this.toolBar, "ToolBar.background", "ToolBar.foreground", "ToolBar.font");
        this.dockingBorderColor = UIManager.getColor("ToolBar.dockingForeground");
        this.dockingColor = UIManager.getColor("ToolBar.dockingBackground");
        this.floatingBorderColor = UIManager.getColor("ToolBar.floatingForeground");
        this.floatingColor = UIManager.getColor("ToolBar.floatingBackground");
    }

    protected void installKeyboardActions() {
    }

    protected void installListeners() {
        this.dockingListener = this.createDockingListener();
        this.toolBar.addMouseListener(this.dockingListener);
        this.toolBar.addMouseMotionListener(this.dockingListener);
        this.propertyListener = this.createPropertyListener();
        this.toolBar.addPropertyChangeListener(this.propertyListener);
        this.toolBarContListener = this.createToolBarContListener();
        this.toolBar.addContainerListener(this.toolBarContListener);
        this.windowListener = this.createFrameListener();
        this.floatFrame.addWindowListener(this.windowListener);
        this.toolBarFocusListener = this.createToolBarFocusListener();
        this.toolBar.addFocusListener(this.toolBarFocusListener);
    }

    protected void installNonRolloverBorders(JComponent jComponent) {
        Component[] componentArray = this.toolBar.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            this.setBorderToNonRollover(componentArray[n]);
            ++n;
        }
    }

    protected void installNormalBorders(JComponent jComponent) {
        Component[] componentArray = this.toolBar.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            this.setBorderToNormal(componentArray[n]);
            ++n;
        }
    }

    protected void installRolloverBorders(JComponent jComponent) {
        Component[] componentArray = this.toolBar.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            this.setBorderToRollover(componentArray[n]);
            ++n;
        }
    }

    private final void fillHashtable() {
        Component[] componentArray = this.toolBar.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            JButton jButton;
            if (componentArray[n] instanceof JButton && (jButton = (JButton)componentArray[n]).getBorder() != null) {
                this.borders.put(jButton, jButton.getBorder());
            }
            ++n;
        }
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        if (jComponent instanceof JToolBar) {
            this.toolBar = (JToolBar)jComponent;
            this.installDefaults();
            this.installComponents();
            this.installListeners();
            this.installKeyboardActions();
        }
    }

    public boolean isFloating() {
        return this.floatFrame.isVisible();
    }

    public boolean isRolloverBorders() {
        return this.toolBar.isRollover();
    }

    protected void navigateFocusedComp(int n) {
    }

    protected void setBorderToNonRollover(Component component) {
        if (component instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)component;
            abstractButton.setRolloverEnabled(false);
            abstractButton.setBorder(nonRolloverBorder);
        }
    }

    protected void setBorderToNormal(Component component) {
        if (component instanceof JButton) {
            JButton jButton = (JButton)component;
            Border border = (Border)this.borders.get(jButton);
            jButton.setBorder(border);
        }
    }

    protected void setBorderToRollover(Component component) {
        if (component instanceof JButton) {
            JButton jButton = (JButton)component;
            jButton.setRolloverEnabled(true);
            jButton.setBorder(rolloverBorder);
        }
    }

    public void setDockingColor(Color color) {
        this.dockingColor = color;
    }

    public void setFloating(boolean bl, Point point) {
        this.floatFrame.setVisible(bl);
    }

    public void setFloatingColor(Color color) {
        this.floatingColor = color;
    }

    public void setFloatingLocation(int n, int n2) {
        this.floatFrame.setLocation(n, n2);
        this.floatFrame.invalidate();
        this.floatFrame.validate();
        this.floatFrame.repaint();
    }

    public void setOrientation(int n) {
        this.toolBar.setOrientation(n);
    }

    public void setRolloverBorders(boolean bl) {
        if (bl) {
            this.installRolloverBorders(this.toolBar);
        } else {
            this.installNonRolloverBorders(this.toolBar);
        }
    }

    protected void uninstallComponents() {
        this.installNormalBorders(this.toolBar);
        this.borders = null;
        this.cachedBounds = null;
        this.floatFrame = null;
        this.dragWindow = null;
    }

    protected void uninstallDefaults() {
        this.toolBar.setBackground(null);
        this.toolBar.setForeground(null);
        this.toolBar.setFont(null);
        this.dockingBorderColor = null;
        this.dockingColor = null;
        this.floatingBorderColor = null;
        this.floatingColor = null;
    }

    protected void uninstallKeyboardActions() {
    }

    protected void uninstallListeners() {
        this.toolBar.removeFocusListener(this.toolBarFocusListener);
        this.toolBarFocusListener = null;
        this.floatFrame.removeWindowListener(this.windowListener);
        this.windowListener = null;
        this.toolBar.removeContainerListener(this.toolBarContListener);
        this.toolBarContListener = null;
        this.toolBar.removeMouseMotionListener(this.dockingListener);
        this.toolBar.removeMouseListener(this.dockingListener);
        this.dockingListener = null;
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        this.toolBar = null;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class DockingListener
    implements MouseInputListener {
        protected boolean isDragging;
        protected Point origin;
        protected JToolBar toolBar;

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.isDragging) {
                BasicToolBarUI.this.dragTo(mouseEvent.getPoint(), this.origin);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Class clazz;
            if (!this.toolBar.isFloatable()) {
                return;
            }
            Point point = mouseEvent.getPoint();
            Insets insets = this.toolBar.getInsets();
            if (this.toolBar.getOrientation() == 0 ? mouseEvent.getX() > insets.left : mouseEvent.getY() > insets.top) {
                return;
            }
            this.origin = new Point(0, 0);
            if (this.toolBar.isShowing()) {
                SwingUtilities.convertPointToScreen(point, this.toolBar);
            }
            if ((clazz = class$java$awt$Window) == null) {
                clazz = class$java$awt$Window = BasicToolBarUI.class("[Ljava.awt.Window;", false);
            }
            if (!(SwingUtilities.getAncestorOfClass(clazz, this.toolBar) instanceof UIResource)) {
                BasicToolBarUI.this.origParent = this.toolBar.getParent();
            }
            if (this.toolBar.isShowing()) {
                SwingUtilities.convertPointToScreen(this.origin, this.toolBar);
            }
            this.isDragging = true;
            if (BasicToolBarUI.this.dragWindow != null) {
                BasicToolBarUI.this.dragWindow.setOffset(new Point(BasicToolBarUI.this.cachedBounds.width / 2, BasicToolBarUI.this.cachedBounds.height / 2));
            }
            BasicToolBarUI.this.dragTo(mouseEvent.getPoint(), this.origin);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!this.isDragging || !this.toolBar.isFloatable()) {
                return;
            }
            this.isDragging = false;
            BasicToolBarUI.this.floatAt(mouseEvent.getPoint(), this.origin);
            BasicToolBarUI.this.dragWindow.hide();
        }

        public DockingListener(JToolBar jToolBar) {
            this.toolBar = jToolBar;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class DragWindow
    extends Window {
        private Color borderColor;
        private Point offset;

        public Color getBorderColor() {
            if (this.borderColor == null) {
                return Color.BLACK;
            }
            return this.borderColor;
        }

        public Insets getInsets() {
            return new Insets(0, 0, 0, 0);
        }

        public Point getOffset() {
            return this.offset;
        }

        public void paint(Graphics graphics) {
            Color color = graphics.getColor();
            Rectangle rectangle = this.getBounds();
            graphics.setColor(this.getBorderColor());
            graphics.drawRect(0, 0, rectangle.width - 1, rectangle.height - 1);
            graphics.setColor(color);
        }

        public void setBorderColor(Color color) {
            this.borderColor = color;
        }

        public void setOffset(Point point) {
            this.offset = point;
        }

        public void setOrientation(int n) {
        }

        DragWindow() {
            super(owner);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ToolBarDialog
    extends JDialog
    implements UIResource {
        public ToolBarDialog() {
            this.setName(BasicToolBarUI.this.toolBar.getName() != null ? BasicToolBarUI.this.toolBar.getName() : "");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class FrameListener
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            Container container = BasicToolBarUI.this.toolBar.getParent();
            container.remove(BasicToolBarUI.this.toolBar);
            if (BasicToolBarUI.this.origParent != null) {
                BasicToolBarUI.this.origParent.add((Component)BasicToolBarUI.this.toolBar, BasicToolBarUI.this.constraintBeforeFloating != null ? BasicToolBarUI.this.constraintBeforeFloating : "North");
                BasicToolBarUI.this.toolBar.setOrientation(BasicToolBarUI.this.lastGoodOrientation);
            }
            BasicToolBarUI.this.origParent.invalidate();
            BasicToolBarUI.this.origParent.validate();
            BasicToolBarUI.this.origParent.repaint();
        }

        protected FrameListener() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class PropertyListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("rollover") && BasicToolBarUI.this.toolBar != null) {
                BasicToolBarUI.this.setRolloverBorders(BasicToolBarUI.this.toolBar.isRollover());
            }
        }

        protected PropertyListener() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class ToolBarContListener
    implements ContainerListener {
        public void componentAdded(ContainerEvent containerEvent) {
            JButton jButton;
            if (containerEvent.getChild() instanceof JButton && (jButton = (JButton)containerEvent.getChild()).getBorder() != null) {
                BasicToolBarUI.this.borders.put(jButton, jButton.getBorder());
            }
            if (BasicToolBarUI.this.isRolloverBorders()) {
                BasicToolBarUI.this.setBorderToRollover(containerEvent.getChild());
            } else {
                BasicToolBarUI.this.setBorderToNonRollover(containerEvent.getChild());
            }
            BasicToolBarUI.this.cachedBounds = BasicToolBarUI.this.toolBar.getPreferredSize();
            BasicToolBarUI.this.cachedOrientation = BasicToolBarUI.this.toolBar.getOrientation();
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            BasicToolBarUI.this.setBorderToNormal(containerEvent.getChild());
            BasicToolBarUI.this.cachedBounds = BasicToolBarUI.this.toolBar.getPreferredSize();
            BasicToolBarUI.this.cachedOrientation = BasicToolBarUI.this.toolBar.getOrientation();
        }

        protected ToolBarContListener() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class ToolBarFocusListener
    implements FocusListener {
        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
        }

        protected ToolBarFocusListener() {
        }
    }

    private static class ToolBarBorder
    implements Border {
        private static final int offset = 10;
        private static final int regular = 2;

        public Insets getBorderInsets(Component component) {
            if (component instanceof JToolBar) {
                JToolBar jToolBar = (JToolBar)component;
                int n = jToolBar.getOrientation();
                if (!jToolBar.isFloatable()) {
                    return new Insets(2, 2, 2, 2);
                }
                if (n == 0) {
                    return new Insets(2, 10, 2, 2);
                }
                return new Insets(10, 2, 2, 2);
            }
            return new Insets(0, 0, 0, 0);
        }

        public boolean isBorderOpaque() {
            return false;
        }

        private final void paintBumps(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color) {
            Color color2 = graphics.getColor();
            graphics.setColor(color);
            int n6 = 2 * n5;
            int n7 = 4 * n5;
            int n8 = 0;
            int n9 = n;
            while (n9 < n3 + n) {
                int n10 = n8++ % 2 == 0 ? n2 : n2 + 2 * n5;
                while (n10 < n4 + n2) {
                    graphics.fillRect(n9, n10, n5, n5);
                    n10 += n7;
                }
                n9 += n6;
            }
            graphics.setColor(color2);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (component instanceof JToolBar) {
                JToolBar jToolBar = (JToolBar)component;
                int n5 = jToolBar.getOrientation();
                if (n5 == 0) {
                    this.paintBumps(graphics, n, n2, 10, n4, 1, Color.WHITE);
                    this.paintBumps(graphics, n + 1, n2 + 1, 9, n4 - 1, 1, Color.GRAY);
                } else {
                    this.paintBumps(graphics, n, n2, n3, 10, 1, Color.WHITE);
                    this.paintBumps(graphics, n + 1, n2 + 1, n3 - 1, 9, 1, Color.GRAY);
                }
            }
        }

        private ToolBarBorder() {
        }
    }
}

