/*
 *  MICO --- an Open Source CORBA implementation
 *  Copyright (c) 1997-2001 by The Mico Team
 *
 *  This file was automatically generated. DO NOT EDIT!
 */

#include <CORBA.h>
#include <mico/throw.h>

#ifndef __COSRELATIONSHIPS_H__
#define __COSRELATIONSHIPS_H__


#include <mico/ir_base.h>
#include <mico/ir.h>
#include <mico/CosObjectIdentity.h>



namespace CosRelationships {


typedef IfaceSequenceTmpl<CORBA::InterfaceDef_var,CORBA::InterfaceDef_ptr> InterfaceDefs;
#ifdef _WINDOWS
static InterfaceDefs _dummy_InterfaceDefs;
#endif
typedef TSeqVar<IfaceSequenceTmpl<CORBA::InterfaceDef_var,CORBA::InterfaceDef_ptr> > InterfaceDefs_var;
typedef TSeqOut<IfaceSequenceTmpl<CORBA::InterfaceDef_var,CORBA::InterfaceDef_ptr> > InterfaceDefs_out;

class Role;
typedef Role *Role_ptr;
typedef Role_ptr RoleRef;
typedef ObjVar<Role> Role_var;
typedef ObjOut<Role> Role_out;

typedef CORBA::Object RelatedObject;
typedef CORBA::Object_ptr RelatedObject_ptr;
typedef CORBA::ObjectRef RelatedObjectRef;
typedef CORBA::Object_var RelatedObject_var;
typedef CORBA::Object_out RelatedObject_out;

class RoleFactory;
typedef RoleFactory *RoleFactory_ptr;
typedef RoleFactory_ptr RoleFactoryRef;
typedef ObjVar<RoleFactory> RoleFactory_var;
typedef ObjOut<RoleFactory> RoleFactory_out;


/*
 * Base class and common definitions for interface RoleFactory
 */

class RoleFactory : 
  virtual public CORBA::Object
{
  public:
    virtual ~RoleFactory();

    #ifdef HAVE_TYPEDEF_OVERLOAD
    typedef RoleFactory_ptr _ptr_type;
    typedef RoleFactory_var _var_type;
    #endif

    static RoleFactory_ptr _narrow( CORBA::Object_ptr obj );
    static RoleFactory_ptr _narrow( CORBA::AbstractBase_ptr obj );
    static RoleFactory_ptr _duplicate( RoleFactory_ptr _obj )
    {
      CORBA::Object::_duplicate (_obj);
      return _obj;
    }

    static RoleFactory_ptr _nil()
    {
      return 0;
    }

    virtual void *_narrow_helper( const char *repoid );

    struct NilRelatedObject : public CORBA::UserException {
      #ifdef HAVE_EXPLICIT_STRUCT_OPS
      NilRelatedObject();
      ~NilRelatedObject();
      NilRelatedObject( const NilRelatedObject& s );
      NilRelatedObject& operator=( const NilRelatedObject& s );
      #endif //HAVE_EXPLICIT_STRUCT_OPS


      #ifdef HAVE_STD_EH
      NilRelatedObject *operator->() { return this; }
      NilRelatedObject& operator*() { return *this; }
      operator NilRelatedObject*() { return this; }
      #endif // HAVE_STD_EH

      void _throwit() const;
      const char *_repoid() const;
      void _encode( CORBA::DataEncoder &en ) const;
      void _encode_any( CORBA::Any &a ) const;
      CORBA::Exception *_clone() const;
      static NilRelatedObject *_downcast( CORBA::Exception *ex );
      static const NilRelatedObject *_downcast( const CORBA::Exception *ex );
    };

    #ifdef HAVE_STD_EH
    typedef NilRelatedObject NilRelatedObject_catch;
    #else
    typedef ExceptVar<NilRelatedObject> NilRelatedObject_var;
    typedef TVarOut<NilRelatedObject> NilRelatedObject_out;
    typedef NilRelatedObject_var NilRelatedObject_catch;
    #endif // HAVE_STD_EH

    struct RelatedObjectTypeError : public CORBA::UserException {
      #ifdef HAVE_EXPLICIT_STRUCT_OPS
      RelatedObjectTypeError();
      ~RelatedObjectTypeError();
      RelatedObjectTypeError( const RelatedObjectTypeError& s );
      RelatedObjectTypeError& operator=( const RelatedObjectTypeError& s );
      #endif //HAVE_EXPLICIT_STRUCT_OPS


      #ifdef HAVE_STD_EH
      RelatedObjectTypeError *operator->() { return this; }
      RelatedObjectTypeError& operator*() { return *this; }
      operator RelatedObjectTypeError*() { return this; }
      #endif // HAVE_STD_EH

      void _throwit() const;
      const char *_repoid() const;
      void _encode( CORBA::DataEncoder &en ) const;
      void _encode_any( CORBA::Any &a ) const;
      CORBA::Exception *_clone() const;
      static RelatedObjectTypeError *_downcast( CORBA::Exception *ex );
      static const RelatedObjectTypeError *_downcast( const CORBA::Exception *ex );
    };

    #ifdef HAVE_STD_EH
    typedef RelatedObjectTypeError RelatedObjectTypeError_catch;
    #else
    typedef ExceptVar<RelatedObjectTypeError> RelatedObjectTypeError_var;
    typedef TVarOut<RelatedObjectTypeError> RelatedObjectTypeError_out;
    typedef RelatedObjectTypeError_var RelatedObjectTypeError_catch;
    #endif // HAVE_STD_EH

    virtual CORBA::InterfaceDef_ptr role_type() = 0;
    virtual CORBA::ULong max_cardinality() = 0;
    virtual CORBA::ULong min_cardinality() = 0;
    virtual InterfaceDefs* related_object_types() = 0;

    virtual Role_ptr create_role( CORBA::Object_ptr related_object ) = 0;

  protected:
    RoleFactory() {};
  private:
    RoleFactory( const RoleFactory& );
    void operator=( const RoleFactory& );
};

// Stub for interface RoleFactory
class RoleFactory_stub:
  virtual public RoleFactory
{
  public:
    virtual ~RoleFactory_stub();
    CORBA::InterfaceDef_ptr role_type();
    CORBA::ULong max_cardinality();
    CORBA::ULong min_cardinality();
    InterfaceDefs* related_object_types();

    Role_ptr create_role( CORBA::Object_ptr related_object );

  private:
    void operator=( const RoleFactory_stub& );
};

#ifndef MICO_CONF_NO_POA

class RoleFactory_stub_clp :
  virtual public RoleFactory_stub,
  virtual public PortableServer::StubBase
{
  public:
    RoleFactory_stub_clp (PortableServer::POA_ptr, CORBA::Object_ptr);
    virtual ~RoleFactory_stub_clp ();
    CORBA::InterfaceDef_ptr role_type();
    CORBA::ULong max_cardinality();
    CORBA::ULong min_cardinality();
    InterfaceDefs* related_object_types();

    Role_ptr create_role( CORBA::Object_ptr related_object );

  protected:
    RoleFactory_stub_clp ();
  private:
    void operator=( const RoleFactory_stub_clp & );
};

#endif // MICO_CONF_NO_POA

typedef char* RoleName;
typedef CORBA::String_var RoleName_var;
typedef CORBA::String_out RoleName_out;

struct NamedRole;
typedef TVarVar<NamedRole> NamedRole_var;
typedef TVarOut<NamedRole> NamedRole_out;


typedef SequenceTmpl<NamedRole,MICO_TID_DEF> NamedRoles;
#ifdef _WINDOWS
static NamedRoles _dummy_NamedRoles;
#endif
typedef TSeqVar<SequenceTmpl<NamedRole,MICO_TID_DEF> > NamedRoles_var;
typedef TSeqOut<SequenceTmpl<NamedRole,MICO_TID_DEF> > NamedRoles_out;

class Relationship;
typedef Relationship *Relationship_ptr;
typedef Relationship_ptr RelationshipRef;
typedef ObjVar<Relationship> Relationship_var;
typedef ObjOut<Relationship> Relationship_out;

class RelationshipFactory;
typedef RelationshipFactory *RelationshipFactory_ptr;
typedef RelationshipFactory_ptr RelationshipFactoryRef;
typedef ObjVar<RelationshipFactory> RelationshipFactory_var;
typedef ObjOut<RelationshipFactory> RelationshipFactory_out;


/*
 * Base class and common definitions for interface RelationshipFactory
 */

class RelationshipFactory : 
  virtual public CORBA::Object
{
  public:
    virtual ~RelationshipFactory();

    #ifdef HAVE_TYPEDEF_OVERLOAD
    typedef RelationshipFactory_ptr _ptr_type;
    typedef RelationshipFactory_var _var_type;
    #endif

    static RelationshipFactory_ptr _narrow( CORBA::Object_ptr obj );
    static RelationshipFactory_ptr _narrow( CORBA::AbstractBase_ptr obj );
    static RelationshipFactory_ptr _duplicate( RelationshipFactory_ptr _obj )
    {
      CORBA::Object::_duplicate (_obj);
      return _obj;
    }

    static RelationshipFactory_ptr _nil()
    {
      return 0;
    }

    virtual void *_narrow_helper( const char *repoid );

    struct NamedRoleType;
    typedef TVarVar<NamedRoleType> NamedRoleType_var;
    typedef TVarOut<NamedRoleType> NamedRoleType_out;


    struct NamedRoleType {
      #ifdef HAVE_TYPEDEF_OVERLOAD
      typedef NamedRoleType_var _var_type;
      #endif
      #ifdef HAVE_EXPLICIT_STRUCT_OPS
      NamedRoleType();
      ~NamedRoleType();
      NamedRoleType( const NamedRoleType& s );
      NamedRoleType& operator=( const NamedRoleType& s );
      #endif //HAVE_EXPLICIT_STRUCT_OPS

      RoleName_var name;
      CORBA::InterfaceDef_var named_role_type;
    };

    typedef SequenceTmpl<NamedRoleType,MICO_TID_DEF> NamedRoleTypes;
    #ifdef _WINDOWS
    static NamedRoleTypes _dummy_NamedRoleTypes;
    #endif
    typedef TSeqVar<SequenceTmpl<NamedRoleType,MICO_TID_DEF> > NamedRoleTypes_var;
    typedef TSeqOut<SequenceTmpl<NamedRoleType,MICO_TID_DEF> > NamedRoleTypes_out;

    struct RoleTypeError : public CORBA::UserException {
      #ifdef HAVE_EXPLICIT_STRUCT_OPS
      RoleTypeError();
      ~RoleTypeError();
      RoleTypeError( const RoleTypeError& s );
      RoleTypeError& operator=( const RoleTypeError& s );
      #endif //HAVE_EXPLICIT_STRUCT_OPS

      #ifndef HAVE_EXPLICIT_STRUCT_OPS
      RoleTypeError();
      #endif //HAVE_EXPLICIT_STRUCT_OPS
      RoleTypeError( const NamedRoles& _m0 );

      #ifdef HAVE_STD_EH
      RoleTypeError *operator->() { return this; }
      RoleTypeError& operator*() { return *this; }
      operator RoleTypeError*() { return this; }
      #endif // HAVE_STD_EH

      void _throwit() const;
      const char *_repoid() const;
      void _encode( CORBA::DataEncoder &en ) const;
      void _encode_any( CORBA::Any &a ) const;
      CORBA::Exception *_clone() const;
      static RoleTypeError *_downcast( CORBA::Exception *ex );
      static const RoleTypeError *_downcast( const CORBA::Exception *ex );
      NamedRoles culprits;
    };

    #ifdef HAVE_STD_EH
    typedef RoleTypeError RoleTypeError_catch;
    #else
    typedef ExceptVar<RoleTypeError> RoleTypeError_var;
    typedef TVarOut<RoleTypeError> RoleTypeError_out;
    typedef RoleTypeError_var RoleTypeError_catch;
    #endif // HAVE_STD_EH

    struct MaxCardinalityExceeded : public CORBA::UserException {
      #ifdef HAVE_EXPLICIT_STRUCT_OPS
      MaxCardinalityExceeded();
      ~MaxCardinalityExceeded();
      MaxCardinalityExceeded( const MaxCardinalityExceeded& s );
      MaxCardinalityExceeded& operator=( const MaxCardinalityExceeded& s );
      #endif //HAVE_EXPLICIT_STRUCT_OPS

      #ifndef HAVE_EXPLICIT_STRUCT_OPS
      MaxCardinalityExceeded();
      #endif //HAVE_EXPLICIT_STRUCT_OPS
      MaxCardinalityExceeded( const NamedRoles& _m0 );

      #ifdef HAVE_STD_EH
      MaxCardinalityExceeded *operator->() { return this; }
      MaxCardinalityExceeded& operator*() { return *this; }
      operator MaxCardinalityExceeded*() { return this; }
      #endif // HAVE_STD_EH

      void _throwit() const;
      const char *_repoid() const;
      void _encode( CORBA::DataEncoder &en ) const;
      void _encode_any( CORBA::Any &a ) const;
      CORBA::Exception *_clone() const;
      static MaxCardinalityExceeded *_downcast( CORBA::Exception *ex );
      static const MaxCardinalityExceeded *_downcast( const CORBA::Exception *ex );
      NamedRoles culprits;
    };

    #ifdef HAVE_STD_EH
    typedef MaxCardinalityExceeded MaxCardinalityExceeded_catch;
    #else
    typedef ExceptVar<MaxCardinalityExceeded> MaxCardinalityExceeded_var;
    typedef TVarOut<MaxCardinalityExceeded> MaxCardinalityExceeded_out;
    typedef MaxCardinalityExceeded_var MaxCardinalityExceeded_catch;
    #endif // HAVE_STD_EH

    struct DegreeError : public CORBA::UserException {
      #ifdef HAVE_EXPLICIT_STRUCT_OPS
      DegreeError();
      ~DegreeError();
      DegreeError( const DegreeError& s );
      DegreeError& operator=( const DegreeError& s );
      #endif //HAVE_EXPLICIT_STRUCT_OPS

      #ifndef HAVE_EXPLICIT_STRUCT_OPS
      DegreeError();
      #endif //HAVE_EXPLICIT_STRUCT_OPS
      DegreeError( CORBA::UShort _m0 );

      #ifdef HAVE_STD_EH
      DegreeError *operator->() { return this; }
      DegreeError& operator*() { return *this; }
      operator DegreeError*() { return this; }
      #endif // HAVE_STD_EH

      void _throwit() const;
      const char *_repoid() const;
      void _encode( CORBA::DataEncoder &en ) const;
      void _encode_any( CORBA::Any &a ) const;
      CORBA::Exception *_clone() const;
      static DegreeError *_downcast( CORBA::Exception *ex );
      static const DegreeError *_downcast( const CORBA::Exception *ex );
      CORBA::UShort required_degree;
    };

    #ifdef HAVE_STD_EH
    typedef DegreeError DegreeError_catch;
    #else
    typedef ExceptVar<DegreeError> DegreeError_var;
    typedef TVarOut<DegreeError> DegreeError_out;
    typedef DegreeError_var DegreeError_catch;
    #endif // HAVE_STD_EH

    struct DuplicateRoleName : public CORBA::UserException {
      #ifdef HAVE_EXPLICIT_STRUCT_OPS
      DuplicateRoleName();
      ~DuplicateRoleName();
      DuplicateRoleName( const DuplicateRoleName& s );
      DuplicateRoleName& operator=( const DuplicateRoleName& s );
      #endif //HAVE_EXPLICIT_STRUCT_OPS

      #ifndef HAVE_EXPLICIT_STRUCT_OPS
      DuplicateRoleName();
      #endif //HAVE_EXPLICIT_STRUCT_OPS
      DuplicateRoleName( const NamedRoles& _m0 );

      #ifdef HAVE_STD_EH
      DuplicateRoleName *operator->() { return this; }
      DuplicateRoleName& operator*() { return *this; }
      operator DuplicateRoleName*() { return this; }
      #endif // HAVE_STD_EH

      void _throwit() const;
      const char *_repoid() const;
      void _encode( CORBA::DataEncoder &en ) const;
      void _encode_any( CORBA::Any &a ) const;
      CORBA::Exception *_clone() const;
      static DuplicateRoleName *_downcast( CORBA::Exception *ex );
      static const DuplicateRoleName *_downcast( const CORBA::Exception *ex );
      NamedRoles culprits;
    };

    #ifdef HAVE_STD_EH
    typedef DuplicateRoleName DuplicateRoleName_catch;
    #else
    typedef ExceptVar<DuplicateRoleName> DuplicateRoleName_var;
    typedef TVarOut<DuplicateRoleName> DuplicateRoleName_out;
    typedef DuplicateRoleName_var DuplicateRoleName_catch;
    #endif // HAVE_STD_EH

    struct UnknownRoleName : public CORBA::UserException {
      #ifdef HAVE_EXPLICIT_STRUCT_OPS
      UnknownRoleName();
      ~UnknownRoleName();
      UnknownRoleName( const UnknownRoleName& s );
      UnknownRoleName& operator=( const UnknownRoleName& s );
      #endif //HAVE_EXPLICIT_STRUCT_OPS

      #ifndef HAVE_EXPLICIT_STRUCT_OPS
      UnknownRoleName();
      #endif //HAVE_EXPLICIT_STRUCT_OPS
      UnknownRoleName( const NamedRoles& _m0 );

      #ifdef HAVE_STD_EH
      UnknownRoleName *operator->() { return this; }
      UnknownRoleName& operator*() { return *this; }
      operator UnknownRoleName*() { return this; }
      #endif // HAVE_STD_EH

      void _throwit() const;
      const char *_repoid() const;
      void _encode( CORBA::DataEncoder &en ) const;
      void _encode_any( CORBA::Any &a ) const;
      CORBA::Exception *_clone() const;
      static UnknownRoleName *_downcast( CORBA::Exception *ex );
      static const UnknownRoleName *_downcast( const CORBA::Exception *ex );
      NamedRoles culprits;
    };

    #ifdef HAVE_STD_EH
    typedef UnknownRoleName UnknownRoleName_catch;
    #else
    typedef ExceptVar<UnknownRoleName> UnknownRoleName_var;
    typedef TVarOut<UnknownRoleName> UnknownRoleName_out;
    typedef UnknownRoleName_var UnknownRoleName_catch;
    #endif // HAVE_STD_EH

    virtual CORBA::InterfaceDef_ptr relationship_type() = 0;
    virtual CORBA::UShort degree() = 0;
    virtual NamedRoleTypes* named_role_types() = 0;

    virtual Relationship_ptr create( const NamedRoles& named_roles ) = 0;

  protected:
    RelationshipFactory() {};
  private:
    RelationshipFactory( const RelationshipFactory& );
    void operator=( const RelationshipFactory& );
};

// Stub for interface RelationshipFactory
class RelationshipFactory_stub:
  virtual public RelationshipFactory
{
  public:
    virtual ~RelationshipFactory_stub();
    CORBA::InterfaceDef_ptr relationship_type();
    CORBA::UShort degree();
    NamedRoleTypes* named_role_types();

    Relationship_ptr create( const NamedRoles& named_roles );

  private:
    void operator=( const RelationshipFactory_stub& );
};

#ifndef MICO_CONF_NO_POA

class RelationshipFactory_stub_clp :
  virtual public RelationshipFactory_stub,
  virtual public PortableServer::StubBase
{
  public:
    RelationshipFactory_stub_clp (PortableServer::POA_ptr, CORBA::Object_ptr);
    virtual ~RelationshipFactory_stub_clp ();
    CORBA::InterfaceDef_ptr relationship_type();
    CORBA::UShort degree();
    NamedRoleTypes* named_role_types();

    Relationship_ptr create( const NamedRoles& named_roles );

  protected:
    RelationshipFactory_stub_clp ();
  private:
    void operator=( const RelationshipFactory_stub_clp & );
};

#endif // MICO_CONF_NO_POA

typedef IfaceSequenceTmpl<Role_var,Role_ptr> Roles;
#ifdef _WINDOWS
static Roles _dummy_Roles;
#endif
typedef TSeqVar<IfaceSequenceTmpl<Role_var,Role_ptr> > Roles_var;
typedef TSeqOut<IfaceSequenceTmpl<Role_var,Role_ptr> > Roles_out;


/*
 * Base class and common definitions for interface Relationship
 */

class Relationship : 
  virtual public ::CosObjectIdentity::IdentifiableObject
{
  public:
    typedef ::CosObjectIdentity::IdentifiableObject _VCHACK__CosObjectIdentity__IdentifiableObject;
    virtual ~Relationship();

    #ifdef HAVE_TYPEDEF_OVERLOAD
    typedef Relationship_ptr _ptr_type;
    typedef Relationship_var _var_type;
    #endif

    static Relationship_ptr _narrow( CORBA::Object_ptr obj );
    static Relationship_ptr _narrow( CORBA::AbstractBase_ptr obj );
    static Relationship_ptr _duplicate( Relationship_ptr _obj )
    {
      CORBA::Object::_duplicate (_obj);
      return _obj;
    }

    static Relationship_ptr _nil()
    {
      return 0;
    }

    virtual void *_narrow_helper( const char *repoid );

    struct CannotUnlink : public CORBA::UserException {
      #ifdef HAVE_EXPLICIT_STRUCT_OPS
      CannotUnlink();
      ~CannotUnlink();
      CannotUnlink( const CannotUnlink& s );
      CannotUnlink& operator=( const CannotUnlink& s );
      #endif //HAVE_EXPLICIT_STRUCT_OPS

      #ifndef HAVE_EXPLICIT_STRUCT_OPS
      CannotUnlink();
      #endif //HAVE_EXPLICIT_STRUCT_OPS
      CannotUnlink( const Roles& _m0 );

      #ifdef HAVE_STD_EH
      CannotUnlink *operator->() { return this; }
      CannotUnlink& operator*() { return *this; }
      operator CannotUnlink*() { return this; }
      #endif // HAVE_STD_EH

      void _throwit() const;
      const char *_repoid() const;
      void _encode( CORBA::DataEncoder &en ) const;
      void _encode_any( CORBA::Any &a ) const;
      CORBA::Exception *_clone() const;
      static CannotUnlink *_downcast( CORBA::Exception *ex );
      static const CannotUnlink *_downcast( const CORBA::Exception *ex );
      Roles offending_roles;
    };

    #ifdef HAVE_STD_EH
    typedef CannotUnlink CannotUnlink_catch;
    #else
    typedef ExceptVar<CannotUnlink> CannotUnlink_var;
    typedef TVarOut<CannotUnlink> CannotUnlink_out;
    typedef CannotUnlink_var CannotUnlink_catch;
    #endif // HAVE_STD_EH

    virtual NamedRoles* named_roles() = 0;

    virtual void destroy() = 0;

  protected:
    Relationship() {};
  private:
    Relationship( const Relationship& );
    void operator=( const Relationship& );
};

// Stub for interface Relationship
class Relationship_stub:
  virtual public Relationship,
  virtual public ::CosObjectIdentity::IdentifiableObject_stub
{
  public:
    virtual ~Relationship_stub();
    NamedRoles* named_roles();

    void destroy();

  private:
    void operator=( const Relationship_stub& );
};

#ifndef MICO_CONF_NO_POA

class Relationship_stub_clp :
  virtual public Relationship_stub,
  virtual public ::CosObjectIdentity::IdentifiableObject_stub_clp
{
  public:
    Relationship_stub_clp (PortableServer::POA_ptr, CORBA::Object_ptr);
    virtual ~Relationship_stub_clp ();
    NamedRoles* named_roles();

    void destroy();

  protected:
    Relationship_stub_clp ();
  private:
    void operator=( const Relationship_stub_clp & );
};

#endif // MICO_CONF_NO_POA

struct RelationshipHandle;
typedef TVarVar<RelationshipHandle> RelationshipHandle_var;
typedef TVarOut<RelationshipHandle> RelationshipHandle_out;


typedef SequenceTmpl<RelationshipHandle,MICO_TID_DEF> RelationshipHandles;
#ifdef _WINDOWS
static RelationshipHandles _dummy_RelationshipHandles;
#endif
typedef TSeqVar<SequenceTmpl<RelationshipHandle,MICO_TID_DEF> > RelationshipHandles_var;
typedef TSeqOut<SequenceTmpl<RelationshipHandle,MICO_TID_DEF> > RelationshipHandles_out;

struct RelationshipHandle {
  #ifdef HAVE_TYPEDEF_OVERLOAD
  typedef RelationshipHandle_var _var_type;
  #endif
  #ifdef HAVE_EXPLICIT_STRUCT_OPS
  RelationshipHandle();
  ~RelationshipHandle();
  RelationshipHandle( const RelationshipHandle& s );
  RelationshipHandle& operator=( const RelationshipHandle& s );
  #endif //HAVE_EXPLICIT_STRUCT_OPS

  Relationship_var the_relationship;
  CosObjectIdentity::ObjectIdentifier constant_random_id;
};

class RelationshipIterator;
typedef RelationshipIterator *RelationshipIterator_ptr;
typedef RelationshipIterator_ptr RelationshipIteratorRef;
typedef ObjVar<RelationshipIterator> RelationshipIterator_var;
typedef ObjOut<RelationshipIterator> RelationshipIterator_out;


/*
 * Base class and common definitions for interface Role
 */

class Role : 
  virtual public CORBA::Object
{
  public:
    virtual ~Role();

    #ifdef HAVE_TYPEDEF_OVERLOAD
    typedef Role_ptr _ptr_type;
    typedef Role_var _var_type;
    #endif

    static Role_ptr _narrow( CORBA::Object_ptr obj );
    static Role_ptr _narrow( CORBA::AbstractBase_ptr obj );
    static Role_ptr _duplicate( Role_ptr _obj )
    {
      CORBA::Object::_duplicate (_obj);
      return _obj;
    }

    static Role_ptr _nil()
    {
      return 0;
    }

    virtual void *_narrow_helper( const char *repoid );

    struct UnknownRoleName : public CORBA::UserException {
      #ifdef HAVE_EXPLICIT_STRUCT_OPS
      UnknownRoleName();
      ~UnknownRoleName();
      UnknownRoleName( const UnknownRoleName& s );
      UnknownRoleName& operator=( const UnknownRoleName& s );
      #endif //HAVE_EXPLICIT_STRUCT_OPS


      #ifdef HAVE_STD_EH
      UnknownRoleName *operator->() { return this; }
      UnknownRoleName& operator*() { return *this; }
      operator UnknownRoleName*() { return this; }
      #endif // HAVE_STD_EH

      void _throwit() const;
      const char *_repoid() const;
      void _encode( CORBA::DataEncoder &en ) const;
      void _encode_any( CORBA::Any &a ) const;
      CORBA::Exception *_clone() const;
      static UnknownRoleName *_downcast( CORBA::Exception *ex );
      static const UnknownRoleName *_downcast( const CORBA::Exception *ex );
    };

    #ifdef HAVE_STD_EH
    typedef UnknownRoleName UnknownRoleName_catch;
    #else
    typedef ExceptVar<UnknownRoleName> UnknownRoleName_var;
    typedef TVarOut<UnknownRoleName> UnknownRoleName_out;
    typedef UnknownRoleName_var UnknownRoleName_catch;
    #endif // HAVE_STD_EH

    struct UnknownRelationship : public CORBA::UserException {
      #ifdef HAVE_EXPLICIT_STRUCT_OPS
      UnknownRelationship();
      ~UnknownRelationship();
      UnknownRelationship( const UnknownRelationship& s );
      UnknownRelationship& operator=( const UnknownRelationship& s );
      #endif //HAVE_EXPLICIT_STRUCT_OPS


      #ifdef HAVE_STD_EH
      UnknownRelationship *operator->() { return this; }
      UnknownRelationship& operator*() { return *this; }
      operator UnknownRelationship*() { return this; }
      #endif // HAVE_STD_EH

      void _throwit() const;
      const char *_repoid() const;
      void _encode( CORBA::DataEncoder &en ) const;
      void _encode_any( CORBA::Any &a ) const;
      CORBA::Exception *_clone() const;
      static UnknownRelationship *_downcast( CORBA::Exception *ex );
      static const UnknownRelationship *_downcast( const CORBA::Exception *ex );
    };

    #ifdef HAVE_STD_EH
    typedef UnknownRelationship UnknownRelationship_catch;
    #else
    typedef ExceptVar<UnknownRelationship> UnknownRelationship_var;
    typedef TVarOut<UnknownRelationship> UnknownRelationship_out;
    typedef UnknownRelationship_var UnknownRelationship_catch;
    #endif // HAVE_STD_EH

    struct RelationshipTypeError : public CORBA::UserException {
      #ifdef HAVE_EXPLICIT_STRUCT_OPS
      RelationshipTypeError();
      ~RelationshipTypeError();
      RelationshipTypeError( const RelationshipTypeError& s );
      RelationshipTypeError& operator=( const RelationshipTypeError& s );
      #endif //HAVE_EXPLICIT_STRUCT_OPS


      #ifdef HAVE_STD_EH
      RelationshipTypeError *operator->() { return this; }
      RelationshipTypeError& operator*() { return *this; }
      operator RelationshipTypeError*() { return this; }
      #endif // HAVE_STD_EH

      void _throwit() const;
      const char *_repoid() const;
      void _encode( CORBA::DataEncoder &en ) const;
      void _encode_any( CORBA::Any &a ) const;
      CORBA::Exception *_clone() const;
      static RelationshipTypeError *_downcast( CORBA::Exception *ex );
      static const RelationshipTypeError *_downcast( const CORBA::Exception *ex );
    };

    #ifdef HAVE_STD_EH
    typedef RelationshipTypeError RelationshipTypeError_catch;
    #else
    typedef ExceptVar<RelationshipTypeError> RelationshipTypeError_var;
    typedef TVarOut<RelationshipTypeError> RelationshipTypeError_out;
    typedef RelationshipTypeError_var RelationshipTypeError_catch;
    #endif // HAVE_STD_EH

    struct CannotDestroyRelationship : public CORBA::UserException {
      #ifdef HAVE_EXPLICIT_STRUCT_OPS
      CannotDestroyRelationship();
      ~CannotDestroyRelationship();
      CannotDestroyRelationship( const CannotDestroyRelationship& s );
      CannotDestroyRelationship& operator=( const CannotDestroyRelationship& s );
      #endif //HAVE_EXPLICIT_STRUCT_OPS

      #ifndef HAVE_EXPLICIT_STRUCT_OPS
      CannotDestroyRelationship();
      #endif //HAVE_EXPLICIT_STRUCT_OPS
      CannotDestroyRelationship( const RelationshipHandles& _m0 );

      #ifdef HAVE_STD_EH
      CannotDestroyRelationship *operator->() { return this; }
      CannotDestroyRelationship& operator*() { return *this; }
      operator CannotDestroyRelationship*() { return this; }
      #endif // HAVE_STD_EH

      void _throwit() const;
      const char *_repoid() const;
      void _encode( CORBA::DataEncoder &en ) const;
      void _encode_any( CORBA::Any &a ) const;
      CORBA::Exception *_clone() const;
      static CannotDestroyRelationship *_downcast( CORBA::Exception *ex );
      static const CannotDestroyRelationship *_downcast( const CORBA::Exception *ex );
      RelationshipHandles offenders;
    };

    #ifdef HAVE_STD_EH
    typedef CannotDestroyRelationship CannotDestroyRelationship_catch;
    #else
    typedef ExceptVar<CannotDestroyRelationship> CannotDestroyRelationship_var;
    typedef TVarOut<CannotDestroyRelationship> CannotDestroyRelationship_out;
    typedef CannotDestroyRelationship_var CannotDestroyRelationship_catch;
    #endif // HAVE_STD_EH

    struct ParticipatingInRelationship : public CORBA::UserException {
      #ifdef HAVE_EXPLICIT_STRUCT_OPS
      ParticipatingInRelationship();
      ~ParticipatingInRelationship();
      ParticipatingInRelationship( const ParticipatingInRelationship& s );
      ParticipatingInRelationship& operator=( const ParticipatingInRelationship& s );
      #endif //HAVE_EXPLICIT_STRUCT_OPS

      #ifndef HAVE_EXPLICIT_STRUCT_OPS
      ParticipatingInRelationship();
      #endif //HAVE_EXPLICIT_STRUCT_OPS
      ParticipatingInRelationship( const RelationshipHandles& _m0 );

      #ifdef HAVE_STD_EH
      ParticipatingInRelationship *operator->() { return this; }
      ParticipatingInRelationship& operator*() { return *this; }
      operator ParticipatingInRelationship*() { return this; }
      #endif // HAVE_STD_EH

      void _throwit() const;
      const char *_repoid() const;
      void _encode( CORBA::DataEncoder &en ) const;
      void _encode_any( CORBA::Any &a ) const;
      CORBA::Exception *_clone() const;
      static ParticipatingInRelationship *_downcast( CORBA::Exception *ex );
      static const ParticipatingInRelationship *_downcast( const CORBA::Exception *ex );
      RelationshipHandles the_relationships;
    };

    #ifdef HAVE_STD_EH
    typedef ParticipatingInRelationship ParticipatingInRelationship_catch;
    #else
    typedef ExceptVar<ParticipatingInRelationship> ParticipatingInRelationship_var;
    typedef TVarOut<ParticipatingInRelationship> ParticipatingInRelationship_out;
    typedef ParticipatingInRelationship_var ParticipatingInRelationship_catch;
    #endif // HAVE_STD_EH

    virtual RelatedObject_ptr related_object() = 0;

    virtual RelatedObject_ptr get_other_related_object( const RelationshipHandle& rel, const char* target_name ) = 0;
    virtual Role_ptr get_other_role( const RelationshipHandle& rel, const char* target_name ) = 0;
    virtual void get_relationships( CORBA::ULong how_many, RelationshipHandles_out rels, RelationshipIterator_out iter ) = 0;
    virtual void destroy_relationships() = 0;
    virtual void destroy() = 0;
    virtual CORBA::Boolean check_minimum_cardinality() = 0;
    virtual void link( const RelationshipHandle& rel, const NamedRoles& named_roles ) = 0;
    virtual void unlink( const RelationshipHandle& rel ) = 0;

  protected:
    Role() {};
  private:
    Role( const Role& );
    void operator=( const Role& );
};

// Stub for interface Role
class Role_stub:
  virtual public Role
{
  public:
    virtual ~Role_stub();
    RelatedObject_ptr related_object();

    RelatedObject_ptr get_other_related_object( const RelationshipHandle& rel, const char* target_name );
    Role_ptr get_other_role( const RelationshipHandle& rel, const char* target_name );
    void get_relationships( CORBA::ULong how_many, RelationshipHandles_out rels, RelationshipIterator_out iter );
    void destroy_relationships();
    void destroy();
    CORBA::Boolean check_minimum_cardinality();
    void link( const RelationshipHandle& rel, const NamedRoles& named_roles );
    void unlink( const RelationshipHandle& rel );

  private:
    void operator=( const Role_stub& );
};

#ifndef MICO_CONF_NO_POA

class Role_stub_clp :
  virtual public Role_stub,
  virtual public PortableServer::StubBase
{
  public:
    Role_stub_clp (PortableServer::POA_ptr, CORBA::Object_ptr);
    virtual ~Role_stub_clp ();
    RelatedObject_ptr related_object();

    RelatedObject_ptr get_other_related_object( const RelationshipHandle& rel, const char* target_name );
    Role_ptr get_other_role( const RelationshipHandle& rel, const char* target_name );
    void get_relationships( CORBA::ULong how_many, RelationshipHandles_out rels, RelationshipIterator_out iter );
    void destroy_relationships();
    void destroy();
    CORBA::Boolean check_minimum_cardinality();
    void link( const RelationshipHandle& rel, const NamedRoles& named_roles );
    void unlink( const RelationshipHandle& rel );

  protected:
    Role_stub_clp ();
  private:
    void operator=( const Role_stub_clp & );
};

#endif // MICO_CONF_NO_POA


/*
 * Base class and common definitions for interface RelationshipIterator
 */

class RelationshipIterator : 
  virtual public CORBA::Object
{
  public:
    virtual ~RelationshipIterator();

    #ifdef HAVE_TYPEDEF_OVERLOAD
    typedef RelationshipIterator_ptr _ptr_type;
    typedef RelationshipIterator_var _var_type;
    #endif

    static RelationshipIterator_ptr _narrow( CORBA::Object_ptr obj );
    static RelationshipIterator_ptr _narrow( CORBA::AbstractBase_ptr obj );
    static RelationshipIterator_ptr _duplicate( RelationshipIterator_ptr _obj )
    {
      CORBA::Object::_duplicate (_obj);
      return _obj;
    }

    static RelationshipIterator_ptr _nil()
    {
      return 0;
    }

    virtual void *_narrow_helper( const char *repoid );

    virtual CORBA::Boolean next_one( RelationshipHandle_out rel ) = 0;
    virtual CORBA::Boolean next_n( CORBA::ULong how_many, RelationshipHandles_out rels ) = 0;
    virtual void destroy() = 0;

  protected:
    RelationshipIterator() {};
  private:
    RelationshipIterator( const RelationshipIterator& );
    void operator=( const RelationshipIterator& );
};

// Stub for interface RelationshipIterator
class RelationshipIterator_stub:
  virtual public RelationshipIterator
{
  public:
    virtual ~RelationshipIterator_stub();
    CORBA::Boolean next_one( RelationshipHandle_out rel );
    CORBA::Boolean next_n( CORBA::ULong how_many, RelationshipHandles_out rels );
    void destroy();

  private:
    void operator=( const RelationshipIterator_stub& );
};

#ifndef MICO_CONF_NO_POA

class RelationshipIterator_stub_clp :
  virtual public RelationshipIterator_stub,
  virtual public PortableServer::StubBase
{
  public:
    RelationshipIterator_stub_clp (PortableServer::POA_ptr, CORBA::Object_ptr);
    virtual ~RelationshipIterator_stub_clp ();
    CORBA::Boolean next_one( RelationshipHandle_out rel );
    CORBA::Boolean next_n( CORBA::ULong how_many, RelationshipHandles_out rels );
    void destroy();

  protected:
    RelationshipIterator_stub_clp ();
  private:
    void operator=( const RelationshipIterator_stub_clp & );
};

#endif // MICO_CONF_NO_POA

typedef StringSequenceTmpl<CORBA::String_var> RoleNames;
#ifdef _WINDOWS
static RoleNames _dummy_RoleNames;
#endif
typedef TSeqVar<StringSequenceTmpl<CORBA::String_var> > RoleNames_var;
typedef TSeqOut<StringSequenceTmpl<CORBA::String_var> > RoleNames_out;

struct NamedRole {
  #ifdef HAVE_TYPEDEF_OVERLOAD
  typedef NamedRole_var _var_type;
  #endif
  #ifdef HAVE_EXPLICIT_STRUCT_OPS
  NamedRole();
  ~NamedRole();
  NamedRole( const NamedRole& s );
  NamedRole& operator=( const NamedRole& s );
  #endif //HAVE_EXPLICIT_STRUCT_OPS

  RoleName_var name;
  Role_var aRole;
};

}


#ifndef MICO_CONF_NO_POA



namespace POA_CosRelationships {


class RoleFactory : virtual public PortableServer::StaticImplementation
{
  public:
    virtual ~RoleFactory ();
    CosRelationships::RoleFactory_ptr _this ();
    bool dispatch (CORBA::StaticServerRequest_ptr);
    virtual void invoke (CORBA::StaticServerRequest_ptr);
    virtual CORBA::Boolean _is_a (const char *);
    virtual CORBA::InterfaceDef_ptr _get_interface ();
    virtual CORBA::RepositoryId _primary_interface (const PortableServer::ObjectId &, PortableServer::POA_ptr);

    virtual void * _narrow_helper (const char *);
    static RoleFactory * _narrow (PortableServer::Servant);
    virtual CORBA::Object_ptr _make_stub (PortableServer::POA_ptr, CORBA::Object_ptr);

    virtual CORBA::InterfaceDef_ptr role_type() = 0;
    virtual CORBA::ULong max_cardinality() = 0;
    virtual CORBA::ULong min_cardinality() = 0;
    virtual CosRelationships::InterfaceDefs* related_object_types() = 0;

    virtual CosRelationships::Role_ptr create_role( CORBA::Object_ptr related_object ) = 0;

  protected:
    RoleFactory () {};

  private:
    RoleFactory (const RoleFactory &);
    void operator= (const RoleFactory &);
};

class RelationshipFactory : virtual public PortableServer::StaticImplementation
{
  public:
    virtual ~RelationshipFactory ();
    CosRelationships::RelationshipFactory_ptr _this ();
    bool dispatch (CORBA::StaticServerRequest_ptr);
    virtual void invoke (CORBA::StaticServerRequest_ptr);
    virtual CORBA::Boolean _is_a (const char *);
    virtual CORBA::InterfaceDef_ptr _get_interface ();
    virtual CORBA::RepositoryId _primary_interface (const PortableServer::ObjectId &, PortableServer::POA_ptr);

    virtual void * _narrow_helper (const char *);
    static RelationshipFactory * _narrow (PortableServer::Servant);
    virtual CORBA::Object_ptr _make_stub (PortableServer::POA_ptr, CORBA::Object_ptr);

    virtual CORBA::InterfaceDef_ptr relationship_type() = 0;
    virtual CORBA::UShort degree() = 0;
    virtual CosRelationships::RelationshipFactory::NamedRoleTypes* named_role_types() = 0;

    virtual CosRelationships::Relationship_ptr create( const CosRelationships::NamedRoles& named_roles ) = 0;

  protected:
    RelationshipFactory () {};

  private:
    RelationshipFactory (const RelationshipFactory &);
    void operator= (const RelationshipFactory &);
};

class Relationship : 
  virtual public POA_CosObjectIdentity::IdentifiableObject
{
  public:
    virtual ~Relationship ();
    CosRelationships::Relationship_ptr _this ();
    bool dispatch (CORBA::StaticServerRequest_ptr);
    virtual void invoke (CORBA::StaticServerRequest_ptr);
    virtual CORBA::Boolean _is_a (const char *);
    virtual CORBA::InterfaceDef_ptr _get_interface ();
    virtual CORBA::RepositoryId _primary_interface (const PortableServer::ObjectId &, PortableServer::POA_ptr);

    virtual void * _narrow_helper (const char *);
    static Relationship * _narrow (PortableServer::Servant);
    virtual CORBA::Object_ptr _make_stub (PortableServer::POA_ptr, CORBA::Object_ptr);

    virtual CosRelationships::NamedRoles* named_roles() = 0;

    virtual void destroy() = 0;

  protected:
    Relationship () {};

  private:
    Relationship (const Relationship &);
    void operator= (const Relationship &);
};

class Role : virtual public PortableServer::StaticImplementation
{
  public:
    virtual ~Role ();
    CosRelationships::Role_ptr _this ();
    bool dispatch (CORBA::StaticServerRequest_ptr);
    virtual void invoke (CORBA::StaticServerRequest_ptr);
    virtual CORBA::Boolean _is_a (const char *);
    virtual CORBA::InterfaceDef_ptr _get_interface ();
    virtual CORBA::RepositoryId _primary_interface (const PortableServer::ObjectId &, PortableServer::POA_ptr);

    virtual void * _narrow_helper (const char *);
    static Role * _narrow (PortableServer::Servant);
    virtual CORBA::Object_ptr _make_stub (PortableServer::POA_ptr, CORBA::Object_ptr);

    virtual CosRelationships::RelatedObject_ptr related_object() = 0;

    virtual CosRelationships::RelatedObject_ptr get_other_related_object( const CosRelationships::RelationshipHandle& rel, const char* target_name ) = 0;
    virtual CosRelationships::Role_ptr get_other_role( const CosRelationships::RelationshipHandle& rel, const char* target_name ) = 0;
    virtual void get_relationships( CORBA::ULong how_many, CosRelationships::RelationshipHandles_out rels, CosRelationships::RelationshipIterator_out iter ) = 0;
    virtual void destroy_relationships() = 0;
    virtual void destroy() = 0;
    virtual CORBA::Boolean check_minimum_cardinality() = 0;
    virtual void link( const CosRelationships::RelationshipHandle& rel, const CosRelationships::NamedRoles& named_roles ) = 0;
    virtual void unlink( const CosRelationships::RelationshipHandle& rel ) = 0;

  protected:
    Role () {};

  private:
    Role (const Role &);
    void operator= (const Role &);
};

class RelationshipIterator : virtual public PortableServer::StaticImplementation
{
  public:
    virtual ~RelationshipIterator ();
    CosRelationships::RelationshipIterator_ptr _this ();
    bool dispatch (CORBA::StaticServerRequest_ptr);
    virtual void invoke (CORBA::StaticServerRequest_ptr);
    virtual CORBA::Boolean _is_a (const char *);
    virtual CORBA::InterfaceDef_ptr _get_interface ();
    virtual CORBA::RepositoryId _primary_interface (const PortableServer::ObjectId &, PortableServer::POA_ptr);

    virtual void * _narrow_helper (const char *);
    static RelationshipIterator * _narrow (PortableServer::Servant);
    virtual CORBA::Object_ptr _make_stub (PortableServer::POA_ptr, CORBA::Object_ptr);

    virtual CORBA::Boolean next_one( CosRelationships::RelationshipHandle_out rel ) = 0;
    virtual CORBA::Boolean next_n( CORBA::ULong how_many, CosRelationships::RelationshipHandles_out rels ) = 0;
    virtual void destroy() = 0;

  protected:
    RelationshipIterator () {};

  private:
    RelationshipIterator (const RelationshipIterator &);
    void operator= (const RelationshipIterator &);
};

}


#endif // MICO_CONF_NO_POA

extern CORBA::StaticTypeInfo *_marshaller_CosRelationships_RoleFactory_NilRelatedObject;

extern CORBA::StaticTypeInfo *_marshaller_CosRelationships_RoleFactory_RelatedObjectTypeError;

extern CORBA::StaticTypeInfo *_marshaller_CosRelationships_RoleFactory;

extern CORBA::StaticTypeInfo *_marshaller_CosRelationships_RelationshipFactory_NamedRoleType;

extern CORBA::StaticTypeInfo *_marshaller_CosRelationships_RelationshipFactory_RoleTypeError;

extern CORBA::StaticTypeInfo *_marshaller_CosRelationships_RelationshipFactory_MaxCardinalityExceeded;

extern CORBA::StaticTypeInfo *_marshaller_CosRelationships_RelationshipFactory_DegreeError;

extern CORBA::StaticTypeInfo *_marshaller_CosRelationships_RelationshipFactory_DuplicateRoleName;

extern CORBA::StaticTypeInfo *_marshaller_CosRelationships_RelationshipFactory_UnknownRoleName;

extern CORBA::StaticTypeInfo *_marshaller_CosRelationships_RelationshipFactory;

extern CORBA::StaticTypeInfo *_marshaller_CosRelationships_Relationship_CannotUnlink;

extern CORBA::StaticTypeInfo *_marshaller_CosRelationships_Relationship;

extern CORBA::StaticTypeInfo *_marshaller_CosRelationships_RelationshipHandle;

extern CORBA::StaticTypeInfo *_marshaller_CosRelationships_Role_UnknownRoleName;

extern CORBA::StaticTypeInfo *_marshaller_CosRelationships_Role_UnknownRelationship;

extern CORBA::StaticTypeInfo *_marshaller_CosRelationships_Role_RelationshipTypeError;

extern CORBA::StaticTypeInfo *_marshaller_CosRelationships_Role_CannotDestroyRelationship;

extern CORBA::StaticTypeInfo *_marshaller_CosRelationships_Role_ParticipatingInRelationship;

extern CORBA::StaticTypeInfo *_marshaller_CosRelationships_Role;

extern CORBA::StaticTypeInfo *_marshaller_CosRelationships_RelationshipIterator;

extern CORBA::StaticTypeInfo *_marshaller_CosRelationships_NamedRole;

extern CORBA::StaticTypeInfo *_marshaller__seq_CosRelationships_RelationshipFactory_NamedRoleType;

extern CORBA::StaticTypeInfo *_marshaller__seq_CosRelationships_NamedRole;

extern CORBA::StaticTypeInfo *_marshaller__seq_CosRelationships_Role;

extern CORBA::StaticTypeInfo *_marshaller__seq_CosRelationships_RelationshipHandle;

#endif
