/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger.jpda;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;

public abstract class JPDAStep {
    private int size;
    private int depth;
    private boolean hidden;
    protected JPDADebugger debugger;
    private PropertyChangeSupport pcs;
    public static final int STEP_INTO = 1;
    public static final int STEP_OVER = 2;
    public static final int STEP_OUT = 3;
    public static final int STEP_LINE = -2;
    public static final int STEP_MIN = -1;
    public static final String PROP_STATE_EXEC = "exec";

    public JPDAStep(JPDADebugger debugger, int size, int depth) {
        this.size = size;
        this.depth = depth;
        this.debugger = debugger;
        this.hidden = false;
        this.pcs = new PropertyChangeSupport(this);
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public boolean getHidden() {
        return this.hidden;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public int getDepth() {
        return this.depth;
    }

    public abstract void addStep(JPDAThread var1);

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(propertyName, l);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(propertyName, l);
    }

    protected void firePropertyChange(String name, Object o, Object n) {
        this.pcs.firePropertyChange(name, o, n);
    }
}

