/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.clientproject.ui.wizards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.j2ee.clientproject.ui.FoldersListSettings;
import org.netbeans.modules.j2ee.clientproject.ui.wizards.J2eeVersionWarningPanel;
import org.netbeans.modules.j2ee.clientproject.ui.wizards.NewAppClientProjectWizardIterator;
import org.netbeans.modules.j2ee.clientproject.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.j2ee.clientproject.ui.wizards.SettingsPanel;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModuleContainer;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerManager;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class PanelOptionsVisual
extends SettingsPanel
implements PropertyChangeListener {
    private final PanelConfigureProject panel;
    private boolean valid;
    private List<Project> earProjects;
    private final DefaultComboBoxModel serversModel = new DefaultComboBoxModel();
    private J2eeVersionWarningPanel warningPanel;
    private static final String J2EE_SPEC_15_LABEL = NbBundle.getMessage(PanelOptionsVisual.class, (String)"J2EESpecLevel_15");
    private static final String J2EE_SPEC_14_LABEL = NbBundle.getMessage(PanelOptionsVisual.class, (String)"J2EESpecLevel_14");
    private JComboBox addToAppComboBox;
    private JLabel addToAppLabel;
    private JComboBox j2eeSpecComboBox;
    private JLabel j2eeSpecLabel;
    private JLabel mainClassLabel;
    private JTextField mainClassTextField;
    private JButton manageServersButton;
    private JComboBox serverInstanceComboBox;
    private JLabel serverInstanceLabel;
    private JCheckBox setAsMainCheckBox;
    private JPanel warningPlaceHolderPanel;

    public PanelOptionsVisual(PanelConfigureProject panel) {
        this.initComponents();
        this.setJ2eeVersionWarningPanel();
        this.initEnterpriseApplications();
        this.panel = panel;
        this.initServers(FoldersListSettings.getDefault().getLastUsedServer());
        if (this.j2eeSpecComboBox.getModel().getSize() > 0) {
            this.j2eeSpecComboBox.setSelectedIndex(0);
        }
        this.mainClassTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                PanelOptionsVisual.this.mainClassChanged();
            }

            public void removeUpdate(DocumentEvent e) {
                PanelOptionsVisual.this.mainClassChanged();
            }

            public void changedUpdate(DocumentEvent e) {
                PanelOptionsVisual.this.mainClassChanged();
            }
        });
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("projectName".equals(event.getPropertyName())) {
            String newProjectName = NewAppClientProjectWizardIterator.getPackageName((String)event.getNewValue());
            if (!Utilities.isJavaIdentifier((String)newProjectName)) {
                newProjectName = NbBundle.getMessage(PanelOptionsVisual.class, (String)"TXT_PackageNameSuffix", (Object)newProjectName);
            }
            this.mainClassTextField.setText(MessageFormat.format(NbBundle.getMessage(PanelOptionsVisual.class, (String)"TXT_ClassName"), newProjectName));
        }
    }

    private void initComponents() {
        this.setAsMainCheckBox = new JCheckBox();
        this.mainClassTextField = new JTextField();
        this.addToAppLabel = new JLabel();
        this.serverInstanceLabel = new JLabel();
        this.serverInstanceComboBox = new JComboBox();
        this.addToAppComboBox = new JComboBox();
        this.j2eeSpecComboBox = new JComboBox();
        this.j2eeSpecLabel = new JLabel();
        this.warningPlaceHolderPanel = new JPanel();
        this.mainClassLabel = new JLabel();
        this.manageServersButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleName(null);
        this.getAccessibleContext().setAccessibleDescription(null);
        this.setAsMainCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.setAsMainCheckBox, (String)NbBundle.getBundle(PanelOptionsVisual.class).getString("LBL_setAsMainCheckBox"));
        this.setAsMainCheckBox.setMargin(new Insets(0, 0, 0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.setAsMainCheckBox, gridBagConstraints);
        this.setAsMainCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getBundle(PanelOptionsVisual.class).getString("ACSN_setAsMainCheckBox"));
        this.setAsMainCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PanelOptionsVisual.class).getString("ACSD_setAsMainCheckBox"));
        this.mainClassTextField.setText("com.myapp.Main");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.mainClassTextField, gridBagConstraints);
        this.mainClassTextField.getAccessibleContext().setAccessibleName(NbBundle.getBundle(PanelOptionsVisual.class).getString("ASCN_mainClassTextFiled"));
        this.mainClassTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PanelOptionsVisual.class).getString("ASCD_mainClassTextFiled"));
        this.addToAppLabel.setLabelFor(this.addToAppComboBox);
        Mnemonics.setLocalizedText((JLabel)this.addToAppLabel, (String)ResourceBundle.getBundle("org/netbeans/modules/j2ee/clientproject/ui/wizards/Bundle").getString("LBL_NWP1_AddToEApp_CheckBox"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.add((Component)this.addToAppLabel, gridBagConstraints);
        this.serverInstanceLabel.setLabelFor(this.serverInstanceComboBox);
        Mnemonics.setLocalizedText((JLabel)this.serverInstanceLabel, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_NWP1_Server_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.add((Component)this.serverInstanceLabel, gridBagConstraints);
        this.serverInstanceComboBox.setModel(this.serversModel);
        this.serverInstanceComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelOptionsVisual.this.serverInstanceComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.serverInstanceComboBox, gridBagConstraints);
        this.serverInstanceComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACS_LBL_IW_SelectServerInstance_A11YDesc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.addToAppComboBox, gridBagConstraints);
        this.j2eeSpecComboBox.setPrototypeDisplayValue("MMMMMMMMM");
        this.j2eeSpecComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelOptionsVisual.this.j2eeSpecComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.j2eeSpecComboBox, gridBagConstraints);
        this.j2eeSpecComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACS_LBL_IW_SelectJ2EEVersion_A11YDesc"));
        this.j2eeSpecLabel.setLabelFor(this.j2eeSpecComboBox);
        Mnemonics.setLocalizedText((JLabel)this.j2eeSpecLabel, (String)NbBundle.getBundle((String)"org/netbeans/modules/j2ee/clientproject/ui/wizards/Bundle").getString("LBL_NWP1_J2EESpecLevel_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.add((Component)this.j2eeSpecLabel, gridBagConstraints);
        this.warningPlaceHolderPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.warningPlaceHolderPanel, gridBagConstraints);
        this.mainClassLabel.setLabelFor(this.mainClassTextField);
        Mnemonics.setLocalizedText((JLabel)this.mainClassLabel, (String)NbBundle.getBundle(PanelOptionsVisual.class).getString("LBL_NWP1_MainClass_Label"));
        this.mainClassLabel.setAlignmentX(0.5f);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.add((Component)this.mainClassLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.manageServersButton, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_ManageServers"));
        this.manageServersButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelOptionsVisual.this.manageServersButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 6, 11, 0);
        this.add((Component)this.manageServersButton, gridBagConstraints);
        this.manageServersButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ASCN_ManageServers"));
        this.manageServersButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ASCD_ManageServers"));
    }

    private void manageServersButtonActionPerformed(ActionEvent evt) {
        ServerInstanceWrapper serverInstanceWrapper = (ServerInstanceWrapper)this.serversModel.getSelectedItem();
        String lastSelectedServerInstanceID = null;
        if (serverInstanceWrapper != null) {
            lastSelectedServerInstanceID = serverInstanceWrapper.getServerInstanceID();
        }
        ServerManager.showCustomizer(lastSelectedServerInstanceID);
        String lastSelectedJ2eeSpecLevel = (String)this.j2eeSpecComboBox.getSelectedItem();
        this.initServers(lastSelectedServerInstanceID);
        if (lastSelectedJ2eeSpecLevel != null) {
            this.j2eeSpecComboBox.setSelectedItem(lastSelectedJ2eeSpecLevel);
        }
    }

    private void serverInstanceComboBoxActionPerformed(ActionEvent evt) {
        String prevSelectedItem = (String)this.j2eeSpecComboBox.getSelectedItem();
        ServerInstanceWrapper serverInstanceWrapper = (ServerInstanceWrapper)this.serversModel.getSelectedItem();
        if (serverInstanceWrapper != null) {
            J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(serverInstanceWrapper.getServerInstanceID());
            Set supportedVersions = j2eePlatform.getSupportedSpecVersions(J2eeModule.CLIENT);
            this.j2eeSpecComboBox.removeAllItems();
            if (supportedVersions.contains("1.5")) {
                this.j2eeSpecComboBox.addItem(J2EE_SPEC_15_LABEL);
            }
            if (supportedVersions.contains("1.4")) {
                this.j2eeSpecComboBox.addItem(J2EE_SPEC_14_LABEL);
            }
            if (prevSelectedItem != null) {
                this.j2eeSpecComboBox.setSelectedItem(prevSelectedItem);
            }
        } else {
            this.j2eeSpecComboBox.removeAllItems();
        }
        this.panel.fireChangeEvent();
    }

    private void j2eeSpecComboBoxActionPerformed(ActionEvent evt) {
        this.setJ2eeVersionWarningPanel();
    }

    boolean valid(WizardDescriptor settings) {
        if (this.getSelectedServer() == null) {
            String errMsg = NbBundle.getMessage(PanelOptionsVisual.class, (String)"MSG_NoServer");
            settings.putProperty("WizardPanel_errorMessage", (Object)errMsg);
            return false;
        }
        if (!this.valid) {
            settings.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelOptionsVisual.class, (String)"ERROR_IllegalMainClassName"));
            return this.valid;
        }
        return true;
    }

    void read(WizardDescriptor d) {
    }

    void validate(WizardDescriptor d) throws WizardValidationException {
    }

    void store(WizardDescriptor d) {
        d.putProperty("mainClass", (Object)this.mainClassTextField.getText().trim());
        d.putProperty("setAsMain", (Object)(this.setAsMainCheckBox.isSelected() ? Boolean.TRUE : Boolean.FALSE));
        d.putProperty("serverInstanceID", (Object)this.getSelectedServer());
        d.putProperty("j2eeLevel", (Object)this.getSelectedJ2eeSpec());
        d.putProperty("earApplication", (Object)this.getSelectedEarApplication());
        if (this.warningPanel != null && this.warningPanel.getWarningType() != null && this.warningPanel.getDowngradeAllowed()) {
            d.putProperty("setJavaPlatform", (Object)this.warningPanel.getSuggestedJavaPlatformName());
            String j2ee = this.getSelectedJ2eeSpec();
            if (j2ee != null) {
                String warningType = J2eeVersionWarningPanel.findWarningType(j2ee);
                FoldersListSettings fls = FoldersListSettings.getDefault();
                String srcLevel = "1.6";
                if ((warningType.equals("warnSetSourceLevel14") || warningType.equals("warnSetJdk14")) && fls.isAgreedSetSourceLevel14()) {
                    srcLevel = "1.4";
                } else if ((warningType.equals("warnSetSourceLevel15") || warningType.equals("warnSetJdk15")) && fls.isAgreedSetSourceLevel15()) {
                    srcLevel = "1.5";
                }
                d.putProperty("setSourceLevel", (Object)srcLevel);
            }
        } else {
            d.putProperty("setSourceLevel", null);
        }
    }

    private void mainClassChanged() {
        boolean valid;
        String mainClassName = this.mainClassTextField.getText().trim();
        StringTokenizer tk = new StringTokenizer(mainClassName, ".");
        boolean bl = valid = tk.countTokens() > 0;
        while (tk.hasMoreTokens()) {
            String token = tk.nextToken();
            if (token.length() != 0 && Utilities.isJavaIdentifier((String)token)) continue;
            valid = false;
            break;
        }
        this.valid = valid;
        this.panel.fireChangeEvent();
    }

    private void setJ2eeVersionWarningPanel() {
        String j2ee = this.getSelectedJ2eeSpec();
        if (j2ee == null) {
            return;
        }
        String warningType = J2eeVersionWarningPanel.findWarningType(j2ee);
        if (warningType == null && this.warningPanel == null) {
            return;
        }
        if (this.warningPanel == null) {
            this.warningPanel = new J2eeVersionWarningPanel(warningType);
            this.warningPlaceHolderPanel.add((Component)this.warningPanel, "Center");
        }
        this.warningPanel.setWarningType(warningType);
    }

    private void initServers(String selectedServerInstanceID) {
        this.serversModel.removeAllElements();
        TreeSet<ServerInstanceWrapper> servers = new TreeSet<ServerInstanceWrapper>();
        ServerInstanceWrapper selectedItem = null;
        boolean sjasFound = false;
        for (String serverInstanceID : Deployment.getDefault().getServerInstanceIDs()) {
            String displayName = Deployment.getDefault().getServerInstanceDisplayName(serverInstanceID);
            J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(serverInstanceID);
            if (displayName == null || j2eePlatform == null || !j2eePlatform.getSupportedModuleTypes().contains(J2eeModule.CLIENT)) continue;
            ServerInstanceWrapper serverWrapper = new ServerInstanceWrapper(serverInstanceID, displayName);
            if (selectedItem == null || !sjasFound) {
                if (selectedServerInstanceID != null) {
                    if (selectedServerInstanceID.equals(serverInstanceID)) {
                        selectedItem = serverWrapper;
                    }
                } else {
                    String shortName = Deployment.getDefault().getServerID(serverInstanceID);
                    if ("J2EE".equals(shortName)) {
                        selectedItem = serverWrapper;
                        sjasFound = true;
                    } else if ("JBoss4".equals(shortName)) {
                        selectedItem = serverWrapper;
                    }
                }
            }
            servers.add(serverWrapper);
        }
        for (ServerInstanceWrapper item : servers) {
            this.serversModel.addElement(item);
        }
        if (selectedItem != null) {
            this.serversModel.setSelectedItem(selectedItem);
        } else if (this.serversModel.getSize() > 0) {
            this.serversModel.setSelectedItem(this.serversModel.getElementAt(0));
        }
    }

    private void initEnterpriseApplications() {
        this.addToAppComboBox.addItem(NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_NWP1_AddToEApp_None"));
        this.addToAppComboBox.setSelectedIndex(0);
        Project[] allProjects = OpenProjects.getDefault().getOpenProjects();
        this.earProjects = new ArrayList<Project>();
        for (int i = 0; i < allProjects.length; ++i) {
            J2eeModuleContainer container = (J2eeModuleContainer)allProjects[i].getLookup().lookup(J2eeModuleContainer.class);
            ProjectInformation projectInfo = ProjectUtils.getInformation((Project)allProjects[i]);
            if (container == null) continue;
            this.earProjects.add(projectInfo.getProject());
            this.addToAppComboBox.addItem(projectInfo.getDisplayName());
        }
        if (this.earProjects.size() <= 0) {
            this.addToAppComboBox.setEnabled(false);
        }
    }

    private String getSelectedJ2eeSpec() {
        Object item = this.j2eeSpecComboBox.getSelectedItem();
        return item == null ? null : (item.equals(J2EE_SPEC_14_LABEL) ? "1.4" : (item.equals(J2EE_SPEC_15_LABEL) ? "1.5" : "1.3"));
    }

    private String getSelectedServer() {
        ServerInstanceWrapper serverInstanceWrapper = (ServerInstanceWrapper)this.serversModel.getSelectedItem();
        if (serverInstanceWrapper == null) {
            return null;
        }
        return serverInstanceWrapper.getServerInstanceID();
    }

    private Project getSelectedEarApplication() {
        int idx = this.addToAppComboBox.getSelectedIndex();
        return idx <= 0 ? null : this.earProjects.get(idx - 1);
    }

    private static class ServerInstanceWrapper
    implements Comparable {
        private final String serverInstanceID;
        private final String displayName;

        ServerInstanceWrapper(String serverInstanceID, String displayName) {
            this.serverInstanceID = serverInstanceID;
            this.displayName = displayName;
        }

        public String getServerInstanceID() {
            return this.serverInstanceID;
        }

        public String toString() {
            return this.displayName;
        }

        public int compareTo(Object o) {
            return this.toString().compareTo(o.toString());
        }
    }
}

