/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsps.parserapi;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLClassLoader;
import java.util.Map;
import org.netbeans.modules.web.jspparser.ContextUtil;
import org.netbeans.modules.web.jsps.parserapi.Node;
import org.netbeans.modules.web.jsps.parserapi.PageInfo;
import org.openide.filesystems.FileObject;

public interface JspParserAPI {
    public static final int ERROR_IGNORE = 1;
    public static final int ERROR_REPORT_ANY = 2;
    public static final int ERROR_REPORT_ACCURATE = 3;
    public static final String TAG_MIME_TYPE = "text/x-tag";

    public JspOpenInfo getJspOpenInfo(FileObject var1, WebModule var2, boolean var3);

    public ParseResult analyzePage(FileObject var1, WebModule var2, int var3);

    public URLClassLoader getModuleClassLoader(WebModule var1);

    public Map getTaglibMap(WebModule var1) throws IOException;

    public static class ErrorDescriptor {
        protected FileObject wmRoot;
        protected FileObject source;
        protected int line;
        protected int column;
        protected String errorMessage;
        protected String referenceText;

        public ErrorDescriptor(FileObject wmRoot, FileObject source, int line, int column, String errorMessage, String referenceText) {
            this.wmRoot = wmRoot;
            this.source = source;
            this.line = line;
            this.column = column;
            this.errorMessage = errorMessage;
            this.referenceText = referenceText;
        }

        public FileObject getSource() {
            return this.source;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public String getReferenceText() {
            return this.referenceText;
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            result.append("ERROR in ").append(this.getSourcePath()).append(" at [").append(this.getLine()).append(", ").append(this.getColumn()).append("] ").append(this.getErrorMessage()).append("\n").append(this.getReferenceText()).append("\n");
            return result.toString();
        }

        private String getSourcePath() {
            if (this.wmRoot == null) {
                return this.getSource().getNameExt();
            }
            return ContextUtil.findRelativeContextPath(this.wmRoot, this.getSource());
        }
    }

    public static class JspOpenInfo {
        private boolean isXml;
        private String encoding;

        public JspOpenInfo(boolean isXml, String encoding) {
            this.isXml = isXml;
            this.encoding = encoding;
        }

        public boolean isXmlSyntax() {
            return this.isXml;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public boolean equals(Object o) {
            if (o instanceof JspOpenInfo) {
                JspOpenInfo openInfo2 = (JspOpenInfo)o;
                return this.getEncoding().equals(openInfo2.getEncoding()) && this.isXmlSyntax() == openInfo2.isXmlSyntax();
            }
            return false;
        }

        public int hashCode() {
            return this.encoding.hashCode() + (this.isXml ? 1 : 0);
        }

        public String toString() {
            return super.toString() + " [isXml: " + this.isXml + ", encoding: " + this.encoding + "]";
        }
    }

    public static class ParseResult {
        protected PageInfo pageInfo;
        protected Node.Nodes nodes;
        protected ErrorDescriptor[] errors;
        protected boolean parsedOK;

        public ParseResult(PageInfo pageInfo, Node.Nodes nodes) {
            this(pageInfo, nodes, null);
        }

        public ParseResult(ErrorDescriptor[] errors) {
            this(null, null, errors);
        }

        public ParseResult(PageInfo pageInfo, Node.Nodes nodes, ErrorDescriptor[] errors) {
            this.pageInfo = pageInfo;
            this.nodes = nodes;
            this.errors = errors;
            this.parsedOK = errors == null || errors.length == 0;
        }

        public boolean isParsingSuccess() {
            return this.parsedOK;
        }

        public PageInfo getPageInfo() {
            return this.pageInfo;
        }

        public Node.Nodes getNodes() {
            return this.nodes;
        }

        public ErrorDescriptor[] getErrors() {
            if (!this.parsedOK) {
                return this.errors;
            }
            throw new IllegalStateException();
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            result.append("--------- JspParserAPI.parseResult(), success: ");
            result.append(this.isParsingSuccess());
            result.append("\n");
            if (this.pageInfo != null) {
                result.append(" ---- PAGEINFO\n");
                result.append(this.pageInfo.toString());
            }
            if (this.nodes != null) {
                result.append("\n ---- NODES\n");
                result.append(this.nodes.toString());
                result.append("\n");
            }
            if (!this.isParsingSuccess()) {
                result.append("\n ---- ERRORS\n");
                for (int i = 0; i < this.errors.length; ++i) {
                    result.append(this.errors[i].toString());
                }
            }
            return result.toString();
        }
    }

    public static abstract class WebModule {
        public static final String PROP_LIBRARIES = "libraries";
        public static final String PROP_PACKAGE_ROOTS = "package_roots";

        public abstract FileObject getDocumentBase();

        public abstract File[] getExtraClasspathEntries();

        public abstract InputStream getEditorInputStream(FileObject var1);

        public abstract void addPropertyChangeListener(PropertyChangeListener var1);

        public abstract void removePropertyChangeListener(PropertyChangeListener var1);
    }
}

