/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.bookmarks;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.lib.editor.bookmarks.BookmarksApiPackageAccessor;
import org.netbeans.lib.editor.bookmarks.api.BookmarkList;
import org.netbeans.lib.editor.bookmarks.spi.BookmarkManager;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

class DocumentUnmodifiedListener
implements PropertyChangeListener {
    private static final Map eco2listener = new WeakHashMap();
    private static final DocumentUnmodifiedListener INSTANCE = new DocumentUnmodifiedListener();

    public static void init(Document doc) {
        FileObject fo = NbEditorUtilities.getFileObject((Document)doc);
        if (fo != null) {
            EditorCookie.Observable eco;
            try {
                DataObject dob = DataObject.find((FileObject)fo);
                eco = (EditorCookie.Observable)dob.getCookie(EditorCookie.Observable.class);
            }
            catch (DataObjectNotFoundException e) {
                eco = null;
            }
            if (eco != null && eco2listener.get(eco) == null) {
                eco.addPropertyChangeListener((PropertyChangeListener)INSTANCE);
                eco2listener.put(eco, INSTANCE);
            }
        }
    }

    private DocumentUnmodifiedListener() {
    }

    public void propertyChange(PropertyChangeEvent evt) {
        EditorCookie.Observable eco;
        StyledDocument doc;
        if ("modified".equals(evt.getPropertyName()) && !Boolean.TRUE.equals(evt.getNewValue()) && (doc = (eco = (EditorCookie.Observable)evt.getSource()).getDocument()) != null) {
            BookmarkList bookmarkList = BookmarkList.get(doc);
            BookmarkManager manager = BookmarksApiPackageAccessor.get().getBookmarkManager(bookmarkList);
            manager.saveBookmarks();
        }
    }
}

