/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.api.jaxws.project.config;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.metadata.JAXWSMetadataProvider;
import org.netbeans.modules.j2ee.metadata.MetadataUnit;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.ClientAlreadyExistsExeption;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.api.jaxws.project.config.ServiceAlreadyExistsExeption;
import org.netbeans.modules.websvc.jaxwsmodel.project.metadata.JAXWSNNMergerProvider;
import org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Clients;
import org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.JaxWs;
import org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Services;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;

public final class JaxWsModel {
    private JaxWs jaxws;
    private FileObject fo;
    private boolean nninitialized = false;
    private Object initLock = new Object();
    private List serviceListeners;

    JaxWsModel(JaxWs jaxws) {
        this(jaxws, null);
    }

    JaxWsModel(JaxWs jaxws, FileObject fo) {
        this.jaxws = jaxws;
        this.fo = fo;
        this.serviceListeners = new ArrayList();
    }

    public Service[] getServices() {
        this.initNNProvider();
        Services services = this.jaxws.getServices();
        if (services == null) {
            return new Service[0];
        }
        org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Service[] org = services.getService();
        if (org == null) {
            return new Service[0];
        }
        Service[] newServices = new Service[org.length];
        for (int i = 0; i < org.length; ++i) {
            newServices[i] = new Service(org[i]);
        }
        return newServices;
    }

    public void setJsr109(Boolean jsr109) {
        this.jaxws.setJsr109(jsr109);
    }

    public Boolean getJsr109() {
        return this.jaxws.getJsr109();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initNNProvider() {
        Object object = this.initLock;
        synchronized (object) {
            if (!this.nninitialized && this.fo != null) {
                try {
                    Project project = FileOwnerQuery.getOwner((FileObject)this.fo);
                    MetadataUnit mu = JaxWsModel.findJAXWSMetadata(project);
                    if (mu != null) {
                        JAXWSNNMergerProvider.getDefault().initNNMerger(this, mu);
                    }
                    this.nninitialized = true;
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
        }
    }

    public Service findServiceByName(String name) {
        org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Service service = this.findService(name);
        return service == null ? null : new Service(service);
    }

    public Service findServiceByImplementationClass(String wsClassName) {
        org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Service service = this._findServiceByClass(wsClassName);
        return service == null ? null : new Service(service);
    }

    private org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Service findService(String name) {
        Services services = this.jaxws.getServices();
        if (services == null) {
            return null;
        }
        org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Service[] org = services.getService();
        if (org == null) {
            return null;
        }
        for (int i = 0; i < org.length; ++i) {
            if (!name.equals(org[i].getName())) continue;
            return org[i];
        }
        return null;
    }

    private org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Service _findServiceByClass(String wsClassName) {
        Services services = this.jaxws.getServices();
        if (services == null) {
            return null;
        }
        org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Service[] org = services.getService();
        if (org == null) {
            return null;
        }
        for (int i = 0; i < org.length; ++i) {
            if (!wsClassName.equals(org[i].getImplementationClass())) continue;
            return org[i];
        }
        return null;
    }

    public boolean removeService(String name) {
        org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Service service = this.findService(name);
        if (name == null) {
            return false;
        }
        this.jaxws.getServices().removeService(service);
        this.fireServiceRemoved(name);
        return true;
    }

    public boolean removeServiceByClassName(String webserviceClassName) {
        org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Service service;
        if (webserviceClassName != null && (service = this._findServiceByClass(webserviceClassName)) != null) {
            this.fireServiceRemoved(service.getName());
            this.jaxws.getServices().removeService(service);
            return true;
        }
        return false;
    }

    public Service addService(String name, String implementationClass) throws ServiceAlreadyExistsExeption {
        if (this.findService(name) != null) {
            throw new ServiceAlreadyExistsExeption(name);
        }
        org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Service service = this.jaxws.getServices().newService();
        service.setName(name);
        service.setImplementationClass(implementationClass);
        this.jaxws.getServices().addService(service);
        this.fireServiceAdded(name, implementationClass);
        return new Service(service);
    }

    public Service addService(String name, String implementationClass, String wsdlUrl, String serviceName, String portName, String packageName) throws ServiceAlreadyExistsExeption {
        if (this.findService(name) != null) {
            throw new ServiceAlreadyExistsExeption(name);
        }
        org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Service service = this.jaxws.getServices().newService();
        service.setName(name);
        service.setImplementationClass(implementationClass);
        service.setWsdlUrl(wsdlUrl);
        service.setServiceName(serviceName);
        service.setPortName(portName);
        service.setPackageName(packageName);
        this.jaxws.getServices().addService(service);
        return new Service(service);
    }

    public Client[] getClients() {
        Clients clients = this.jaxws.getClients();
        if (clients == null) {
            return new Client[0];
        }
        org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Client[] org = clients.getClient();
        if (org == null) {
            return new Client[0];
        }
        Client[] newClients = new Client[org.length];
        for (int i = 0; i < org.length; ++i) {
            newClients[i] = new Client(org[i]);
        }
        return newClients;
    }

    public Client findClientByName(String name) {
        org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Client client = this.findClient(name);
        return client == null ? null : new Client(client);
    }

    public Client findClientByWsdlUrl(String wsdlUrl) {
        Clients clients = this.jaxws.getClients();
        if (clients == null) {
            return null;
        }
        org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Client[] org = clients.getClient();
        if (org == null) {
            return null;
        }
        for (int i = 0; i < org.length; ++i) {
            if (!wsdlUrl.equals(org[i].getWsdlUrl())) continue;
            return new Client(org[i]);
        }
        return null;
    }

    private org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Client findClient(String name) {
        Clients clients = this.jaxws.getClients();
        if (clients == null) {
            return null;
        }
        org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Client[] org = clients.getClient();
        if (org == null) {
            return null;
        }
        for (int i = 0; i < org.length; ++i) {
            if (!name.equals(org[i].getName())) continue;
            return org[i];
        }
        return null;
    }

    public boolean removeClient(String name) {
        org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Client client = this.findClient(name);
        if (client == null) {
            return false;
        }
        this.jaxws.getClients().removeClient(client);
        return true;
    }

    public Client addClient(String name, String wsdlUrl, String packageName) throws ClientAlreadyExistsExeption {
        if (this.findClient(name) != null) {
            throw new ClientAlreadyExistsExeption(name);
        }
        org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Client client = this.jaxws.getClients().newClient();
        client.setName(name);
        client.setWsdlUrl(wsdlUrl);
        if (packageName != null) {
            client.setPackageName(packageName);
            client.setPackageNameForceReplace("true");
        }
        this.jaxws.getClients().addClient(client);
        return new Client(client);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.jaxws.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.jaxws.removePropertyChangeListener(l);
    }

    public void merge(JaxWsModel newJaxWs) {
        if (newJaxWs.jaxws != null) {
            this.jaxws.merge(newJaxWs.jaxws, 3);
        }
    }

    public void write(OutputStream os) throws IOException {
        this.jaxws.write(os);
    }

    public FileObject getJaxWsFile() {
        return this.fo;
    }

    public void setJaxWsFile(FileObject fo) {
        this.fo = fo;
    }

    public void write() throws IOException {
        if (this.fo == null) {
            throw new IOException("No FileObject for writing specified");
        }
        this.fo.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                FileLock lock = null;
                try {
                    lock = JaxWsModel.this.fo.lock();
                    OutputStream os = JaxWsModel.this.fo.getOutputStream(lock);
                    JaxWsModel.this.write(os);
                    os.close();
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
                finally {
                    if (lock != null) {
                        lock.releaseLock();
                    }
                }
            }
        });
    }

    private static MetadataUnit findJAXWSMetadata(Project project) {
        JAXWSMetadataProvider metadataProvider = (JAXWSMetadataProvider)project.getLookup().lookup(JAXWSMetadataProvider.class);
        if (metadataProvider != null) {
            return metadataProvider.getJAXWSMetadata();
        }
        return null;
    }

    public synchronized void addServiceListener(ServiceListener listener) {
        if (listener != null) {
            this.serviceListeners.add(listener);
        }
    }

    public synchronized void removeServiceListener(ServiceListener listener) {
        this.serviceListeners.remove(listener);
    }

    void fireServiceAdded(String name, String implementationClass) {
        Iterator it = this.serviceListeners.iterator();
        while (it.hasNext()) {
            ((ServiceListener)it.next()).serviceAdded(name, implementationClass);
        }
    }

    void fireServiceRemoved(String name) {
        Iterator it = this.serviceListeners.iterator();
        while (it.hasNext()) {
            ((ServiceListener)it.next()).serviceRemoved(name);
        }
    }

    public static interface ServiceListener {
        public void serviceAdded(String var1, String var2);

        public void serviceRemoved(String var1);
    }
}

