/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs;

import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.modules.masterfs.InvalidDummy;
import org.netbeans.modules.masterfs.MasterFileObject;
import org.netbeans.modules.masterfs.MountTable;
import org.netbeans.modules.masterfs.ResourcePath;
import org.netbeans.modules.masterfs.SpecialDelegates;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.WriteLock;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.WriteLockFactory;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.WriteLockUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

final class Delegate {
    private FileObject delegate;
    private FileObject secondDelegate;
    private FileChangeListener weakListener;
    final FileChangeListener fListener;
    private Reference lock = null;
    private int attribs = 0;
    static final int SECOND_DELEGATE = 1;
    static final int BEST_DELEGATE = 0;
    private final MasterFileObject mfo;

    Delegate(FileObject fo, FileChangeListener fListener, MasterFileObject mfo) {
        this.fListener = fListener;
        this.mfo = mfo;
        this.set(fo);
    }

    FileObject get() {
        ResourcePath resPath = this.mfo.getResource();
        FileObject retVal = this.delegate;
        if (this.delegate instanceof InvalidDelegate) {
            retVal = null;
        } else if (retVal == null) {
            retVal = Delegate.resolve(resPath, true);
            this.set(retVal);
        }
        return retVal;
    }

    FileObject get(boolean maybeInvalid) {
        FileObject retVal = this.get();
        if (maybeInvalid && retVal == null) {
            retVal = this.delegate;
        }
        return retVal;
    }

    static FileObject resolve(ResourcePath resPath) {
        return Delegate.resolve(resPath, true);
    }

    private static FileObject resolve(ResourcePath resPath, boolean bestDelegate) {
        File f;
        String normalizedPath = resPath.getNormalizedPath();
        if (WriteLockUtils.hasActiveLockFileSigns(normalizedPath) && WriteLockUtils.hasActiveLockFileSigns((f = new ResourcePath(normalizedPath).getFile()).getName())) {
            return null;
        }
        FileObject retVal = bestDelegate ? MountTable.getDefault().resolveBestDelegate(normalizedPath) : MountTable.getDefault().resolveSecondDelegate(normalizedPath);
        if (retVal == null) {
            retVal = SpecialDelegates.get(resPath);
        } else {
            retVal.getAttribute("--hack--");
        }
        return retVal;
    }

    static FileLock getLockForDelegate(FileLock testedLock, FileObject delegate) throws IOException {
        if (testedLock == null) {
            throw new IOException();
        }
        if (!(testedLock instanceof FileLockImpl)) {
            throw new IOException();
        }
        FileLockImpl fLockImpl = (FileLockImpl)testedLock;
        Delegate del = fLockImpl.getDelegate();
        if (del.getFileLockImpl() != fLockImpl) {
            throw new IOException();
        }
        FileLock retVal = fLockImpl.get(delegate);
        if (retVal == null) {
            throw new IOException();
        }
        return retVal;
    }

    FileObject getPrefered() {
        FileObject retVal = this.get();
        FileObject secRetVal = null;
        if (retVal != null && retVal.isRoot()) {
            secRetVal = this.getSecond();
        }
        return secRetVal != null ? secRetVal : retVal;
    }

    void reset(ResourcePath resPath) {
        FileObject lastDelegate = this.delegate;
        this.set(null);
        this.setSecond(null);
        if (this.get() == null) {
            boolean folder = lastDelegate != null ? lastDelegate.isFolder() : false;
            this.delegate = new InvalidDelegate(resPath, folder);
        } else {
            this.getSecond();
            this.attribs = 0;
            try {
                this.reLock();
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }

    boolean isValid() {
        return this.delegate != null && this.delegate.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileLock lock() throws IOException {
        FileLockImpl lck;
        String path = this.mfo.getPath();
        Class clazz = Delegate.class;
        synchronized (clazz) {
            lck = this.getFileLockImpl();
            if (lck != null) {
                throw new FileAlreadyLockedException(path);
            }
            lck = new FileLockImpl();
            this.lock = new WeakReference<FileLockImpl>(lck);
        }
        lck.initLock(this.mfo.getResource().getFile(), this.get(), this.getPrefered());
        return lck;
    }

    boolean hasMountAbleFlag() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void set(FileObject fo) {
        Delegate delegate = this;
        synchronized (delegate) {
            FileChangeListener oldListener = this.weakListener;
            FileObject oldDelegate = this.delegate;
            if (oldDelegate == fo) {
                return;
            }
            if (oldListener != null && oldDelegate != null) {
                oldDelegate.removeFileChangeListener(oldListener);
            }
            this.delegate = fo;
            if (fo != null) {
                this.weakListener = FileUtil.weakFileChangeListener((FileChangeListener)this.fListener, (Object)fo);
                fo.addFileChangeListener(this.weakListener);
            }
        }
    }

    private void reLock() throws IOException {
        FileLockImpl lck = this.getFileLockImpl();
        if (lck != null) {
            lck.lock(this.delegate);
            lck.lock(this.secondDelegate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileLockImpl getFileLockImpl() {
        FileLockImpl lck;
        Class clazz = Delegate.class;
        synchronized (clazz) {
            lck = this.lock == null ? null : this.lock.get();
        }
        return lck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSecond(FileObject fo) {
        Delegate delegate = this;
        synchronized (delegate) {
            this.secondDelegate = fo;
        }
    }

    private FileObject getSecond() {
        ResourcePath resPath = this.mfo.getResource();
        FileObject retVal = this.secondDelegate;
        if (retVal == null) {
            retVal = Delegate.resolve(resPath, false);
            this.setSecond(retVal);
        }
        return retVal;
    }

    private static class InvalidDelegate
    extends InvalidDummy {
        private final boolean isFolder;

        protected InvalidDelegate(ResourcePath resourcePath, boolean isFolder) {
            super(resourcePath);
            this.isFolder = isFolder;
        }

        public boolean isData() {
            return !this.isFolder;
        }

        public boolean isFolder() {
            return this.isFolder;
        }
    }

    private static class TestLockException
    extends IOException {
        Map m = new HashMap();

        private TestLockException() {
        }

        void put(FileLockImpl impl, String msg) {
            this.m.put(impl, new Exception(msg));
        }

        public void printStackTrace(FileLockImpl tested, FileLockImpl current) {
            Exception exc2;
            Exception exc = (Exception)this.m.get((Object)tested);
            if (exc != null) {
                System.err.println("-------- " + exc.getLocalizedMessage() + " ----------");
                exc.printStackTrace();
            }
            if ((exc2 = (Exception)this.m.get((Object)current)) != null) {
                System.err.println("-------- " + exc2.getLocalizedMessage() + " ----------");
                exc2.printStackTrace();
            }
        }
    }

    private final class FileLockImpl
    extends FileLock {
        private final Map lockList = new WeakHashMap();
        private FileLock mandatoryLock;

        FileLockImpl() {
        }

        private void initLock(File file, FileObject delegate, FileObject prefered) throws IOException {
            try {
                this.lock(delegate);
                this.lock(prefered);
                if (this.mandatoryLock == null && file != null && (delegate != null && delegate.isData() || prefered != null && prefered.isData())) {
                    this.mandatoryLock = WriteLockFactory.tryLock(file, false);
                }
            }
            catch (IOException e) {
                this.releaseLock();
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void releaseLock() {
            if (this.isValid()) {
                super.releaseLock();
                if (this.mandatoryLock != null) {
                    this.mandatoryLock.releaseLock();
                }
                Collection locks = this.lockList.values();
                Iterator iterator = locks.iterator();
                while (iterator.hasNext()) {
                    FileLock fLock = (FileLock)iterator.next();
                    fLock.releaseLock();
                }
                if (this.getCurrentLock() == this) {
                    Class clazz = class$org$netbeans$modules$masterfs$Delegate == null ? (class$org$netbeans$modules$masterfs$Delegate = Delegate.class$("org.netbeans.modules.masterfs.Delegate")) : class$org$netbeans$modules$masterfs$Delegate;
                    synchronized (clazz) {
                        Delegate.this.lock = null;
                    }
                }
            }
        }

        private FileLock getCurrentLock() {
            return Delegate.this.lock != null ? (FileLock)Delegate.this.lock.get() : null;
        }

        private void lock(FileObject delegate) throws IOException {
            if (delegate != null && this.get(delegate) == null) {
                FileLock fLock = delegate.lock();
                if (this.mandatoryLock == null && fLock instanceof WriteLock) {
                    this.mandatoryLock = fLock;
                }
                this.lockList.put(delegate, fLock);
            }
        }

        private FileLock get(FileObject delegate) {
            return (FileLock)this.lockList.get(delegate);
        }

        private Delegate getDelegate() {
            return Delegate.this;
        }
    }
}

