/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.multiview.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.cookies.SectionFocusCookie;
import org.netbeans.modules.xml.multiview.ui.ContainerPanel;
import org.netbeans.modules.xml.multiview.ui.InnerPanelFactory;
import org.netbeans.modules.xml.multiview.ui.NodeSectionPanel;
import org.netbeans.modules.xml.multiview.ui.PanelView;
import org.netbeans.modules.xml.multiview.ui.SectionPanel;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.multiview.ui.ToolBarDesignEditor;
import org.openide.nodes.Node;

public class SectionView
extends PanelView
implements SectionFocusCookie,
ContainerPanel {
    private JPanel scrollPanel;
    private JPanel filler;
    JScrollPane scrollPane;
    private Hashtable map;
    private int sectionCount = 0;
    private NodeSectionPanel activePanel;
    private InnerPanelFactory factory = null;
    boolean sectionSelected;

    public SectionView(InnerPanelFactory factory) {
        this.factory = factory;
    }

    public SectionView() {
    }

    public void initComponents() {
        super.initComponents();
        this.map = new Hashtable();
        this.setLayout(new BorderLayout());
        this.scrollPanel = new JPanel();
        this.scrollPanel.setLayout(new GridBagLayout());
        this.scrollPane = new JScrollPane();
        this.scrollPane.setViewportView(this.scrollPanel);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(15);
        this.filler = new JPanel();
        this.filler.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.add((Component)this.scrollPane, "Center");
    }

    public boolean focusSection(NodeSectionPanel panel) {
        panel.open();
        this.openParents((JPanel)((Object)panel));
        panel.scroll();
        this.setActivePanel(panel);
        panel.setActive(true);
        return true;
    }

    protected void openSection(Node node) {
        NodeSectionPanel panel = (NodeSectionPanel)this.map.get(node);
        if (panel != null) {
            this.focusSection(panel);
        }
    }

    private void openParents(JPanel panel) {
        JScrollPane scrollP = null;
        NodeSectionPanel parentSection = null;
        for (Container ancestor = panel.getParent(); ancestor != null && scrollP == null; ancestor = ancestor.getParent()) {
            if (ancestor instanceof JScrollPane) {
                scrollP = (JScrollPane)ancestor;
            }
            if (!(ancestor instanceof NodeSectionPanel)) continue;
            parentSection = (NodeSectionPanel)((Object)ancestor);
            parentSection.open();
        }
    }

    void mapSection(Node key, NodeSectionPanel panel) {
        this.map.put(key, panel);
    }

    void deleteSection(Node key) {
        this.map.remove(key);
    }

    public NodeSectionPanel getSection(Node key) {
        return (NodeSectionPanel)this.map.get(key);
    }

    public void addSection(NodeSectionPanel section, boolean open) {
        this.addSection(section);
        if (open) {
            section.open();
            section.scroll();
            section.setActive(true);
        }
    }

    public void addSection(NodeSectionPanel section) {
        this.scrollPanel.remove(this.filler);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = this.sectionCount;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.scrollPanel.add((Component)((JPanel)((Object)section)), gridBagConstraints);
        section.setIndex(this.sectionCount);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = this.sectionCount + 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 2.0;
        this.scrollPanel.add((Component)this.filler, gridBagConstraints);
        this.mapSection(section.getNode(), section);
        ++this.sectionCount;
    }

    public void removeSection(Node node) {
        NodeSectionPanel section = this.getSection(node);
        if (section != null) {
            Container cont;
            for (cont = ((Component)((Object)section)).getParent(); cont != null && !(cont instanceof ContainerPanel); cont = cont.getParent()) {
            }
            if (cont != null) {
                Object key;
                ContainerPanel contPanel = (ContainerPanel)((Object)cont);
                if (section instanceof SectionPanel && (key = ((SectionPanel)section).getKey()) != null && key == this.getLastActive()) {
                    this.setLastActive(null);
                }
                contPanel.removeSection(section);
                contPanel.getRoot().getChildren().remove(new Node[]{node});
            }
        }
    }

    public void removeSection(NodeSectionPanel panel) {
        NodeSectionPanel pan;
        int i;
        int panelIndex = panel.getIndex();
        this.scrollPanel.remove((JPanel)((Object)panel));
        Component[] components = this.scrollPanel.getComponents();
        ArrayList<NodeSectionPanel> removedPanels = new ArrayList<NodeSectionPanel>();
        for (i = 0; i < components.length; ++i) {
            int index;
            if (!(components[i] instanceof NodeSectionPanel) || (index = (pan = (NodeSectionPanel)((Object)components[i])).getIndex()) <= panelIndex) continue;
            this.scrollPanel.remove((JPanel)((Object)pan));
            pan.setIndex(index - 1);
            ((AbstractList)removedPanels).add(pan);
        }
        for (i = 0; i < ((AbstractCollection)removedPanels).size(); ++i) {
            pan = (NodeSectionPanel)((AbstractList)removedPanels).get(i);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = pan.getIndex();
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            this.scrollPanel.add((Component)((JPanel)((Object)pan)), gridBagConstraints);
        }
        this.deleteSection(panel.getNode());
        --this.sectionCount;
    }

    public void setActivePanel(NodeSectionPanel activePanel) {
        if (this.activePanel != null && this.activePanel != activePanel) {
            this.activePanel.setActive(false);
        }
        this.activePanel = activePanel;
        if (activePanel instanceof SectionPanel) {
            this.setLastActive(((SectionPanel)activePanel).getKey());
        }
    }

    public NodeSectionPanel getActivePanel() {
        return this.activePanel;
    }

    public void selectNode(Node node) {
        this.setManagerSelection(new Node[]{node});
    }

    public void showSelection(Node[] nodes) {
        if (this.sectionSelected) {
            this.sectionSelected = false;
            return;
        }
        if (nodes != null && nodes.length > 0) {
            this.openSection(nodes[0]);
        }
    }

    void sectionSelected(boolean sectionSelected) {
        this.sectionSelected = sectionSelected;
    }

    protected Error validateView() {
        return null;
    }

    public SectionPanel findSectionPanel(Object key) {
        Enumeration en = this.map.keys();
        while (en.hasMoreElements()) {
            SectionPanel p;
            NodeSectionPanel pan = (NodeSectionPanel)this.map.get(en.nextElement());
            if (!(pan instanceof SectionPanel) || key != (p = (SectionPanel)pan).getKey()) continue;
            return p;
        }
        return null;
    }

    InnerPanelFactory getInnerPanelFactory() {
        return this.factory;
    }

    public void setInnerPanelFactory(InnerPanelFactory factory) {
        this.factory = factory;
    }

    public void openPanel(Object key) {
        SectionPanel panel;
        if (key != null && (panel = this.findSectionPanel(key)) != null) {
            if (panel.getInnerPanel() == null) {
                panel.open();
            }
            this.openParents(panel);
            panel.scroll();
            panel.setActive(true);
        }
    }

    private Object getLastActive() {
        ToolBarDesignEditor toolBarDesignEditor = this.getToolBarDesignEditor();
        return toolBarDesignEditor == null ? null : toolBarDesignEditor.getLastActive();
    }

    private void setLastActive(Object key) {
        ToolBarDesignEditor toolBarDesignEditor = this.getToolBarDesignEditor();
        if (toolBarDesignEditor != null) {
            toolBarDesignEditor.setLastActive(key);
        }
    }

    protected ToolBarDesignEditor getToolBarDesignEditor() {
        Container parent = this.getParent();
        return parent == null ? null : (ToolBarDesignEditor)((Object)parent.getParent());
    }
}

