/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.editor.completion.db;

import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.text.BadLocationException;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.editor.ext.java.JCExpression;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.dbschema.TableElement;
import org.netbeans.modules.j2ee.common.DatasourceHelper;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.metadata.JMIClassIntrospector;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceUtils;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.Entity;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.EntityMappings;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.ManyToMany;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.ManyToOne;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.OneToMany;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.OneToOne;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.SecondaryTable;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.Table;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.editor.completion.AnnotationUtils;
import org.netbeans.modules.j2ee.persistence.editor.completion.CompletionContextResolver;
import org.netbeans.modules.j2ee.persistence.editor.completion.JMIUtils;
import org.netbeans.modules.j2ee.persistence.editor.completion.NNCompletionQuery;
import org.netbeans.modules.j2ee.persistence.editor.completion.NNParser;
import org.netbeans.modules.j2ee.persistence.editor.completion.NNResultItem;
import org.netbeans.modules.j2ee.persistence.editor.completion.db.Catalog;
import org.netbeans.modules.j2ee.persistence.editor.completion.db.DBMetaDataProvider;
import org.netbeans.modules.j2ee.persistence.editor.completion.db.DBMetaDataUtils;
import org.netbeans.modules.j2ee.persistence.editor.completion.db.Schema;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.javacore.JMManager;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBCompletionContextResolver
implements CompletionContextResolver {
    private DatabaseConnection dbconn;
    private DBMetaDataProvider provider;
    private static final String[] ANNOTATION_QUERY_TYPES = new String[]{"Table", "SecondaryTable", "Column", "PrimaryKeyJoinColumn", "JoinColumn", "JoinTable", "PersistenceUnit", "PersistenceContext", "ManyToMany"};
    private static final String PERSISTENCE_PKG = "javax.persistence";
    private static final boolean DEBUG = Boolean.getBoolean("debug." + DBCompletionContextResolver.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List resolve(JCExpression exp, NNCompletionQuery.Context ctx) {
        ArrayList result = new ResultItemsFilterList(ctx);
        NNParser.NN parsedNN = ctx.getParsedAnnotation();
        if (parsedNN == null) {
            return result;
        }
        NNParser.NNAttr nnattr = parsedNN.getAttributeForOffset(ctx.getCompletionOffset());
        if (nnattr == null) {
            return result;
        }
        String annotationName = parsedNN.getName();
        if (annotationName == null) {
            return result;
        }
        try {
            int index = this.getAnnotationIndex(annotationName);
            if (index == 6 || index == 7) {
                this.completePersistenceUnitContext(ctx, parsedNN, nnattr, result);
            } else if (index != -1) {
                this.dbconn = this.findDatabaseConnection(ctx);
                if (this.dbconn == null) {
                    ErrorManager.getDefault().log("No Database Connection.");
                    return result;
                }
                assert (Thread.currentThread() != JMManager.getTransactionMutex().getThread());
                Connection conn = this.dbconn.getJDBCConnection();
                if (conn == null) {
                    result = new ArrayList();
                    result.add(new NNResultItem.NoConnectionElementItem(this.dbconn));
                    return result;
                }
                this.provider = this.getDBMetadataProvider(this.dbconn, conn);
            }
            if (this.provider == null) return result;
            JMIUtils utils = JMIUtils.get(ctx.getBaseDocument());
            utils.beginTrans(false);
            try {
                ((JMManager)JMManager.getManager()).setSafeTrans(true);
                switch (index) {
                    case 0: {
                        this.completeTable(parsedNN, nnattr, result, false);
                        return result;
                    }
                    case 1: 
                    case 5: {
                        this.completeTable(parsedNN, nnattr, result, true);
                        return result;
                    }
                    case 2: {
                        this.completeColumn(ctx, parsedNN, nnattr, result);
                        return result;
                    }
                    case 3: {
                        this.completePrimaryKeyJoinColumn(ctx, parsedNN, nnattr, result);
                        return result;
                    }
                    case 4: {
                        this.completeJoinColumn(ctx, parsedNN, nnattr, result);
                        return result;
                    }
                    case 8: {
                        this.completeManyToMany(ctx, parsedNN, nnattr, result);
                        return result;
                    }
                }
                return result;
            }
            finally {
                utils.endTrans(false);
            }
        }
        catch (SQLException e) {
            ErrorManager.getDefault().notify(16, (Throwable)e);
        }
        return result;
    }

    private int getAnnotationIndex(String annotationName) {
        if (annotationName.startsWith(PERSISTENCE_PKG)) {
            annotationName = annotationName.substring(annotationName.lastIndexOf(46) + 1);
        }
        for (int i = 0; i < ANNOTATION_QUERY_TYPES.length; ++i) {
            if (!ANNOTATION_QUERY_TYPES[i].equals(annotationName)) continue;
            return i;
        }
        return -1;
    }

    private DBMetaDataProvider getDBMetadataProvider(DatabaseConnection dbconn, Connection con) {
        return DBMetaDataProvider.get(con, dbconn.getDriverClass());
    }

    private DatabaseConnection findDatabaseConnection(NNCompletionQuery.Context ctx) {
        PersistenceUnit[] pus = ctx.getPersistenceUnits();
        if (pus == null || pus.length == 0) {
            ErrorManager.getDefault().log(1, "There isn't any defined persistence unit for this class in the project!");
            return null;
        }
        PersistenceUnit pu = pus[0];
        DatabaseConnection dbconn = ProviderUtil.getConnection(pu);
        if (dbconn != null) {
            return dbconn;
        }
        String datasourceName = ProviderUtil.getDatasourceName(pu);
        if (datasourceName == null) {
            return null;
        }
        FileObject fo = ctx.getFileObject();
        if (fo == null) {
            return null;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        if (project == null) {
            return null;
        }
        J2eeModuleProvider moduleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (moduleProvider == null) {
            return null;
        }
        Datasource datasource = DatasourceHelper.findDatasource((J2eeModuleProvider)moduleProvider, (String)datasourceName);
        if (datasource == null) {
            ErrorManager.getDefault().log(1, "The " + datasourceName + " was not found.");
            return null;
        }
        List dbconns = DatasourceHelper.findDatabaseConnections((Datasource)datasource);
        if (dbconns.size() > 0) {
            return (DatabaseConnection)dbconns.get(0);
        }
        return null;
    }

    private List completeTable(NNParser.NN nn, NNParser.NNAttr nnattr, List<NNResultItem> results, boolean secondaryTable) throws SQLException {
        block5: {
            String schemaName;
            String catalogName;
            Schema schema;
            Map<String, Object> members;
            String completedMember;
            block6: {
                block4: {
                    completedMember = nnattr.getName();
                    members = nn.getAttributes();
                    if (!"catalog".equals(completedMember)) break block4;
                    Catalog[] catalogs = this.provider.getCatalogs();
                    for (int i = 0; i < catalogs.length; ++i) {
                        String catalogName2 = catalogs[i].getName();
                        if (catalogName2 == null) continue;
                        results.add(new NNResultItem.CatalogElementItem(catalogName2, nnattr.isValueQuoted(), nnattr.getValueOffset()));
                    }
                    break block5;
                }
                if (!"schema".equals(completedMember)) break block6;
                String catalogName3 = this.getThisOrDefaultCatalog((String)members.get("catalog"));
                Catalog catalog = this.provider.getCatalog(catalogName3);
                if (catalog == null) break block5;
                Schema[] schemas = catalog.getSchemas();
                for (int i = 0; i < schemas.length; ++i) {
                    results.add(new NNResultItem.SchemaElementItem(schemas[i].getName(), nnattr.isValueQuoted(), nnattr.getValueOffset()));
                }
                break block5;
            }
            if ("name".equals(completedMember) && (schema = DBMetaDataUtils.getSchema(this.provider, catalogName = this.getThisOrDefaultCatalog((String)members.get("catalog")), schemaName = this.getThisOrDefaultSchema((String)members.get("schema")))) != null) {
                String[] tableNames = schema.getTableNames();
                for (int i = 0; i < tableNames.length; ++i) {
                    results.add(new NNResultItem.TableElementItem(tableNames[i], nnattr.isValueQuoted(), nnattr.getValueOffset()));
                }
            }
        }
        return results;
    }

    private List completePrimaryKeyJoinColumn(NNCompletionQuery.Context ctx, NNParser.NN nn, NNParser.NNAttr nnattr, List<NNResultItem> results) throws SQLException {
        String schemaName;
        String catalogName;
        TableElement tableElement;
        String tableName;
        Table table;
        Entity entity;
        String completedMember = nnattr.getName();
        Map<String, Object> members = nn.getAttributes();
        if ("name".equals(completedMember) && (entity = PersistenceUtils.getEntity(ctx.getJavaClass(), ctx.getEntityMappings())) != null && (table = entity.getTable()) != null && (tableName = table.getName()) != null && (tableElement = DBMetaDataUtils.getTable(this.provider, catalogName = this.getThisOrDefaultCatalog(table.getCatalog()), schemaName = this.getThisOrDefaultSchema(table.getSchema()), tableName)) != null) {
            ColumnElement[] columnElements = tableElement.getColumns();
            for (int i = 0; i < columnElements.length; ++i) {
                results.add(new NNResultItem.ColumnElementItem(columnElements[i].getName().getName(), tableName, true, -1));
            }
        }
        return results;
    }

    private List completeColumn(NNCompletionQuery.Context ctx, NNParser.NN nn, NNParser.NNAttr nnattr, List<NNResultItem> results) throws SQLException {
        block9: {
            String schemaName;
            String catalogName;
            String tableName2;
            block10: {
                SecondaryTable[] stables;
                TableElement tableElement;
                String completedMember = nnattr.getName();
                Map<String, Object> members = nn.getAttributes();
                if ("table".equals(completedMember)) {
                    Set mappingTables = this.getMappingEntityTableNames(ctx.getJavaClass());
                    for (String tableName2 : mappingTables) {
                        results.add(new NNResultItem.TableElementItem(tableName2, nnattr.isValueQuoted(), nnattr.getValueOffset()));
                    }
                }
                if (!"name".equals(completedMember)) break block9;
                catalogName = null;
                schemaName = null;
                tableName2 = (String)members.get("table");
                if (tableName2 != null) break block10;
                Entity entity = PersistenceUtils.getEntity(ctx.getJavaClass(), ctx.getEntityMappings());
                if (entity == null) break block9;
                Table table = entity.getTable();
                if (table != null && (tableName2 = table.getName()) != null && (tableElement = DBMetaDataUtils.getTable(this.provider, catalogName = this.getThisOrDefaultCatalog(table.getCatalog()), schemaName = this.getThisOrDefaultSchema(table.getSchema()), tableName2)) != null) {
                    ColumnElement[] columnElements = tableElement.getColumns();
                    for (int i = 0; i < columnElements.length; ++i) {
                        results.add(new NNResultItem.ColumnElementItem(columnElements[i].getName().getName(), tableName2, nnattr.isValueQuoted(), nnattr.getValueOffset()));
                    }
                }
                if ((stables = entity.getSecondaryTable()) != null) {
                    for (int idx = 0; idx < stables.length; ++idx) {
                        String secTableName = stables[idx].getName();
                        TableElement tableElement2 = DBMetaDataUtils.getTable(this.provider, catalogName, schemaName, secTableName);
                        if (tableElement2 == null) continue;
                        ColumnElement[] columnElements = tableElement2.getColumns();
                        for (int i = 0; i < columnElements.length; ++i) {
                            results.add(new NNResultItem.ColumnElementItem(columnElements[i].getName().getName(), tableName2, nnattr.isValueQuoted(), nnattr.getValueOffset()));
                        }
                    }
                }
                break block9;
            }
            TableElement tableElement = DBMetaDataUtils.getTable(this.provider, catalogName = this.getThisOrDefaultCatalog(catalogName), schemaName = this.getThisOrDefaultSchema(schemaName), tableName2);
            if (tableElement != null) {
                ColumnElement[] columnElements = tableElement.getColumns();
                for (int i = 0; i < columnElements.length; ++i) {
                    results.add(new NNResultItem.ColumnElementItem(columnElements[i].getName().getName(), tableName2, nnattr.isValueQuoted(), nnattr.getValueOffset()));
                }
            }
        }
        return results;
    }

    private List completeJoinColumn(NNCompletionQuery.Context ctx, NNParser.NN nn, NNParser.NNAttr nnattr, List<NNResultItem> results) throws SQLException {
        Entity entity;
        String completedMember = nnattr.getName();
        Map<String, Object> members = nn.getAttributes();
        if ("name".equals(completedMember) && (entity = PersistenceUtils.getEntity(ctx.getJavaClass(), ctx.getEntityMappings())) != null && entity.getAttributes() != null) {
            String propertyName = ctx.getCompletedMemberName();
            String resolvedClassName = ctx.getCompletedMemberClassName();
            Type type = ctx.getSyntaxSupport().getTypeFromName(resolvedClassName, false, null, false);
            if (type == null) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(NNCompletionQuery.class, (String)"MSG_CannotFindClass", (Object[])new Object[]{resolvedClassName, propertyName}));
                return Collections.EMPTY_LIST;
            }
            String resolvedType = type.getName();
            if (DEBUG) {
                System.out.println("completion called on property " + propertyName + " of " + resolvedType + " type.");
            }
            EntityMappings em = ctx.getEntityMappings();
            ManyToOne[] m2o = entity.getAttributes().getManyToOne();
            OneToOne[] o2o = entity.getAttributes().getOneToOne();
            OneToMany[] o2m = entity.getAttributes().getOneToMany();
            ManyToMany[] m2m = entity.getAttributes().getManyToMany();
            ManyToOne m2onn = null;
            if (m2o != null) {
                for (int i = 0; i < m2o.length; ++i) {
                    if (!m2o[i].getName().equals(propertyName)) continue;
                    m2onn = m2o[i];
                    break;
                }
            }
            OneToOne o2onn = null;
            if (o2o != null) {
                for (int i = 0; i < o2o.length; ++i) {
                    if (!o2o[i].getName().equals(propertyName)) continue;
                    o2onn = o2o[i];
                    break;
                }
            }
            OneToMany o2mnn = null;
            if (o2m != null) {
                for (int i = 0; i < o2m.length; ++i) {
                    if (!o2m[i].getName().equals(propertyName)) continue;
                    o2mnn = o2m[i];
                    break;
                }
            }
            ManyToMany m2mnn = null;
            if (m2m != null) {
                for (int i = 0; i < m2m.length; ++i) {
                    if (!m2m[i].getName().equals(propertyName)) continue;
                    m2mnn = m2m[i];
                    break;
                }
            }
            if (m2onn != null || o2onn != null) {
                String targetEntity;
                if (DEBUG) {
                    System.out.println("found OneToOne or ManyToOne annotation on the completed field.");
                }
                Entity ent = PersistenceUtils.getEntity(resolvedType, ctx.getEntityMappings());
                if (m2onn != null && (targetEntity = m2onn.getTargetEntity()) != null) {
                    ent = PersistenceUtils.getEntity(targetEntity, em);
                    if (DEBUG) {
                        System.out.println("entity " + ent.getName() + " is specified in ManyToOne element.");
                    }
                }
                if (o2onn != null && (targetEntity = o2onn.getTargetEntity()) != null) {
                    ent = PersistenceUtils.getEntity(targetEntity, em);
                    if (DEBUG) {
                        System.out.println("entity " + ent.getName() + " is specified in OneToOne element.");
                    }
                }
                if (ent != null) {
                    Table table = ent.getTable();
                    if (table != null) {
                        TableElement tableElement;
                        String catalogName = this.getThisOrDefaultCatalog(null);
                        String schemaName = this.getThisOrDefaultSchema(null);
                        String tableName = table.getName();
                        if (tableName != null && (tableElement = DBMetaDataUtils.getTable(this.provider, catalogName, schemaName, tableName)) != null) {
                            ColumnElement[] columnElements = tableElement.getColumns();
                            for (int i = 0; i < columnElements.length; ++i) {
                                results.add(new NNResultItem.ColumnElementItem(columnElements[i].getName().getName(), tableName, nnattr.isValueQuoted(), nnattr.getValueOffset()));
                            }
                            if (DEBUG) {
                                System.out.println("added " + columnElements.length + " CC items.");
                            }
                        }
                    } else if (DEBUG) {
                        System.out.println("the found entity has not defined table!?! (probably a  bug in values defaultter).");
                    }
                }
            }
            if (m2mnn != null) {
                NNParser.NN tableNN;
                Map<String, Object> attrs;
                Object val;
                if (DEBUG) {
                    System.out.println("found ManyToMany annotation on the completed field.");
                }
                if (DEBUG) {
                    System.out.println(nn);
                }
                NNParser.NN tblNN = null;
                if (nn != null && nn.getName().equals("JoinTable") && (val = (attrs = nn.getAttributes()).get("table")) != null && val instanceof NNParser.NN && (tableNN = (NNParser.NN)val).getName().equals("Table")) {
                    tblNN = tableNN;
                }
                if (tblNN != null) {
                    TableElement tableElement;
                    String catalogName = this.getThisOrDefaultCatalog((String)tblNN.getAttributes().get("catalog"));
                    String schemaName = this.getThisOrDefaultSchema((String)tblNN.getAttributes().get("schema"));
                    String tableName = (String)tblNN.getAttributes().get("name");
                    if (tableName != null && (tableElement = DBMetaDataUtils.getTable(this.provider, catalogName, schemaName, tableName)) != null) {
                        ColumnElement[] columnElements = tableElement.getColumns();
                        for (int i = 0; i < columnElements.length; ++i) {
                            results.add(new NNResultItem.ColumnElementItem(columnElements[i].getName().getName(), tableName, nnattr.isValueQuoted(), nnattr.getValueOffset()));
                        }
                    }
                }
            }
        }
        return results;
    }

    private List completePersistenceUnitContext(NNCompletionQuery.Context ctx, NNParser.NN nn, NNParser.NNAttr nnattr, List<NNResultItem> results) throws SQLException {
        String completedMember = nnattr.getName();
        Map<String, Object> members = nn.getAttributes();
        if ("unitName".equals(completedMember)) {
            PersistenceUnit[] pus;
            for (PersistenceUnit pu : pus = ctx.getPersistenceUnits()) {
                results.add(new NNResultItem.PersistenceUnitElementItem(pu.getName(), nnattr.isValueQuoted(), nnattr.getValueOffset()));
            }
        }
        return results;
    }

    private List completeManyToMany(NNCompletionQuery.Context ctx, NNParser.NN nn, NNParser.NNAttr nnattr, List<NNResultItem> results) throws SQLException {
        String completedMember = nnattr.getName();
        Map<String, Object> members = nn.getAttributes();
        if ("mappedBy".equals(completedMember)) {
            Entity entity;
            String resolvedClassName = ctx.getCompletedMemberClassName();
            Type type = ctx.getSyntaxSupport().getTypeFromName(resolvedClassName, false, null, false);
            if (type != null && (entity = PersistenceUtils.getEntity(type.getName(), ctx.getEntityMappings())) != null) {
                ClassDefinition cdef = (ClassDefinition)type;
                for (Feature f : cdef.getFeatures()) {
                    if (f instanceof Field) {
                        if (Modifier.isTransient(f.getModifiers()) || cdef.getMethod("get" + JMIClassIntrospector.capitalize((String)f.getName()), Collections.EMPTY_LIST, true) != null || cdef.getMethod("is" + JMIClassIntrospector.capitalize((String)f.getName()), Collections.EMPTY_LIST, true) != null) continue;
                        results.add(new NNResultItem.EntityPropertyElementItem(f.getName(), nnattr.isValueQuoted(), nnattr.getValueOffset()));
                        continue;
                    }
                    if (!(f instanceof Method) || !JMIClassIntrospector.isGetter((Method)((Method)f))) continue;
                    results.add(new NNResultItem.EntityPropertyElementItem(JMIClassIntrospector.getPropertyNameFromGetter((Method)((Method)f)), nnattr.isValueQuoted(), nnattr.getValueOffset()));
                }
            }
        }
        return results;
    }

    private Set getMappingEntityTableNames(JavaClass clazz) {
        TreeSet<String> result = new TreeSet<String>();
        List annotations = clazz.getAnnotations();
        for (Annotation annotation : annotations) {
            String tableName;
            String annotationTypeName = annotation.getType().getName();
            if ("javax.persistence.Table".equals(annotationTypeName)) {
                tableName = AnnotationUtils.getStringMemberValue(annotation, "name");
                if (tableName == null) continue;
                result.add(tableName);
                continue;
            }
            if ("javax.persistence.SecondaryTable".equals(annotationTypeName)) {
                tableName = AnnotationUtils.getStringMemberValue(annotation, "name");
                if (tableName == null) continue;
                result.add(tableName);
                continue;
            }
            if (!"javax.persistence.SecondaryTables".equals(annotationTypeName)) continue;
            List secondaryTableNNs = AnnotationUtils.getAnnotationsMemberValue(annotation, "value");
            for (Annotation secondaryTableNN : secondaryTableNNs) {
                String tableName2 = AnnotationUtils.getStringMemberValue(secondaryTableNN, "name");
            }
        }
        return result;
    }

    private String getThisOrDefaultCatalog(String catalogName) throws SQLException {
        assert (this.provider != null);
        if (catalogName != null) {
            return catalogName;
        }
        return this.provider.getDefaultCatalog();
    }

    private String getThisOrDefaultSchema(String schemaName) {
        assert (this.dbconn != null);
        if (schemaName != null) {
            return schemaName;
        }
        return this.dbconn.getSchema();
    }

    private String getAnnotationTypeName(JCExpression exp) {
        assert (exp != null);
        String result = null;
        if (exp.getParameterCount() < 1) {
            return result;
        }
        JCExpression variable = exp.getParameter(0);
        if (variable.getExpID() == 1) {
            return variable.getTokenText(0);
        }
        if (variable.getExpID() == 4) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < variable.getParameterCount(); ++i) {
                JCExpression subExp = variable.getParameter(i);
                sb.append(subExp.getTokenText(0));
                if (i >= variable.getParameterCount() - 1) continue;
                sb.append('.');
            }
            return sb.toString();
        }
        return result;
    }

    private static final class ResultItemsFilterList
    extends ArrayList {
        private NNCompletionQuery.Context ctx;

        public ResultItemsFilterList(NNCompletionQuery.Context ctx) {
            this.ctx = ctx;
        }

        public boolean add(Object o) {
            if (!(o instanceof NNResultItem)) {
                return false;
            }
            NNResultItem ri = (NNResultItem)o;
            try {
                String preText = this.ctx.getBaseDocument().getText(ri.getSubstituteOffset(), this.ctx.getCompletionOffset() - ri.getSubstituteOffset());
                if (ri.getItemText().startsWith(preText)) {
                    return super.add(ri);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return false;
        }
    }
}

