/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.dao;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.ChangeSupport;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.SourceGroupSupport;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.SourceGroupUISupport;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class EjbFacadeVisualPanel2
extends JPanel
implements DocumentListener {
    private static final String CLASSNAME_LOCAL = ", <ClassName>FacadeLocal";
    private static final String CLASSNAME_REMOTE = ", <ClassName>FacadeRemote";
    private WizardDescriptor wizard;
    private Project project;
    private JTextComponent packageComboBoxEditor;
    private ChangeSupport changeSupport = new ChangeSupport(this);
    private JTextField createdFilesText;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JCheckBox localCheckBox;
    private JComboBox locationComboBox;
    private JComboBox packageComboBox;
    private JTextField projectTextField;
    private JCheckBox remoteCheckBox;

    public EjbFacadeVisualPanel2(WizardDescriptor wizard) {
        this.wizard = wizard;
        this.initComponents();
        this.packageComboBoxEditor = (JTextComponent)this.packageComboBox.getEditor().getEditorComponent();
        Document packageComboBoxDocument = this.packageComboBoxEditor.getDocument();
        packageComboBoxDocument.addDocumentListener(this);
        this.handleCheckboxes();
    }

    public String getName() {
        return NbBundle.getMessage(EjbFacadeVisualPanel2.class, (String)"LBL_GeneratedSessionBeans");
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    boolean valid(WizardDescriptor wizard) {
        return true;
    }

    public SourceGroup getLocationValue() {
        return (SourceGroup)this.locationComboBox.getSelectedItem();
    }

    public String getPackage() {
        return this.packageComboBoxEditor.getText();
    }

    private void locationChanged() {
        this.updateSourceGroupPackages();
        this.changeSupport.fireChange();
    }

    void read(WizardDescriptor settings) {
        this.project = Templates.getProject((WizardDescriptor)settings);
        FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)settings);
        this.projectTextField.setText(ProjectUtils.getInformation((Project)this.project).getDisplayName());
        SourceGroup[] sourceGroups = SourceGroupSupport.getJavaSourceGroups(this.project);
        SourceGroupUISupport.connect(this.locationComboBox, sourceGroups);
        this.packageComboBox.setRenderer(PackageView.listRenderer());
        this.updateSourceGroupPackages();
        SourceGroup targetSourceGroup = SourceGroupSupport.getFolderSourceGroup(sourceGroups, targetFolder);
        if (targetSourceGroup != null) {
            this.locationComboBox.setSelectedItem(targetSourceGroup);
            String targetPackage = SourceGroupSupport.getPackageForFolder(targetSourceGroup, targetFolder);
            if (targetPackage != null) {
                this.packageComboBoxEditor.setText(targetPackage);
            }
        }
    }

    void store(WizardDescriptor settings) {
        try {
            Templates.setTargetFolder((WizardDescriptor)settings, (FileObject)SourceGroupSupport.getFolderForPackage(this.getLocationValue(), this.getPackage()));
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
    }

    private void updateSourceGroupPackages() {
        SourceGroup sourceGroup = (SourceGroup)this.locationComboBox.getSelectedItem();
        ComboBoxModel model = PackageView.createListView((SourceGroup)sourceGroup);
        if (model.getSelectedItem() != null && model.getSelectedItem().toString().startsWith("META-INF") && model.getSize() > 1) {
            model.setSelectedItem(model.getElementAt(1));
        }
        this.packageComboBox.setModel(model);
    }

    public void insertUpdate(DocumentEvent e) {
    }

    public void removeUpdate(DocumentEvent e) {
    }

    public void changedUpdate(DocumentEvent e) {
    }

    boolean isRemote() {
        return this.remoteCheckBox.isSelected();
    }

    boolean isLocal() {
        return this.localCheckBox.isSelected();
    }

    private void handleCheckboxes() {
        this.createdFilesText.setText(NbBundle.getMessage(EjbFacadeVisualPanel2.class, (String)"LBL_CreatedFIles", (Object)(this.isLocal() ? CLASSNAME_LOCAL : ""), (Object)(this.isRemote() ? CLASSNAME_REMOTE : "")));
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.locationComboBox = new JComboBox();
        this.packageComboBox = new JComboBox();
        this.projectTextField = new JTextField();
        this.jLabel6 = new JLabel();
        this.remoteCheckBox = new JCheckBox();
        this.localCheckBox = new JCheckBox();
        this.createdFilesText = new JTextField();
        this.jLabel5 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(EjbFacadeVisualPanel2.class, (String)"LBL_SpecifyLocation"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(EjbFacadeVisualPanel2.class, (String)"LBL_Project"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(EjbFacadeVisualPanel2.class, (String)"LBL_Location"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(EjbFacadeVisualPanel2.class, (String)"LBL_Package"));
        this.packageComboBox.setEditable(true);
        this.projectTextField.setEditable(false);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(EjbFacadeVisualPanel2.class, (String)"LBL_CreateInterface"));
        Mnemonics.setLocalizedText((AbstractButton)this.remoteCheckBox, (String)NbBundle.getMessage(EjbFacadeVisualPanel2.class, (String)"LBL_Remote"));
        this.remoteCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.remoteCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.remoteCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EjbFacadeVisualPanel2.this.remoteCheckBoxActionPerformed(evt);
            }
        });
        this.localCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.localCheckBox, (String)NbBundle.getMessage(EjbFacadeVisualPanel2.class, (String)"LBL_Local"));
        this.localCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.localCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.localCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EjbFacadeVisualPanel2.this.localCheckBoxActionPerformed(evt);
            }
        });
        this.createdFilesText.setEditable(false);
        this.createdFilesText.setHorizontalAlignment(2);
        this.createdFilesText.setText(NbBundle.getMessage(EjbFacadeVisualPanel2.class, (String)"LBL_CreatedFIles", (Object[])new Object[]{"", ""}));
        this.createdFilesText.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(EjbFacadeVisualPanel2.class, (String)"LBL_CreatedFilesLabel"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel2).add((Component)this.jLabel3).add((Component)this.jLabel4).add((Component)this.jLabel5)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.projectTextField, -1, 568, Short.MAX_VALUE).add((Component)this.locationComboBox, 0, 568, Short.MAX_VALUE).add((Component)this.packageComboBox, 0, 568, Short.MAX_VALUE).add((Component)this.createdFilesText, -1, 568, Short.MAX_VALUE))).add((Component)this.jLabel1).add((Component)this.jLabel6).add((Component)this.remoteCheckBox).add((Component)this.localCheckBox));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.projectTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.locationComboBox, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.packageComboBox, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel5).add((Component)this.createdFilesText, -2, -1, -2)).addPreferredGap(0).add((Component)this.jLabel6).addPreferredGap(0).add((Component)this.remoteCheckBox).addPreferredGap(0).add((Component)this.localCheckBox)));
    }

    private void localCheckBoxActionPerformed(ActionEvent evt) {
        this.handleCheckboxes();
        this.changeSupport.fireChange();
    }

    private void remoteCheckBoxActionPerformed(ActionEvent evt) {
        this.handleCheckboxes();
        this.changeSupport.fireChange();
    }
}

