/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.Completion;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ExtFormatter;
import org.netbeans.editor.ext.java.JCExpression;
import org.netbeans.editor.ext.java.JavaCompletionQuery;
import org.netbeans.editor.ext.java.JavaFormatSupport;
import org.netbeans.editor.ext.java.JavaSyntaxSupport;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.Array;
import org.netbeans.jmi.javamodel.Attribute;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.GenericElement;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaEnum;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.PrimitiveTypeKindEnum;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeParameter;
import org.netbeans.jmi.javamodel.TypedElement;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.java.JMIUtils;
import org.netbeans.modules.editor.java.NbJMIResultItem;
import org.netbeans.modules.editor.java.NbJavaCompletionQuery;
import org.netbeans.modules.editor.java.NbJavaJMISyntaxSupport;
import org.netbeans.modules.javacore.JMManager;

public class NbJavaJMICompletionQuery
extends NbJavaCompletionQuery
implements JavaCompletionQuery.EnclosingResultProcessor {
    private static JMIItemFactory jmiItemFactory = new DefaultJMIItemFactory();

    public NbJavaJMICompletionQuery(boolean isJava15) {
        this.setJava15(isJava15);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletionQuery.Result getResult(JTextComponent component, JavaSyntaxSupport sup, boolean openingSource, int offset, JCExpression exp) {
        Completion completion = ((ExtEditorUI)Utilities.getEditorUI((JTextComponent)component)).getCompletion();
        boolean autoPopup = completion != null ? completion.provokedByAutoPopup : false;
        JMIUtils utils = JMIUtils.get(this.getBaseDocument());
        utils.beginTrans(false);
        try {
            ((JMManager)JMManager.getManager()).setSafeTrans(true);
            Context ctx = new Context(component, (NbJavaJMISyntaxSupport)sup.get(NbJavaJMISyntaxSupport.class), openingSource, offset, utils, autoPopup);
            boolean ok = ctx.resolveExp(exp);
            JavaResult javaResult = ok ? ctx.result : null;
            return javaResult;
        }
        finally {
            utils.endTrans(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletionQuery.Result getResult(JTextComponent component, JavaSyntaxSupport sup, boolean openingSource, int offset, JCExpression exp, JCExpression exp2) {
        Completion completion = ((ExtEditorUI)Utilities.getEditorUI((JTextComponent)component)).getCompletion();
        boolean autoPopup = completion != null ? completion.provokedByAutoPopup : false;
        JMIUtils utils = JMIUtils.get(this.getBaseDocument());
        utils.beginTrans(false);
        try {
            ((JMManager)JMManager.getManager()).setSafeTrans(true);
            Context ctx = new Context(component, (NbJavaJMISyntaxSupport)sup.get(NbJavaJMISyntaxSupport.class), openingSource, offset, utils, autoPopup);
            boolean ok = ctx.resolveExp(exp);
            JavaResult javaResult = ok ? ctx.result : null;
            return javaResult;
        }
        finally {
            utils.endTrans(false);
        }
    }

    public void processEnclosingResult(CompletionQuery.Result enclosingResult, JCExpression enclosingExp, CompletionQuery.Result regularResult) {
        int addIndex = 0;
        Iterator it = enclosingResult.getData().iterator();
        while (it.hasNext()) {
            Object elem = it.next();
            if (!(elem instanceof NbJMIResultItem.CallableFeatureResultItem)) continue;
            NbJMIResultItem.CallableFeatureResultItem callable = (NbJMIResultItem.CallableFeatureResultItem)elem;
            callable.setActiveParameterIndex(callable.getCurrentParamIndex());
            regularResult.getData().add(addIndex++, callable);
        }
    }

    protected void setJMIItemFactory(JMIItemFactory itemFactory) {
        jmiItemFactory = itemFactory;
    }

    public static JMIItemFactory getJMIItemFactory() {
        return jmiItemFactory;
    }

    public static class DefaultJMIItemFactory
    implements JMIItemFactory {
        public NbJMIResultItem.VarResultItem createVarResultItem(String varName, Type type, int modifiers) {
            return new NbJMIResultItem.VarResultItem(varName, type, modifiers);
        }

        public NbJMIResultItem.PackageResultItem createPackageResultItem(JavaPackage pkg) {
            return new NbJMIResultItem.PackageResultItem(pkg, false);
        }

        public NbJMIResultItem.ClassResultItem createClassResultItem(JavaClass cls, boolean addImport, boolean generateClassSkeleton) {
            return cls instanceof AnnotationType ? new NbJMIResultItem.AnnotationResultItem((AnnotationType)cls, false, addImport) : new NbJMIResultItem.ClassResultItem(cls, false, addImport, generateClassSkeleton);
        }

        public NbJMIResultItem.FieldResultItem createFieldResultItem(Field fld, JavaClass owner, ClassDefinition context) {
            return new NbJMIResultItem.FieldResultItem(fld, owner, context);
        }

        public NbJMIResultItem.MethodResultItem createMethodResultItem(Method mtd, JCExpression substituteExp, ClassDefinition context) {
            return new NbJMIResultItem.MethodResultItem(mtd, substituteExp, context);
        }

        public NbJMIResultItem.ConstructorResultItem createConstructorResultItem(Constructor ctr, JCExpression substituteExp) {
            return new NbJMIResultItem.ConstructorResultItem(ctr, substituteExp);
        }

        public NbJMIResultItem.AttributeResultItem createAttributeResultItem(Attribute attr) {
            return new NbJMIResultItem.AttributeResultItem(attr);
        }

        public NbJMIResultItem.StringResultItem createStringResultItem(String str) {
            return new NbJMIResultItem.StringResultItem(str);
        }

        public NbJMIResultItem createResultItem(Object obj, JCExpression substituteExp, ClassDefinition context, boolean isInstanceCreationCtx) {
            if (obj instanceof JavaPackage) {
                return this.createPackageResultItem((JavaPackage)obj);
            }
            if (obj instanceof JavaClass) {
                return this.createClassResultItem((JavaClass)obj, true, isInstanceCreationCtx);
            }
            if (obj instanceof Field) {
                return this.createFieldResultItem((Field)obj, null, context);
            }
            if (obj instanceof Method) {
                return this.createMethodResultItem((Method)obj, substituteExp, context);
            }
            if (obj instanceof Constructor) {
                return this.createConstructorResultItem((Constructor)obj, substituteExp);
            }
            if (obj instanceof Attribute) {
                return this.createAttributeResultItem((Attribute)obj);
            }
            if (obj instanceof String) {
                return this.createStringResultItem((String)obj);
            }
            return null;
        }
    }

    public static interface JMIItemFactory {
        public NbJMIResultItem.VarResultItem createVarResultItem(String var1, Type var2, int var3);

        public NbJMIResultItem.PackageResultItem createPackageResultItem(JavaPackage var1);

        public NbJMIResultItem.ClassResultItem createClassResultItem(JavaClass var1, boolean var2, boolean var3);

        public NbJMIResultItem.FieldResultItem createFieldResultItem(Field var1, JavaClass var2, ClassDefinition var3);

        public NbJMIResultItem.MethodResultItem createMethodResultItem(Method var1, JCExpression var2, ClassDefinition var3);

        public NbJMIResultItem.ConstructorResultItem createConstructorResultItem(Constructor var1, JCExpression var2);

        public NbJMIResultItem.AttributeResultItem createAttributeResultItem(Attribute var1);

        public NbJMIResultItem.StringResultItem createStringResultItem(String var1);

        public NbJMIResultItem createResultItem(Object var1, JCExpression var2, ClassDefinition var3, boolean var4);
    }

    public static class JavaResult
    extends CompletionQuery.AbstractResult {
        private JCExpression substituteExp;
        private int substituteOffset;
        private int substituteLength;
        private JTextComponent component;

        public JavaResult(JTextComponent component, List data, String title, JCExpression substituteExp, ClassDefinition context) {
            this(component, data, title, substituteExp, substituteExp.getTokenOffset(0), substituteExp.getTokenLength(0), context);
        }

        public JavaResult(JTextComponent component, List data, String title, JCExpression substituteExp, int substituteOffset, int substituteLength, ClassDefinition context) {
            super(JavaResult.convertData(data, substituteExp, context, substituteOffset), title);
            this.component = component;
            this.substituteExp = substituteExp;
            this.substituteOffset = substituteOffset;
            this.substituteLength = substituteLength;
        }

        private static List convertData(List dataList, JCExpression substituteExp, ClassDefinition context, int substituteOffset) {
            Iterator iter = dataList.iterator();
            ArrayList<NbJMIResultItem> ret = new ArrayList<NbJMIResultItem>();
            while (iter.hasNext()) {
                Object obj = iter.next();
                NbJMIResultItem item = obj instanceof CompletionQuery.ResultItem ? (NbJMIResultItem)obj : NbJavaJMICompletionQuery.getJMIItemFactory().createResultItem(obj, substituteExp, context, false);
                if (item == null) continue;
                item.setSubstituteOffset(substituteOffset);
                ret.add(item);
            }
            return ret;
        }

        protected JTextComponent getComponent() {
            return this.component;
        }

        protected int getSubstituteLength() {
            return this.substituteLength;
        }

        protected int getSubstituteOffset() {
            return this.substituteOffset;
        }

        protected JCExpression getSubstituteExp() {
            return this.substituteExp;
        }

        protected String getMainText(Object dataItem) {
            String text = null;
            if (dataItem instanceof NbJMIResultItem) {
                dataItem = ((NbJMIResultItem)dataItem).getAssociatedObject();
            }
            if (dataItem instanceof NamedElement) {
                text = ((NamedElement)dataItem).getName();
                if (dataItem instanceof JavaPackage) {
                    text = text.substring(text.lastIndexOf(46) + 1);
                }
            }
            return text;
        }

        protected String getCommonText(String prefix) {
            List data = this.getData();
            int cnt = data.size();
            int prefixLen = prefix.length();
            String commonText = null;
            for (int i = 0; i < cnt; ++i) {
                int commonInd;
                String mainText = this.getMainText(data.get(i));
                if (mainText == null || !mainText.startsWith(prefix)) continue;
                mainText = mainText.substring(prefixLen);
                if (commonText == null) {
                    commonText = mainText;
                }
                int minLen = Math.min(mainText.length(), commonText.length());
                for (commonInd = 0; commonInd < minLen && mainText.charAt(commonInd) == commonText.charAt(commonInd); ++commonInd) {
                }
                if (commonInd != 0) {
                    commonText = commonText.substring(0, commonInd);
                    continue;
                }
                return null;
            }
            return prefix + (commonText != null ? commonText : "");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean substituteCommonText(int dataIndex) {
            block8: {
                List data = this.getData();
                if (data.size() == 0) {
                    return false;
                }
                Object obj = this.getData().get(dataIndex);
                if (obj instanceof CompletionQuery.ResultItem) {
                    // empty if block
                }
                BaseDocument doc = (BaseDocument)this.component.getDocument();
                try {
                    String prefix = doc.getText(this.substituteOffset, this.substituteLength);
                    String commonText = this.getCommonText(prefix);
                    if (commonText == null) break block8;
                    if (this.substituteExp != null && (this.substituteExp.getExpID() == 10 || this.substituteExp.getExpID() == 11)) {
                        return true;
                    }
                    doc.atomicLock();
                    try {
                        doc.remove(this.substituteOffset, this.substituteLength);
                        doc.insertString(this.substituteOffset, commonText, null);
                    }
                    finally {
                        doc.atomicUnlock();
                    }
                }
                catch (BadLocationException e) {
                    // empty catch block
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean substituteText(int dataIndex, boolean shift) {
            Object actData = this.getData().get(dataIndex);
            if (actData instanceof CompletionQuery.ResultItem) {
                return ((CompletionQuery.ResultItem)actData).substituteText(this.component, this.substituteOffset, this.substituteLength, shift);
            }
            BaseDocument doc = (BaseDocument)this.component.getDocument();
            String text = null;
            int selectionStartOffset = -1;
            int selectionEndOffset = -1;
            Object replacement = this.getData().get(dataIndex);
            if (replacement instanceof JavaPackage) {
                text = ((JavaPackage)replacement).getName();
                text = text.substring(text.lastIndexOf(46) + 1);
            } else if (replacement instanceof JavaClass) {
                text = ((JavaClass)replacement).getName();
            } else if (replacement instanceof Field) {
                text = ((Field)replacement).getName();
            } else if (replacement instanceof CallableFeature) {
                CallableFeature mtd = (CallableFeature)replacement;
                switch (this.substituteExp != null ? this.substituteExp.getExpID() : -1) {
                    case 11: {
                        break;
                    }
                    case 10: {
                        Object o;
                        List parms = mtd.getParameters();
                        if (parms.size() == 0) {
                            text = ")";
                            break;
                        }
                        int ind = this.substituteExp.getParameterCount();
                        boolean addSpace = false;
                        Formatter f = doc.getFormatter();
                        if (f instanceof ExtFormatter && (o = ((ExtFormatter)f).getSettingValue("java-format-space-after-comma")) instanceof Boolean && ((Boolean)o).booleanValue()) {
                            addSpace = true;
                        }
                        try {
                            if (addSpace && (ind == 0 || this.substituteOffset > 0 && Character.isWhitespace(DocumentUtilities.getText((Document)doc, (int)(this.substituteOffset - 1), (int)1).charAt(0)))) {
                                addSpace = false;
                            }
                        }
                        catch (BadLocationException e) {
                            // empty catch block
                        }
                        if (ind >= parms.size()) break;
                        text = addSpace ? " " : "";
                        selectionStartOffset = text.length();
                        text = text + ((Parameter)parms.get(ind)).getName();
                        selectionEndOffset = text.length();
                        break;
                    }
                    default: {
                        Object o;
                        text = this.getMainText(replacement);
                        boolean addSpace = false;
                        Formatter f = doc.getFormatter();
                        if (f instanceof ExtFormatter && (o = ((ExtFormatter)f).getSettingValue("java-format-space-before-parenthesis")) instanceof Boolean && ((Boolean)o).booleanValue()) {
                            addSpace = true;
                        }
                        if (addSpace) {
                            text = text + ' ';
                        }
                        text = text + '(';
                        List parms = mtd.getParameters();
                        if (parms.size() > 0) {
                            selectionStartOffset = text.length();
                            text = text + ((Parameter)parms.get(0)).getName();
                            selectionEndOffset = text.length();
                            break;
                        }
                        text = text + ")";
                    }
                }
            }
            if (text != null) {
                doc.atomicLock();
                try {
                    CharSequence textToReplace = DocumentUtilities.getText((Document)doc, (int)this.substituteOffset, (int)this.substituteLength);
                    if (CharSequenceUtilities.textEquals((CharSequence)text, (CharSequence)textToReplace)) {
                        boolean bl = false;
                        return bl;
                    }
                    doc.remove(this.substituteOffset, this.substituteLength);
                    doc.insertString(this.substituteOffset, text, null);
                    if (selectionStartOffset >= 0) {
                        this.component.select(this.substituteOffset + selectionStartOffset, this.substituteOffset + selectionEndOffset);
                    }
                }
                catch (BadLocationException e) {
                }
                finally {
                    doc.atomicUnlock();
                }
            }
            return true;
        }
    }

    class Context {
        private JTextComponent component;
        private NbJavaJMISyntaxSupport sup;
        private boolean openingSource;
        private int endOffset;
        private boolean findType;
        private boolean staticOnly = true;
        private JavaPackage lastPkg;
        private Type lastType;
        private JavaResult result;
        private boolean isConstructor;
        private boolean isImport;
        private boolean isStaticImport;
        private boolean isGeneric;
        private Collection typeBounds;
        private boolean isAnnotation;
        private boolean isAnnotationOpen;
        private JavaClass curCls;
        private boolean isThisContext;
        private boolean superCall;
        private boolean autoPopup;
        private JMIUtils jmiUtils = null;

        public Context(JTextComponent component, NbJavaJMISyntaxSupport sup, boolean openingSource, int endOffset, JMIUtils utils, boolean autoPopup) {
            this.component = component;
            this.sup = sup;
            this.openingSource = openingSource;
            this.endOffset = endOffset;
            this.jmiUtils = utils;
            this.curCls = sup.getJavaClass(endOffset);
            if (this.curCls == null) {
                this.curCls = sup.getTopJavaClass();
            }
            this.autoPopup = autoPopup;
        }

        public void setFindType(boolean findType) {
            this.findType = findType;
        }

        protected Object clone() {
            return new Context(this.component, this.sup, this.openingSource, this.endOffset, this.jmiUtils, this.autoPopup);
        }

        private int getSwitchOffset(int caseOffset) {
            int offset = -1;
            try {
                JavaFormatSupport jfs = new JavaFormatSupport(null);
                TokenItem itm = jfs.findSwitch(this.sup.getTokenChain(caseOffset, caseOffset + 4));
                if (itm != null) {
                    int off = itm.getNext().getOffset();
                    off = Utilities.getFirstNonWhiteFwd((BaseDocument)NbJavaJMICompletionQuery.this.getBaseDocument(), (int)off);
                    int[] block = this.sup.findMatchingBlock(off, true);
                    if (block != null) {
                        offset = block[1] - 1;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return offset;
        }

        private String formatType(Type type, boolean useFullName, boolean appendDot, boolean appendStar) {
            StringBuffer sb = new StringBuffer();
            if (type != null) {
                if (type instanceof AnnotationType) {
                    sb.append('@');
                }
                if (useFullName) {
                    if (type instanceof ParameterizedType) {
                        ClassDefinition decl = ((ParameterizedType)type).getDeclaringClass();
                        if (decl != null) {
                            sb.append(this.formatType((Type)decl, useFullName, true, false));
                        } else {
                            String s = ((ParameterizedType)type).getDefinition().getName();
                            sb.append(s.substring(0, s.lastIndexOf(46) + 1));
                        }
                        sb.append(((ParameterizedType)type).getSimpleName());
                    } else {
                        sb.append(type.getName());
                    }
                } else {
                    sb.append(type instanceof JavaClass ? ((JavaClass)type).getSimpleName() : type.getName());
                }
            }
            if (appendDot) {
                sb.append('.');
            }
            if (appendStar) {
                sb.append('*');
            }
            return sb.toString();
        }

        private Type resolveType(JCExpression exp, boolean propagateIsStatic) {
            Context ctx = (Context)this.clone();
            ctx.setFindType(true);
            ctx.isGeneric = this.isGeneric;
            Type typ = null;
            if (ctx.resolveExp(exp)) {
                typ = ctx.lastType;
                if (propagateIsStatic) {
                    this.staticOnly = ctx.staticOnly;
                }
            }
            if (JMIUtils.debugCompletionFailures && typ instanceof UnresolvedClass) {
                System.err.println("resolveType: unresolved type " + typ.getName() + " returned when resolving " + exp);
                Thread.dumpStack();
            }
            return typ;
        }

        boolean resolveExp(JCExpression exp) {
            boolean lastDot = false;
            boolean ok = true;
            switch (exp.getExpID()) {
                case 5: {
                    lastDot = true;
                }
                case 4: {
                    int parmCnt = exp.getParameterCount();
                    for (int i = 0; i < parmCnt && ok; ++i) {
                        ok = this.resolveItem(exp.getParameter(i), i == 0, !lastDot && i == parmCnt - 1);
                        this.isThisContext = this.superCall;
                        this.superCall = false;
                        if (!JMIUtils.debugCompletionFailures || ok || this.findType) continue;
                        System.err.println("resolveItem: failed when resolving " + exp.getParameter(i) + "\n    lastType=" + this.lastType + "\n    lastPkg=" + this.lastPkg);
                        Thread.dumpStack();
                    }
                    if (!ok || !lastDot) break;
                    int tokenCntM1 = exp.getTokenCount() - 1;
                    int substPos = exp.getTokenOffset(tokenCntM1) + exp.getTokenLength(tokenCntM1);
                    if (this.lastType != null) {
                        if (this.lastType instanceof ClassDefinition) {
                            ArrayList<Object> res = new ArrayList<Object>();
                            if (this.openingSource) {
                                res.add(this.lastType);
                            } else if (this.isAnnotationOpen) {
                                res.add(NbJavaJMICompletionQuery.getJMIItemFactory().createVarResultItem("class", (Type)this.jmiUtils.getExactClass("java.lang.Class"), 25));
                                res.addAll(this.findConstMembers(this.lastType, "", false, this.curCls));
                            } else if (!(this.isConstructor || this.isImport && !this.isStaticImport)) {
                                if (this.staticOnly && !this.isImport) {
                                    res.add(NbJavaJMICompletionQuery.getJMIItemFactory().createVarResultItem("class", (Type)this.jmiUtils.getExactClass("java.lang.Class"), 25));
                                }
                                res.addAll(this.findFieldsMethodsAndInnerClasses(this.lastType, "", false, false, this.curCls, this.staticOnly || this.isStaticImport, this.isThisContext, exp, null, false, false));
                            } else {
                                res.addAll(this.findInnerClasses(this.lastType, "", false, false, this.curCls, this.isThisContext, true, true, this.isConstructor));
                            }
                            this.result = new JavaResult(this.component, res, this.formatType(this.lastType, true, true, true), exp, substPos, 0, (ClassDefinition)(this.lastType instanceof JavaClass ? JMIUtils.getSourceElementIfExists((ClassDefinition)((JavaClass)this.lastType)) : this.curCls));
                            break;
                        }
                        if (!(this.lastType instanceof PrimitiveType)) break;
                        List<NbJMIResultItem.VarResultItem> res = Collections.singletonList(NbJavaJMICompletionQuery.getJMIItemFactory().createVarResultItem("class", (Type)this.jmiUtils.getExactClass("java.lang.Class"), 25));
                        this.result = new JavaResult(this.component, res, this.formatType(this.lastType, true, true, true), exp, substPos, 0, (ClassDefinition)this.curCls);
                        break;
                    }
                    String searchPkg = this.lastPkg.getName() + '.';
                    List<Object> res = new ArrayList<JavaPackage>();
                    if (this.openingSource) {
                        res.add(this.lastPkg);
                    } else if (this.isAnnotation) {
                        res.addAll(this.jmiUtils.findAnnotations(this.lastPkg, "", false, this.curCls, false));
                    } else {
                        int index;
                        CharSequence text = null;
                        try {
                            int firstTokenIdx = exp.getTokenOffset(0);
                            int cmdStartIdx = this.sup.getLastCommandSeparator(firstTokenIdx);
                            if (cmdStartIdx < 0) {
                                text = DocumentUtilities.getText((Document)this.sup.getDocument(), (int)0, (int)firstTokenIdx);
                                cmdStartIdx = CharSequenceUtilities.lastIndexOf((CharSequence)text, (int)10);
                                if (cmdStartIdx != -1) {
                                    text = text.subSequence(0, cmdStartIdx + 1);
                                }
                            } else {
                                text = DocumentUtilities.getText((Document)this.sup.getDocument(), (int)cmdStartIdx, (int)(firstTokenIdx - cmdStartIdx));
                            }
                        }
                        catch (BadLocationException e) {
                            // empty catch block
                        }
                        if (!(text == null || (index = CharSequenceUtilities.indexOf(text, (CharSequence)"package")) != -1 && text.length() > index + 8 && Character.isWhitespace(text.charAt(index + 7)))) {
                            res.addAll(this.jmiUtils.findClasses(this.lastPkg, "", false, false, this.isImport, this.curCls, !this.isGeneric, this.isConstructor));
                        }
                    }
                    res.addAll(this.jmiUtils.findPackages(searchPkg, false, false, !this.isGeneric));
                    if (this.isGeneric) {
                        res = this.filterGenericTypeArguments(res);
                    }
                    this.result = new JavaResult(this.component, res, (this.isAnnotation ? "@" : "") + searchPkg + '*', exp, substPos, 0, (ClassDefinition)this.curCls);
                    break;
                }
                case 15: {
                    if (this.autoPopup) break;
                    List res = this.findInnerClasses((Type)this.curCls, "", false, true, this.curCls, false, true, true, true);
                    res.addAll(this.jmiUtils.getImportedInnerClasses("", false, this.curCls, true, true, true));
                    res.addAll(this.jmiUtils.findClasses(null, "", false, false, false, this.curCls, true, true));
                    this.result = new JavaResult(this.component, res, "*", exp, this.endOffset, 0, (ClassDefinition)this.curCls);
                    break;
                }
                case 23: {
                    CompletionQuery.Result r;
                    int off = this.getSwitchOffset(exp.getTokenOffset(0));
                    if (off > -1 && (r = NbJavaJMICompletionQuery.this.query(this.component, off, (SyntaxSupport)this.sup, true)) != null && r.getData().size() > 0) {
                        Object itm = r.getData().get(0);
                        Type typ = null;
                        if (itm instanceof NbJMIResultItem.VarResultItem) {
                            typ = ((NbJMIResultItem.VarResultItem)itm).getType();
                        } else {
                            if (itm instanceof NbJMIResultItem) {
                                itm = ((NbJMIResultItem)itm).getAssociatedObject();
                            }
                            if (itm instanceof TypedElement) {
                                typ = ((TypedElement)itm).getType();
                            }
                        }
                        if (typ != null) {
                            if (typ instanceof ParameterizedType) {
                                typ = ((ParameterizedType)typ).getDefinition();
                            }
                            String name = "";
                            int constOffset = this.endOffset;
                            int constLen = 0;
                            JCExpression eexp = exp.getParameter(0);
                            if (eexp.getExpID() == 1) {
                                name = eexp.getTokenText(0);
                                constOffset = eexp.getTokenOffset(0);
                                constLen = eexp.getTokenLength(0);
                            }
                            if (typ instanceof JavaEnum) {
                                List res = this.jmiUtils.findEnumConstants((JavaEnum)typ, name, false, true, true);
                                this.result = new JavaResult(this.component, res, this.formatType(typ, true, false, false), exp, constOffset, constLen, (ClassDefinition)this.curCls);
                                break;
                            }
                        }
                    }
                    exp = exp.getParameter(0);
                }
                default: {
                    this.resolveItem(exp, true, true);
                }
            }
            return ok;
        }

        boolean resolveItem(JCExpression item, boolean first, boolean last) {
            boolean cont = true;
            boolean methodOpen = false;
            block0 : switch (item.getExpID()) {
                case 19: {
                    this.lastType = this.jmiUtils.resolveType("java.lang.Object");
                    break;
                }
                case 0: {
                    if (first) {
                        this.lastType = this.jmiUtils.resolveType(item.getType());
                        this.staticOnly = false;
                        break;
                    }
                    cont = false;
                    break;
                }
                case 1: {
                    switch (item.getTokenID(0).getNumericID()) {
                        case 108: {
                            if (first) {
                                if (this.curCls == null) break block0;
                                this.lastType = this.curCls;
                                this.staticOnly = false;
                                break;
                            }
                            this.staticOnly = false;
                            break;
                        }
                        case 105: {
                            if (first) {
                                JavaClass cls = this.curCls;
                                if (cls == null || (cls = cls.getSuperClass()) == null) break block0;
                                this.lastType = cls;
                                this.staticOnly = false;
                                this.superCall = true;
                                break;
                            }
                            cont = false;
                            break;
                        }
                        case 77: {
                            if (!first) {
                                this.lastType = this.jmiUtils.getExactClass("java.lang.Class");
                                this.staticOnly = false;
                                break;
                            }
                            cont = false;
                            break;
                        }
                        default: {
                            String var = item.getTokenText(0);
                            int varPos = item.getTokenOffset(0);
                            if (first) {
                                List sf;
                                if (last && !this.findType) {
                                    List<NbJMIResultItem.StringResultItem> res = new ArrayList<Type>();
                                    if (this.isAnnotation) {
                                        res.addAll(this.jmiUtils.findAnnotations(null, var, this.openingSource, this.openingSource ? null : this.curCls, false));
                                    } else if (this.isAnnotationOpen) {
                                        res.addAll(this.findConstMembers((Type)this.curCls, var, this.openingSource, this.openingSource ? null : this.curCls));
                                        if (this.lastType instanceof JavaEnum) {
                                            List l = this.jmiUtils.findEnumConstants((JavaEnum)this.lastType, var, false, false, true);
                                            Iterator it = l.iterator();
                                            while (it.hasNext()) {
                                                res.add((NbJMIResultItem.StringResultItem)((Object)jmiItemFactory.createFieldResultItem((Field)it.next(), (JavaClass)((JavaEnum)this.lastType), (ClassDefinition)this.curCls)));
                                            }
                                        } else if (this.lastType instanceof PrimitiveType && ((PrimitiveType)this.lastType).getKind() == PrimitiveTypeKindEnum.BOOLEAN) {
                                            if (JMIUtils.startsWith("true", var)) {
                                                res.add(jmiItemFactory.createStringResultItem("true"));
                                            }
                                            if (JMIUtils.startsWith("false", var)) {
                                                res.add(jmiItemFactory.createStringResultItem("false"));
                                            }
                                        }
                                    } else if (!(this.curCls == null || this.isGeneric || this.isConstructor || this.isImport)) {
                                        Collection local = this.sup.getLocalVariableNames(var, varPos, this.openingSource);
                                        Iterator it = local.iterator();
                                        while (it.hasNext()) {
                                            String name = (String)it.next();
                                            Type t = (Type)this.sup.findType(name, varPos);
                                            if (t == null) continue;
                                            res.add((NbJMIResultItem.StringResultItem)((Object)NbJavaJMICompletionQuery.getJMIItemFactory().createVarResultItem(name, t, 0)));
                                        }
                                        res.addAll(this.findFieldsMethodsAndInnerClasses((Type)this.curCls, var, this.openingSource, true, this.curCls, this.sup.isStaticBlock(varPos), true, item, local, true, false));
                                        res.addAll(this.findStaticallyImportedFeatures(var, this.openingSource, this.curCls, true));
                                    }
                                    if (var.length() > 0 && !this.isImport) {
                                        if (this.openingSource) {
                                            res.add((NbJMIResultItem.StringResultItem)this.sup.getTypeFromName(var, true, this.curCls, false));
                                        } else if (!this.isAnnotation) {
                                            if (this.isGeneric || this.isConstructor) {
                                                res.addAll(this.findInnerClasses((Type)this.curCls, var, false, true, this.curCls, true, !this.isGeneric, !this.isGeneric, this.isConstructor));
                                            }
                                            res.addAll(this.jmiUtils.getImportedInnerClasses(var, false, this.curCls, true, !this.isGeneric, this.isConstructor));
                                            res.addAll(this.jmiUtils.findClasses(null, var, false, false, false, this.curCls, !this.isGeneric, this.isConstructor));
                                        }
                                    }
                                    res.addAll(this.jmiUtils.findPackages(var, this.openingSource, false, true));
                                    if (this.isGeneric) {
                                        res = this.filterGenericTypeArguments(res);
                                    }
                                    this.result = new JavaResult(this.component, res, (this.isAnnotation ? "@" : "") + var + '*', item, (ClassDefinition)this.curCls);
                                    break;
                                }
                                this.lastType = (Type)this.sup.findType(var, varPos);
                                if (this.lastType != null) {
                                    if (this.isGeneric) {
                                        this.lastType = null;
                                    } else {
                                        this.staticOnly = false;
                                    }
                                    if (!JMIUtils.debugCompletionFailures || !(this.lastType instanceof UnresolvedClass)) break block0;
                                    System.err.println("resolveItem: unresolved type " + this.lastType.getName() + " returned when resolving type of variable " + var);
                                    Thread.dumpStack();
                                    break;
                                }
                                this.lastPkg = this.jmiUtils.getExactPackage(var);
                                if (this.lastPkg != null) break block0;
                                Type typ = this.sup.getTypeFromName(var, true, this.curCls, !this.openingSource);
                                if (typ == null && (sf = this.jmiUtils.getStaticallyImportedFields(var, true, this.openingSource ? null : this.curCls, true)).size() > 0) {
                                    typ = ((Field)sf.get(0)).getType();
                                    this.staticOnly = false;
                                }
                                if (typ != null) {
                                    this.lastType = typ;
                                    break;
                                }
                                cont = false;
                                break;
                            }
                            if (this.lastType != null) {
                                if (this.lastType instanceof ClassDefinition) {
                                    if (this.findType || !last) {
                                        JavaClass cls;
                                        boolean inner = false;
                                        if (this.staticOnly && this.lastType instanceof JavaClass && (cls = ((JavaClass)this.lastType).getInnerClass(var, true)) != null) {
                                            this.lastType = cls;
                                            inner = true;
                                        }
                                        if (inner) break block0;
                                        if (this.lastType instanceof ClassDefinition) {
                                            List fldList = this.jmiUtils.findFields(this.lastType, var, true, false, this.curCls, this.staticOnly, this.isThisContext, false, false);
                                            if (fldList.size() > 0) {
                                                Field fld = (Field)fldList.get(0);
                                                this.lastType = fld.getType();
                                                this.staticOnly = false;
                                                break;
                                            }
                                            this.lastType = null;
                                            cont = false;
                                            break;
                                        }
                                        cont = false;
                                        break;
                                    }
                                    ArrayList<NbJMIResultItem.VarResultItem> res = new ArrayList<NbJMIResultItem.VarResultItem>();
                                    if (this.isAnnotationOpen) {
                                        if (JMIUtils.startsWith("class", var)) {
                                            res.add(NbJavaJMICompletionQuery.getJMIItemFactory().createVarResultItem("class", (Type)this.jmiUtils.getExactClass("java.lang.Class"), 25));
                                        }
                                        res.addAll(this.findConstMembers(this.lastType, var, this.openingSource, this.curCls));
                                    } else if (!this.isImport || this.isStaticImport) {
                                        if (!this.isImport && this.staticOnly) {
                                            if (JMIUtils.startsWith("class", var)) {
                                                res.add(NbJavaJMICompletionQuery.getJMIItemFactory().createVarResultItem("class", (Type)this.jmiUtils.getExactClass("java.lang.Class"), 25));
                                            }
                                        }
                                        res.addAll(this.findFieldsMethodsAndInnerClasses(this.lastType, var, this.openingSource, false, this.curCls, this.staticOnly || this.isStaticImport, this.isThisContext, item, null, false, false));
                                    } else {
                                        res.addAll(this.findInnerClasses(this.lastType, var, this.openingSource, false, this.curCls, this.isThisContext, true, true, false));
                                    }
                                    this.result = new JavaResult(this.component, res, this.formatType(this.lastType, true, true, false) + var + '*', item, (ClassDefinition)(this.lastType instanceof JavaClass ? JMIUtils.getSourceElementIfExists((ClassDefinition)((JavaClass)this.lastType)) : this.curCls));
                                    break;
                                }
                                if (!(this.lastType instanceof PrimitiveType)) break block0;
                                List<NbJMIResultItem.VarResultItem> res = Collections.singletonList(NbJavaJMICompletionQuery.getJMIItemFactory().createVarResultItem("class", (Type)this.jmiUtils.getExactClass("java.lang.Class"), 25));
                                this.result = new JavaResult(this.component, res, this.formatType(this.lastType, true, true, true), item, (ClassDefinition)this.curCls);
                                break;
                            }
                            String searchName = this.lastPkg.getName() + '.' + var;
                            if (this.findType || !last) {
                                this.lastPkg = this.jmiUtils.getExactPackage(searchName);
                                if (this.lastPkg != null) break block0;
                                JavaClass cls = this.jmiUtils.getExactClass(searchName);
                                if (cls != null) {
                                    this.lastType = cls;
                                    break;
                                }
                                this.lastType = null;
                                cont = false;
                                break;
                            }
                            if (!last) break block0;
                            String searchPkg = this.lastPkg.getName() + '.' + var;
                            List res = new ArrayList();
                            if (!this.isAnnotation) {
                                res.addAll(this.jmiUtils.getImportedInnerClasses(var, false, this.curCls, this.isThisContext, !this.isGeneric, this.isConstructor));
                                res.addAll(this.jmiUtils.findClasses(this.lastPkg, var, false, false, false, this.curCls, !this.isGeneric, this.isConstructor));
                            }
                            if (this.isAnnotation || this.isImport) {
                                res.addAll(this.jmiUtils.findAnnotations(this.lastPkg, var, false, this.openingSource ? null : this.curCls, !this.isGeneric));
                            }
                            res.addAll(this.jmiUtils.findPackages(searchPkg, false, false, !this.isGeneric));
                            if (this.isGeneric) {
                                res = this.filterGenericTypeArguments(res);
                            }
                            this.result = new JavaResult(this.component, res, (this.isAnnotation ? "@" : "") + searchPkg + '*', item, (ClassDefinition)this.curCls);
                            break;
                        }
                    }
                    break;
                }
                case 7: {
                    Type arrType = this.resolveType(item.getParameter(0), true);
                    cont = false;
                    if (arrType == null) break;
                    if (item.getParameterCount() == 2) {
                        Type arrIdxType = this.resolveType(item.getParameter(1), false);
                        if (!(arrType instanceof Array) || arrIdxType == null || !(arrIdxType instanceof PrimitiveType) || !((PrimitiveType)arrIdxType).getKind().equals(PrimitiveTypeKindEnum.INT)) break;
                        this.lastType = ((Array)arrType).getType();
                        this.staticOnly = false;
                        cont = true;
                        break;
                    }
                    if (!this.staticOnly) break;
                    this.lastType = this.jmiUtils.resolveArray(arrType);
                    if ("new".equals(item.getTokenText(0))) {
                        this.staticOnly = false;
                    }
                    cont = true;
                    break;
                }
                case 17: {
                    this.lastType = this.resolveType(item.getParameter(0), false);
                    if (this.lastType instanceof JavaClass && !((JavaClass)this.lastType).getTypeParameters().isEmpty()) {
                        ArrayList<Type> params = new ArrayList<Type>(item.getParameterCount() - 1);
                        for (int i = 1; i < item.getParameterCount(); ++i) {
                            params.add(this.resolveType(item.getParameter(i), false));
                        }
                        this.lastType = this.jmiUtils.resolveParameterizedType((JavaClass)this.lastType, params);
                    }
                    if (!this.isConstructor || this.findType || !(this.lastType instanceof ParameterizedType)) break;
                    List<NbJMIResultItem.ClassResultItem> ret = Collections.singletonList(new NbJMIResultItem.ClassResultItem((JavaClass)((ParameterizedType)this.lastType), true, true, true));
                    this.result = new JavaResult(this.component, ret, this.formatType(this.lastType, false, false, true), item, this.endOffset, 0, (ClassDefinition)this.curCls);
                    break;
                }
                case 16: {
                    this.lastType = this.jmiUtils.resolveType("boolean");
                    break;
                }
                case 2: {
                    if (!this.findType) {
                        ArrayList<NbJMIResultItem.VarResultItem> res = new ArrayList<NbJMIResultItem.VarResultItem>();
                        int pos = item.getTokenOffset(0);
                        Collection local = this.sup.getLocalVariableNames("", pos, this.openingSource);
                        Iterator it = local.iterator();
                        while (it.hasNext()) {
                            String name = (String)it.next();
                            Type t = (Type)this.sup.findType(name, pos);
                            if (t == null) continue;
                            res.add(NbJavaJMICompletionQuery.getJMIItemFactory().createVarResultItem(name, t, 0));
                        }
                        res.addAll(this.findFieldsMethodsAndInnerClasses((Type)this.curCls, "", this.openingSource, true, this.curCls, this.sup.isStaticBlock(pos), true, item, local, true, false));
                        res.addAll(this.findStaticallyImportedFeatures("", this.openingSource, this.curCls, true));
                        res.addAll(this.jmiUtils.findPackages("", this.openingSource, false, true));
                        this.result = new JavaResult(this.component, res, "*", item, this.endOffset, 0, (ClassDefinition)this.curCls);
                    }
                    switch (item.getTokenID(0).getNumericID()) {
                        case 17: 
                        case 36: 
                        case 37: 
                        case 38: 
                        case 39: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 46: {
                            if (item.getParameterCount() <= 0) break;
                            this.lastType = this.resolveType(item.getParameter(0), false);
                            this.staticOnly = false;
                            break;
                        }
                        case 18: 
                        case 19: 
                        case 33: 
                        case 34: 
                        case 35: 
                        case 47: 
                        case 61: 
                        case 62: {
                            this.lastType = this.jmiUtils.resolveType("boolean");
                            break;
                        }
                        case 20: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 27: 
                        case 28: 
                        case 29: 
                        case 30: 
                        case 50: {
                            switch (item.getParameterCount()) {
                                case 2: {
                                    Type typ1 = this.resolveType(item.getParameter(0), false);
                                    Type typ2 = this.resolveType(item.getParameter(1), false);
                                    if (typ1 == null || typ2 == null) break;
                                    this.lastType = this.sup.getCommonType(typ1, typ2);
                                    this.staticOnly = false;
                                    break;
                                }
                                case 1: {
                                    this.lastType = this.resolveType(item.getParameter(0), false);
                                    this.staticOnly = false;
                                }
                            }
                            break;
                        }
                        case 52: {
                            if (item.getParameterCount() < 2) break;
                            this.lastType = this.resolveType(item.getParameter(1), false);
                            this.staticOnly = false;
                        }
                    }
                    break;
                }
                case 3: {
                    if (item.getParameterCount() <= 0) break;
                    this.lastType = this.resolveType(item.getParameter(0), false);
                    break;
                }
                case 13: {
                    this.lastType = this.resolveType(item.getParameter(0), false);
                    this.staticOnly = false;
                    break;
                }
                case 14: {
                    this.lastType = this.jmiUtils.resolveType(item.getType());
                    break;
                }
                case 9: {
                    cont = this.resolveItem(item.getParameter(0), first, last);
                    break;
                }
                case 22: {
                    this.isImport = true;
                    if (item.getParameterCount() == 2) {
                        this.isStaticImport = true;
                        cont = this.resolveExp(item.getParameter(1));
                        break;
                    }
                    if (item.getParameterCount() != 1) break;
                    cont = this.resolveExp(item.getParameter(0));
                    break;
                }
                case 18: {
                    List args;
                    this.isGeneric = true;
                    int lastIdx = item.getParameterCount() - 1;
                    Type typ = this.resolveType(item.getParameter(0), false);
                    List list = args = typ instanceof GenericElement ? ((GenericElement)typ).getTypeParameters() : Collections.EMPTY_LIST;
                    if (args.size() > 0) {
                        List tList = this.getTypeList(item, 1, false);
                        JCExpression lastParam = item.getParameter(lastIdx);
                        if (lastParam.getTokenCount() > 0 && lastParam.getTokenText(0).length() == 0) {
                            --lastIdx;
                            if (tList != null) {
                                tList.remove(tList.size() - 1);
                            }
                        }
                        if (lastIdx < args.size() && lastIdx < item.getTokenCount()) {
                            List tmp = this.jmiUtils.findMatchingTypes((TypeParameter)args.get(lastIdx), null, true);
                            tmp.addAll(this.jmiUtils.findPackages("", this.openingSource, false, true));
                            String parmStr = this.formatTypeList(tList, true);
                            this.result = new JavaResult(this.component, tmp, this.formatType(typ, true, false, false) + '<' + parmStr + '>', item, this.endOffset, 0, (ClassDefinition)this.curCls);
                            break;
                        }
                        if (lastIdx > args.size() || lastIdx < item.getTokenCount()) break;
                        TypeParameter tp = (TypeParameter)args.get(lastIdx - 1);
                        this.typeBounds = new ArrayList();
                        this.typeBounds.add(tp.getSuperClass());
                        this.typeBounds.addAll(tp.getInterfaces());
                        this.resolveExp(item.getParameter(lastIdx));
                        break;
                    }
                    this.isGeneric = false;
                    this.resolveExp(item.getParameter(1));
                    break;
                }
                case 12: {
                    this.isConstructor = true;
                    cont = this.resolveExp(item.getParameter(0));
                    this.staticOnly = false;
                    break;
                }
                case 20: {
                    if (item.getParameterCount() == 0) {
                        List res = this.jmiUtils.findAnnotations(null, "", false, this.openingSource ? null : this.curCls, false);
                        res.addAll(this.jmiUtils.findPackages("", false, false, true));
                        this.result = new JavaResult(this.component, res, "@*", item, this.endOffset, 0, (ClassDefinition)this.curCls);
                        break;
                    }
                    this.isAnnotation = true;
                    cont = this.resolveExp(item.getParameter(0));
                    break;
                }
                case 21: {
                    Type aType = this.resolveType(item.getParameter(0), false);
                    if (!(aType instanceof AnnotationType)) break;
                    AnnotationType annType = (AnnotationType)aType;
                    int parCnt = item.getParameterCount();
                    if (parCnt == 1 || parCnt == item.getTokenCount()) {
                        Set usedMemberNames = this.getAnnotationMemberNames(item);
                        List res = this.findAnnotationMembers(annType, "", usedMemberNames);
                        if (parCnt == 1 && res.size() == 1) {
                            this.lastType = ((Attribute)((NbJMIResultItem.AttributeResultItem)res.get(0)).getAssociatedObject()).getType();
                            if (this.lastType instanceof ParameterizedType) {
                                this.lastType = ((ParameterizedType)this.lastType).getDefinition();
                            }
                            res.addAll(this.findConstMembers((Type)this.curCls, "", false, this.openingSource ? null : this.curCls));
                            res.addAll(this.jmiUtils.findPackages("", false, false, false));
                            if (this.lastType instanceof JavaEnum) {
                                List l = this.jmiUtils.findEnumConstants((JavaEnum)this.lastType, "", false, false, true);
                                Iterator it = l.iterator();
                                while (it.hasNext()) {
                                    res.add(jmiItemFactory.createFieldResultItem((Field)it.next(), (JavaClass)((JavaEnum)this.lastType), (ClassDefinition)this.curCls));
                                }
                            } else if (this.lastType instanceof PrimitiveType && ((PrimitiveType)this.lastType).getKind() == PrimitiveTypeKindEnum.BOOLEAN) {
                                res.add(jmiItemFactory.createStringResultItem("true"));
                                res.add(jmiItemFactory.createStringResultItem("false"));
                            }
                        }
                        this.result = new JavaResult(this.component, res, this.formatType((Type)annType, true, false, false) + "(*)", item, this.endOffset, 0, (ClassDefinition)this.curCls);
                        break;
                    }
                    if (parCnt > 1) {
                        JCExpression lastMember = item.getParameter(parCnt - 1);
                        switch (lastMember.getExpID()) {
                            case 2: {
                                if (lastMember.getParameterCount() != 2) break;
                                this.isAnnotationOpen = true;
                                List annMembers = this.jmiUtils.findAnnotationMembers(annType, lastMember.getParameter(0).getTokenText(0), true, false, false);
                                if (annMembers.size() > 0) {
                                    this.lastType = ((Attribute)annMembers.get(0)).getType();
                                    if (this.lastType instanceof ParameterizedType) {
                                        this.lastType = ((ParameterizedType)this.lastType).getDefinition();
                                    }
                                }
                                this.resolveExp(lastMember.getParameter(1));
                                break;
                            }
                            case 1: {
                                Set usedMemberNames = this.getAnnotationMemberNames(item);
                                String name = lastMember.getTokenText(0);
                                List res = this.findAnnotationMembers(annType, name, usedMemberNames);
                                List lst = this.jmiUtils.findAnnotationMembers(annType, "", false, false, false);
                                if (lst.size() == 1) {
                                    this.lastType = ((Attribute)lst.get(0)).getType();
                                    if (this.lastType instanceof ParameterizedType) {
                                        this.lastType = ((ParameterizedType)this.lastType).getDefinition();
                                    }
                                    res.addAll(this.findConstMembers((Type)this.curCls, name, false, this.openingSource ? null : this.curCls));
                                    if (name.length() > 0) {
                                        res.addAll(this.jmiUtils.findClasses(null, name, false, false, true, this.curCls, false, false));
                                    }
                                    res.addAll(this.jmiUtils.findPackages(name, false, false, false));
                                    if (this.lastType instanceof JavaEnum) {
                                        List l = this.jmiUtils.findEnumConstants((JavaEnum)this.lastType, name, false, false, true);
                                        Iterator it = l.iterator();
                                        while (it.hasNext()) {
                                            res.add(jmiItemFactory.createFieldResultItem((Field)it.next(), (JavaClass)((JavaEnum)this.lastType), (ClassDefinition)this.curCls));
                                        }
                                    } else if (this.lastType instanceof PrimitiveType && ((PrimitiveType)this.lastType).getKind() == PrimitiveTypeKindEnum.BOOLEAN) {
                                        if (JMIUtils.startsWith("true", name)) {
                                            res.add(jmiItemFactory.createStringResultItem("true"));
                                        }
                                        if (JMIUtils.startsWith("false", name)) {
                                            res.add(jmiItemFactory.createStringResultItem("false"));
                                        }
                                    }
                                }
                                this.result = new JavaResult(this.component, res, this.formatType((Type)annType, true, false, false) + "(*)", lastMember, (ClassDefinition)this.curCls);
                                break;
                            }
                            case 4: 
                            case 5: {
                                this.isAnnotationOpen = true;
                                this.resolveExp(lastMember);
                            }
                        }
                    }
                    break;
                }
                case 10: {
                    methodOpen = true;
                }
                case 11: {
                    JavaClass cls;
                    JCExpression mtdNameExp = item.getParameter(0);
                    String mtdName = mtdNameExp.getTokenText(0);
                    List genericParams = null;
                    if (this.isConstructor && "<".equals(mtdName) && mtdNameExp.getParameterCount() > 0) {
                        mtdName = mtdNameExp.getParameter(0).getTokenText(0);
                        if (mtdNameExp.getParameterCount() > 1) {
                            genericParams = this.getTypeList(mtdNameExp, 1, false);
                        }
                    }
                    if ("this".equals(mtdName) && item.getTokenCount() > 0 && this.curCls != null) {
                        this.isConstructor = true;
                        mtdName = this.curCls.getName();
                    }
                    if ("super".equals(mtdName) && item.getTokenCount() > 0 && (cls = this.curCls) != null && (cls = cls.getSuperClass()) != null) {
                        if (cls instanceof ParameterizedType) {
                            cls = ((ParameterizedType)cls).getDefinition();
                        }
                        this.isConstructor = true;
                        this.superCall = true;
                        mtdName = cls.getName();
                    }
                    if (this.isConstructor) {
                        Object type = null;
                        if (first) {
                            Iterator iter;
                            type = this.lastType instanceof JavaClass ? ((iter = this.jmiUtils.findInnerClasses(this.lastType, mtdName, this.openingSource, true, this.sup.getJavaClass(item.getTokenOffset(0)), false, false, false, false).iterator()).hasNext() ? (Type)iter.next() : null) : this.sup.getTypeFromName(mtdName, true, this.sup.getJavaClass(item.getTokenOffset(0)), !this.openingSource);
                        } else if (last && this.lastPkg != null) {
                            type = this.jmiUtils.getExactClass(mtdName, this.lastPkg.getName());
                        } else if (this.lastType != null) {
                            type = last ? this.jmiUtils.getExactClass(mtdName, this.lastType.getName()) : this.lastType;
                        }
                        if (type instanceof JavaClass) {
                            this.lastType = type instanceof ParameterizedType && genericParams == null ? type : this.jmiUtils.resolveParameterizedType((JavaClass)type, genericParams);
                            List ctrList = this.jmiUtils.findConstructors(this.lastType, this.openingSource ? null : this.curCls, this.superCall);
                            List typeList = this.getTypeList(item, 1, true);
                            if ((ctrList = this.sup.filterMethods(ctrList, typeList, methodOpen)).size() > 0 && last && !this.findType) {
                                String parmStr = this.formatTypeList(typeList, methodOpen);
                                this.result = new JavaResult(this.component, ctrList, this.formatType(this.lastType, true, false, false) + '(' + parmStr + ')', item, (ClassDefinition)(this.lastType instanceof JavaClass ? JMIUtils.getSourceElementIfExists((ClassDefinition)((JavaClass)this.lastType)) : this.curCls));
                            }
                            this.staticOnly = false;
                        } else {
                            this.isConstructor = false;
                        }
                    }
                    if (!this.isConstructor) {
                        if (first && this.curCls != null) {
                            this.lastType = this.curCls;
                            this.isThisContext = true;
                        }
                        if (this.lastType != null) {
                            List mtdList = this.jmiUtils.findMethods(this.lastType, mtdName, true, first, this.openingSource ? null : this.curCls, false, this.isThisContext, null, false, last && !this.findType);
                            mtdList.addAll(this.jmiUtils.getStaticallyImportedMethods(mtdName, true, this.openingSource ? null : this.curCls, this.isThisContext));
                            List typeList = this.getTypeList(item, 1, true);
                            mtdList = this.sup.filterMethods(mtdList, typeList, methodOpen);
                            if (mtdList.size() > 0) {
                                if (last && !this.findType) {
                                    String parmStr = this.formatTypeList(typeList, methodOpen);
                                    this.result = new JavaResult(this.component, mtdList, this.formatType(this.lastType, true, true, false) + mtdName + '(' + parmStr + ')', item, (ClassDefinition)(this.lastType instanceof JavaClass ? JMIUtils.getSourceElementIfExists((ClassDefinition)((JavaClass)this.lastType)) : this.curCls));
                                } else {
                                    this.lastType = ((Method)mtdList.get(0)).getType();
                                    this.staticOnly = false;
                                }
                            } else {
                                this.lastType = null;
                                cont = false;
                            }
                        } else {
                            this.lastPkg = null;
                            cont = false;
                        }
                    }
                    this.isConstructor = false;
                }
            }
            if (this.lastType == null && this.lastPkg == null) {
                cont = false;
            }
            return cont;
        }

        private List filterGenericTypeArguments(List res) {
            if (this.typeBounds != null && this.typeBounds.size() > 0) {
                ArrayList tmp = new ArrayList();
                Iterator it = res.iterator();
                while (it.hasNext()) {
                    Object o = it.next();
                    boolean toAdd = true;
                    if (o instanceof JavaClass) {
                        Iterator itt = this.typeBounds.iterator();
                        while (itt.hasNext()) {
                            JavaClass bound = (JavaClass)itt.next();
                            if (this.jmiUtils.isAssignable((Type)((JavaClass)o), (Type)bound)) continue;
                            toAdd = false;
                            break;
                        }
                    }
                    if (!toAdd) continue;
                    tmp.add(o);
                }
                res = tmp;
            }
            return res;
        }

        private Set getAnnotationMemberNames(JCExpression item) {
            HashSet<String> names = new HashSet<String>();
            int parmCnt = item.getParameterCount();
            if (parmCnt > 1) {
                for (int i = 1; i < parmCnt; ++i) {
                    JCExpression parm = item.getParameter(i);
                    if (parm.getExpID() != 2 || parm.getParameterCount() <= 0) continue;
                    names.add(parm.getParameter(0).getTokenText(0));
                }
            }
            return names;
        }

        private List getTypeList(JCExpression item, int firstChildIdx, boolean allowNullItems) {
            int parmCnt = item.getParameterCount();
            ArrayList<Type> typeList = new ArrayList<Type>();
            if (parmCnt > firstChildIdx) {
                for (int i = firstChildIdx; i < parmCnt; ++i) {
                    JCExpression parm = item.getParameter(i);
                    Type typ = this.resolveType(parm, false);
                    if (typ == null && !allowNullItems) {
                        return null;
                    }
                    typeList.add(typ);
                }
            }
            return typeList;
        }

        private String formatTypeList(List typeList, boolean methodOpen) {
            StringBuffer sb = new StringBuffer();
            if (typeList == null) {
                sb.append('?');
            } else if (typeList.size() > 0) {
                int cntM1 = typeList.size() - 1;
                for (int i = 0; i <= cntM1; ++i) {
                    Type t = (Type)typeList.get(i);
                    if (t != null) {
                        sb.append(this.formatType(t, false, false, false));
                    } else {
                        sb.append('?');
                    }
                    if (i >= cntM1) continue;
                    sb.append(", ");
                }
                if (methodOpen) {
                    sb.append(", *");
                }
            } else if (methodOpen) {
                sb.append("*");
            }
            return sb.toString();
        }

        private List findFieldsMethodsAndInnerClasses(Type type, String name, boolean exactMatch, boolean inspectOuterClasses, JavaClass context, boolean staticContext, boolean thisContext, JCExpression exp, Collection localVarNames, boolean simple, boolean isInstanceCreationCtx) {
            ArrayList ret = new ArrayList();
            Iterator it = this.jmiUtils.findFeatures(type, name, exactMatch, inspectOuterClasses, context, staticContext, thisContext, exp, true, true, isInstanceCreationCtx, true).iterator();
            while (it.hasNext()) {
                Object f = it.next();
                if (!(f instanceof NbJMIResultItem.MethodResultItem) && (!(f instanceof NbJMIResultItem.FieldResultItem) || localVarNames != null && localVarNames.contains(((NbJMIResultItem.FieldResultItem)f).getFieldName())) && (!staticContext && !simple || !(f instanceof NbJMIResultItem.ClassResultItem))) continue;
                ret.add(f);
            }
            return ret;
        }

        private List findInnerClasses(Type type, String name, boolean exactMatch, boolean inspectOuterClasses, JavaClass context, boolean thisContext, boolean createResultItems, boolean preferSources, boolean isInstanceCreationCtx) {
            return this.jmiUtils.findInnerClasses(type, name, exactMatch, inspectOuterClasses, context, thisContext, createResultItems, preferSources, false);
        }

        private List findStaticallyImportedFeatures(String name, boolean exactMatch, JavaClass context, boolean isThisContext) {
            List ret = this.jmiUtils.getStaticallyImportedFields(name, exactMatch, context, isThisContext);
            ret.addAll(this.jmiUtils.getStaticallyImportedMethods(name, exactMatch, context, isThisContext));
            return ret;
        }

        private List findAnnotationMembers(AnnotationType type, String name, Set namesToSkip) {
            List members = this.jmiUtils.findAnnotationMembers(type, name, false, true, true);
            if (namesToSkip.size() == 0) {
                return members;
            }
            ArrayList<NbJMIResultItem.AttributeResultItem> ret = new ArrayList<NbJMIResultItem.AttributeResultItem>();
            Iterator it = members.iterator();
            while (it.hasNext()) {
                NbJMIResultItem.AttributeResultItem attr = (NbJMIResultItem.AttributeResultItem)it.next();
                if (namesToSkip.contains(attr.getAttrName())) continue;
                ret.add(attr);
            }
            return ret;
        }

        private List findConstMembers(Type type, String name, boolean exactMatch, JavaClass context) {
            List flds = this.jmiUtils.findFields(type, name, exactMatch, true, context, true, false, false, true);
            flds.addAll(this.jmiUtils.getStaticallyImportedFields(name, exactMatch, context, false));
            ArrayList<Field> ret = new ArrayList<Field>();
            Iterator it = flds.iterator();
            while (it.hasNext()) {
                Field field = (Field)it.next();
                if (!Modifier.isFinal(field.getModifiers())) continue;
                ret.add(field);
            }
            return ret;
        }
    }
}

