/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.palette;

import java.awt.Component;
import java.awt.Container;
import java.util.StringTokenizer;
import javax.swing.JTree;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.html.HTMLSyntaxSupport;
import org.netbeans.editor.ext.html.HTMLTokenContext;
import org.openide.filesystems.FileObject;

public final class HTMLPaletteUtilities {
    public static int wrapTags(HTMLSyntaxSupport sup, int start, int end, BaseDocument doc) {
        try {
            TokenItem token = sup.getTokenChain(start, start + 1);
            if (token == null) {
                return end;
            }
            while (token.getOffset() < end) {
                if ((token = token.getNext()).getTokenID() != HTMLTokenContext.TAG_OPEN_SYMBOL) continue;
                int offset = token.getOffset();
                doc.insertString(offset, "\n", null);
                ++end;
                token = sup.getTokenChain(offset + 1, offset + 2);
            }
        }
        catch (IllegalStateException ise) {
        }
        catch (BadLocationException ble) {
            // empty catch block
        }
        return end;
    }

    public static SourceGroup[] getSourceGroups(FileObject fObj) {
        Project proj = FileOwnerQuery.getOwner((FileObject)fObj);
        SourceGroup[] sg = new SourceGroup[]{};
        if (proj != null) {
            Sources sources = ProjectUtils.getSources((Project)proj);
            sg = sources.getSourceGroups("doc_root");
        }
        return sg;
    }

    public static JTree findTreeComponent(Component component) {
        if (component instanceof JTree) {
            return (JTree)component;
        }
        if (component instanceof Container) {
            Component[] components = ((Container)component).getComponents();
            for (int i = 0; i < components.length; ++i) {
                JTree tree = HTMLPaletteUtilities.findTreeComponent(components[i]);
                if (tree == null) continue;
                return tree;
            }
        }
        return null;
    }

    public static String getRelativePath(FileObject base, FileObject target) {
        String targetDisc;
        String DELIM = "/";
        String PARENT = "../";
        String targetPath = target.getPath();
        String basePath = base.getPath();
        String baseDisc = basePath.substring(0, basePath.indexOf("/"));
        if (!baseDisc.equals(targetDisc = targetPath.substring(0, targetPath.indexOf("/")))) {
            return "";
        }
        basePath = basePath.substring(0, basePath.lastIndexOf(base.getNameExt()));
        targetPath = targetPath.substring(0, targetPath.lastIndexOf(target.getNameExt()));
        StringTokenizer baseST = new StringTokenizer(basePath, "/");
        StringTokenizer targetST = new StringTokenizer(targetPath, "/");
        String baseDir = "";
        String targetDir = "";
        while (baseST.hasMoreTokens() && targetST.hasMoreTokens() && baseDir.equals(targetDir)) {
            baseDir = baseST.nextToken();
            targetDir = targetST.nextToken();
        }
        StringBuffer parentPrefix = new StringBuffer(!baseDir.equals(targetDir) ? "../" : "");
        while (baseST.hasMoreTokens()) {
            parentPrefix.append("../");
            baseST.nextToken();
        }
        StringBuffer targetSB = new StringBuffer(!baseDir.equals(targetDir) ? targetDir + "/" : "");
        while (targetST.hasMoreTokens()) {
            targetSB.append(targetST.nextToken() + "/");
        }
        targetPath = parentPrefix.toString() + targetSB.toString() + target.getNameExt();
        return targetPath;
    }

    public static void insert(String s, JTextComponent target) throws BadLocationException {
        HTMLPaletteUtilities.insert(s, target, true);
    }

    public static void insert(String s, JTextComponent target, boolean reformat) throws BadLocationException {
        Document doc;
        if (s == null) {
            s = "";
        }
        if ((doc = target.getDocument()) == null) {
            return;
        }
        if (doc instanceof BaseDocument) {
            ((BaseDocument)doc).atomicLock();
        }
        int start = HTMLPaletteUtilities.insert(s, target, doc);
        if (reformat && start >= 0 && doc instanceof BaseDocument) {
            int end = start + s.length();
            Formatter f = ((BaseDocument)doc).getFormatter();
            f.reformat((BaseDocument)doc, start, end);
        }
        if (doc instanceof BaseDocument) {
            ((BaseDocument)doc).atomicUnlock();
        }
    }

    private static int insert(String s, JTextComponent target, Document doc) throws BadLocationException {
        int start = -1;
        try {
            Caret caret = target.getCaret();
            int p0 = Math.min(caret.getDot(), caret.getMark());
            int p1 = Math.max(caret.getDot(), caret.getMark());
            doc.remove(p0, p1 - p0);
            start = caret.getDot();
            doc.insertString(start, s, null);
        }
        catch (BadLocationException ble) {
            // empty catch block
        }
        return start;
    }
}

