/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.palette.items;

import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.html.palette.HTMLPaletteUtilities;
import org.netbeans.modules.html.palette.items.ACustomizer;
import org.openide.text.ActiveEditorDrop;
import org.openide.util.NbBundle;

public class A
implements ActiveEditorDrop {
    public static final String[] protocols = new String[]{"file", "http", "https", "ftp", "mailto"};
    public static final int PROTOCOL_DEFAULT = 0;
    public static final String[] targets = new String[]{NbBundle.getMessage((Class)A.class, (String)"LBL_SameFrame"), NbBundle.getMessage((Class)A.class, (String)"LBL_NewWindow"), NbBundle.getMessage((Class)A.class, (String)"LBL_ParentFrame"), NbBundle.getMessage((Class)A.class, (String)"LBL_FullWindow")};
    public static final int TARGET_DEFAULT = 0;
    private int protocolIndex = 0;
    private String url = "";
    private String text = "";
    private int targetIndex = 0;
    private String target = "";

    public boolean handleTransfer(JTextComponent targetComponent) {
        ACustomizer c = new ACustomizer(this, targetComponent);
        boolean accept = c.showDialog();
        if (accept) {
            String body = this.createBody();
            try {
                HTMLPaletteUtilities.insert(body, targetComponent);
            }
            catch (BadLocationException ble) {
                accept = false;
            }
        }
        return accept;
    }

    private String createBody() {
        String strProtocol = " href=\"";
        if (this.getProtocolIndex() != 0) {
            try {
                switch (this.getProtocolIndex()) {
                    case 1: {
                        strProtocol = strProtocol + "http://";
                        break;
                    }
                    case 2: {
                        strProtocol = strProtocol + "https://";
                        break;
                    }
                    case 3: {
                        strProtocol = strProtocol + "ftp://";
                        break;
                    }
                    case 4: {
                        strProtocol = strProtocol + "mailto:";
                    }
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        String strURL = "\"";
        if (this.getUrl().length() > 0) {
            strURL = this.getUrl() + "\"";
        }
        strProtocol = strProtocol + strURL;
        String strTarget = "";
        if (this.targetIndex != -1 && this.targetIndex != 0) {
            try {
                switch (this.getTargetIndex()) {
                    case 1: {
                        this.setTarget("_blank");
                        break;
                    }
                    case 2: {
                        this.setTarget("_parent");
                        break;
                    }
                    case 3: {
                        this.setTarget("_top");
                    }
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if (this.getTarget().length() > 0) {
            strTarget = " target=\"" + this.getTarget() + "\"";
        }
        String aLink = "<a" + strProtocol + strTarget + ">" + this.getText() + "</a>";
        return aLink;
    }

    public int getProtocolIndex() {
        return this.protocolIndex;
    }

    public void setProtocolIndex(int protocolIndex) {
        this.protocolIndex = protocolIndex;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public int getTargetIndex() {
        return this.targetIndex;
    }

    public void setTargetIndex(int targetIndex) {
        this.targetIndex = targetIndex;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }
}

