/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.html;

import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.html.HTMLSyntaxSupport;
import org.netbeans.editor.ext.html.HTMLTokenContext;

class HTMLAutoCompletion {
    private static int equalsSignInsertedOffset = -1;

    HTMLAutoCompletion() {
    }

    static void charInserted(BaseDocument doc, int dotPos, Caret caret, char ch) throws BadLocationException {
        if (doc.getSyntaxSupport() instanceof ExtSyntaxSupport) {
            if (ch == '=') {
                HTMLAutoCompletion.completeQuotes(doc, dotPos, caret, ch);
            } else if (ch == '\"') {
                HTMLAutoCompletion.handleQuotationMark(doc, dotPos, caret, ch);
            } else {
                equalsSignInsertedOffset = -1;
            }
        }
    }

    static void charDeleted(BaseDocument doc, int dotPos, Caret caret, char ch) {
        equalsSignInsertedOffset = -1;
    }

    private static void handleQuotationMark(BaseDocument doc, int dotPos, Caret caret, char ch) throws BadLocationException {
        if (equalsSignInsertedOffset != -1) {
            if (dotPos == equalsSignInsertedOffset + "=\"".length()) {
                doc.remove(dotPos, 1);
                caret.setDot(dotPos);
            }
        } else {
            TokenItem token = ((HTMLSyntaxSupport)doc.getSyntaxSupport()).getTokenChain(dotPos - 1, dotPos);
            if (token != null && token.getTokenID() == HTMLTokenContext.VALUE && "\"\"".equals(doc.getText(dotPos, 2))) {
                doc.remove(dotPos, 1);
                caret.setDot(dotPos + 1);
            }
        }
        equalsSignInsertedOffset = -1;
    }

    private static void completeQuotes(BaseDocument doc, int dotPos, Caret caret, char ch) throws BadLocationException {
        TokenItem token = ((HTMLSyntaxSupport)doc.getSyntaxSupport()).getTokenChain(dotPos - 1, dotPos);
        int dotPosAfterTypedChar = dotPos + 1;
        if (token != null && token.getTokenID() == HTMLTokenContext.ARGUMENT) {
            doc.insertString(dotPosAfterTypedChar, "\"\"", null);
            caret.setDot(dotPosAfterTypedChar + 1);
            equalsSignInsertedOffset = dotPos;
        }
    }
}

